/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.sqlenv;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.sqlenv.ESQLDataObjectType;
import gudusoft.gsqlparser.sqlenv.TSQLCatalog;
import gudusoft.gsqlparser.sqlenv.TSQLFunction;
import gudusoft.gsqlparser.sqlenv.TSQLObject;
import gudusoft.gsqlparser.sqlenv.TSQLProcedure;
import gudusoft.gsqlparser.sqlenv.TSQLSchema;
import gudusoft.gsqlparser.sqlenv.TSQLSchemaObject;
import gudusoft.gsqlparser.sqlenv.TSQLTable;
import gudusoft.gsqlparser.sqlenv.TSQLTrigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class TSQLEnv {
    private boolean enableGetMetadataFromDDL = true;
    private EDbVendor dbVendor;
    private String serverName = null;
    private List<TSQLCatalog> catalogList = new ArrayList<TSQLCatalog>();
    private HashMap<String, TSQLSchemaObject> schemaObjectList = new HashMap();
    private String defaultCatalogName = null;
    private String defaultSchemaName = null;
    public static final String DEFAULT_DB_NAME = "DEFAULT";
    public static final String DEFAULT_SCHEMA_NAME = "DEFAULT";

    public void setEnableGetMetadataFromDDL(boolean enableGetMetadataFromDDL) {
        this.enableGetMetadataFromDDL = enableGetMetadataFromDDL;
    }

    public boolean isEnableGetMetadataFromDDL() {
        return this.enableGetMetadataFromDDL;
    }

    public TSQLEnv(EDbVendor dbVendor) {
        this.dbVendor = dbVendor;
    }

    public EDbVendor getDBVendor() {
        return this.dbVendor;
    }

    public abstract void initSQLEnv();

    public List<TSQLCatalog> getCatalogList() {
        return this.catalogList;
    }

    protected boolean doAddCatalog(TSQLCatalog sqlCatalog) {
        boolean isFound = false;
        for (TSQLCatalog c : this.catalogList) {
            if (sqlCatalog.getName().compareTo(c.getName()) != 0) continue;
            isFound = true;
            break;
        }
        if (!isFound) {
            this.catalogList.add(sqlCatalog);
        }
        return !isFound;
    }

    protected boolean putSchemaObject(String schemaObjectName, TSQLSchemaObject schemaObject) {
        this.schemaObjectList.put(schemaObjectName, schemaObject);
        return true;
    }

    protected TSQLSchemaObject searchSchemaObject(String qualifiedName) {
        TSQLSchemaObject result = null;
        Object schemaObject = null;
        String[] parts = qualifiedName.split("\\.");
        String catalog = TSQLObject.normalizeIdentifier(this, ESQLDataObjectType.dotCatalog, parts[0]);
        String schema = TSQLObject.normalizeIdentifier(this, ESQLDataObjectType.dotSchema, parts[1]);
        String table = TSQLObject.normalizeIdentifier(this, ESQLDataObjectType.dotTable, parts[2]);
        String normalizedCurrentCatalogName = TSQLObject.normalizeIdentifier(this, ESQLDataObjectType.dotCatalog, this.defaultCatalogName);
        String normalizedCurrentSchemaName = TSQLObject.normalizeIdentifier(this, ESQLDataObjectType.dotSchema, this.defaultSchemaName);
        if (catalog.length() > 0 && schema.length() > 0) {
            result = this.doSearchSchemaObject(catalog + "." + schema + "." + table);
        } else if (schema.length() > 0) {
            if (this.defaultCatalogName != null) {
                result = this.doSearchSchemaObject(normalizedCurrentCatalogName + "." + schema + "." + table);
            } else {
                for (TSQLCatalog c : this.catalogList) {
                    result = this.doSearchSchemaObject(c.name + "." + schema + "." + table);
                    if (result == null) continue;
                    break;
                }
            }
        } else if (catalog.length() > 0) {
            if (this.defaultSchemaName != null) {
                result = this.doSearchSchemaObject(catalog + "." + normalizedCurrentSchemaName + "." + table);
            } else {
                for (TSQLCatalog c : this.catalogList) {
                    TSQLSchema s;
                    if (c.compareTo(catalog) != 0) continue;
                    Iterator<TSQLSchema> iterator = c.getSchemaList().iterator();
                    while (iterator.hasNext() && (result = this.doSearchSchemaObject((s = iterator.next()).getQualifiedName() + "." + table)) == null) {
                    }
                    if (result == null) continue;
                    break;
                }
            }
        } else {
            for (TSQLCatalog c : this.catalogList) {
                if (this.defaultCatalogName != null && c.compareTo(this.defaultCatalogName) != 0) continue;
                for (TSQLSchema s : c.getSchemaList()) {
                    if (this.defaultSchemaName != null && s.compareTo(this.defaultSchemaName) != 0 || (result = this.doSearchSchemaObject(s.getQualifiedName() + "." + table)) == null) continue;
                    break;
                }
                if (result == null) continue;
                break;
            }
        }
        return result;
    }

    public TSQLTable searchTable(String qualifiedTablename) {
        TSQLSchemaObject result = this.searchSchemaObject(qualifiedTablename);
        if (result instanceof TSQLTable) {
            return (TSQLTable)result;
        }
        return null;
    }

    private TSQLSchemaObject doSearchSchemaObject(String qualifiedName) {
        return this.schemaObjectList.get(qualifiedName);
    }

    public String getDefaultCatalogName() {
        return this.defaultCatalogName;
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public void setDefaultCatalogName(String defaultCatalogName) {
        this.defaultCatalogName = defaultCatalogName;
    }

    public void setDefaultSchemaName(String defaultSchemaName) {
        this.defaultSchemaName = defaultSchemaName;
    }

    public TSQLCatalog createSQLCatalog(String catalogName) {
        return this.getSQLCatalog(catalogName, true);
    }

    public TSQLCatalog getSQLCatalog(String catalogName, boolean createIfNotExist) {
        TSQLCatalog result = this.searchCatalog(catalogName);
        if (createIfNotExist && result == null) {
            result = new TSQLCatalog(this, catalogName);
        }
        return result;
    }

    public TSQLCatalog searchCatalog(String catalogName) {
        TSQLCatalog result = null;
        for (TSQLCatalog c : this.catalogList) {
            if (c.compareTo(catalogName) != 0) continue;
            result = c;
            break;
        }
        return result;
    }

    public TSQLSchema createSQLSchema(String qualifiedSchemaName) {
        return this.getSQLSchema(qualifiedSchemaName, true);
    }

    public TSQLSchema getSQLSchema(String qualifiedSchemaName, boolean createIfNotExist) {
        Object result = null;
        String[] parts = qualifiedSchemaName.split("\\.");
        String catalogName = parts[0];
        String schemaName = parts[1];
        TSQLCatalog catalog = this.getSQLCatalog(catalogName, createIfNotExist);
        return catalog.getSchema(schemaName, createIfNotExist);
    }

    public boolean columnInTable(String qualifiedTablename, String columnName) {
        TSQLTable tsqlTable = this.searchTable(qualifiedTablename);
        if (tsqlTable == null) {
            return false;
        }
        return tsqlTable.searchColumn(columnName);
    }

    public TSQLSchemaObject doAddSchemaObject(String qualifiedObjectName, ESQLDataObjectType objectType) {
        String schema;
        String db;
        String string = db = TSQLEnv.getDatabaseName(qualifiedObjectName) == null ? this.getDefaultCatalogName() : TSQLEnv.getDatabaseName(qualifiedObjectName);
        if (db == null || db.length() == 0) {
            db = "DEFAULT";
        }
        String string2 = schema = TSQLEnv.getSchemaName(qualifiedObjectName) == null ? this.getDefaultSchemaName() : TSQLEnv.getSchemaName(qualifiedObjectName);
        if (schema == null || schema.length() == 0) {
            schema = "DEFAULT";
        }
        TSQLCatalog sqlCatalog = this.createSQLCatalog(db);
        TSQLSchema sqlSchema = sqlCatalog.createSchema(schema);
        return sqlSchema.createSchemaObject(TSQLEnv.getObjectName(qualifiedObjectName), objectType);
    }

    public TSQLFunction addFunction(String qualifiedFunctionName, boolean fromDDL) {
        if (fromDDL && !this.isEnableGetMetadataFromDDL()) {
            return null;
        }
        return (TSQLFunction)this.doAddSchemaObject(qualifiedFunctionName, ESQLDataObjectType.dotFunction);
    }

    public TSQLProcedure addProcedure(String qualifiedProcedureName, boolean fromDDL) {
        if (fromDDL && !this.isEnableGetMetadataFromDDL()) {
            return null;
        }
        return (TSQLProcedure)this.doAddSchemaObject(qualifiedProcedureName, ESQLDataObjectType.dotProcedure);
    }

    public TSQLTrigger addTrigger(String qualifiedTriggerName, boolean fromDDL) {
        if (fromDDL && !this.isEnableGetMetadataFromDDL()) {
            return null;
        }
        return (TSQLTrigger)this.doAddSchemaObject(qualifiedTriggerName, ESQLDataObjectType.dotTrigger);
    }

    public TSQLTable addTable(String qualifiedTableName, boolean fromDDL) {
        if (fromDDL && !this.isEnableGetMetadataFromDDL()) {
            return null;
        }
        return (TSQLTable)this.doAddSchemaObject(qualifiedTableName, ESQLDataObjectType.dotTable);
    }

    public TSQLTable addView(String qualifiedViewName, boolean fromDDL) {
        if (fromDDL && !this.isEnableGetMetadataFromDDL()) {
            return null;
        }
        TSQLTable tsqlTable = (TSQLTable)this.doAddSchemaObject(qualifiedViewName, ESQLDataObjectType.dotTable);
        tsqlTable.setView(true);
        return tsqlTable;
    }

    public static String getObjectName(String schemaObjectName) {
        String[] names = schemaObjectName.split("[.]");
        return names[names.length - 1];
    }

    public static String getDatabaseName(String schemaObjectName) {
        String[] names = schemaObjectName.split("[.]");
        if (names.length == 3) {
            return names[0];
        }
        if (names.length == 4) {
            return names[1];
        }
        return null;
    }

    public static String getSchemaName(String schemaObjectName) {
        String[] names = schemaObjectName.split("[.]");
        if (names.length == 2) {
            return names[0];
        }
        if (names.length == 3) {
            return names[1];
        }
        if (names.length == 4) {
            return names[2];
        }
        return null;
    }

    public TSQLFunction searchFunction(String qualifiedTablename) {
        TSQLSchemaObject result = this.searchSchemaObject(this.qualifySchemaObjectName(qualifiedTablename));
        if (result instanceof TSQLFunction) {
            return (TSQLFunction)result;
        }
        return null;
    }

    public String qualifySchemaObjectName(String schemaObjectName) {
        if (schemaObjectName.split("[.]").length == 3) {
            return schemaObjectName;
        }
        String schema = this.getDefaultSchemaName() == null ? "" : this.getDefaultSchemaName();
        String db = this.getDefaultCatalogName() == null ? "" : this.getDefaultCatalogName();
        String[] names = schemaObjectName.split("[.]");
        if (names.length == 1) {
            return db + "." + schema + "." + schemaObjectName;
        }
        if (names.length == 2) {
            return db + "." + names[0] + "." + names[1];
        }
        return schemaObjectName;
    }

    public String toString() {
        String lcResult = "";
        StringBuilder tables = new StringBuilder();
        StringBuilder views = new StringBuilder();
        StringBuilder functions = new StringBuilder();
        StringBuilder procedures = new StringBuilder();
        for (int i = 0; i < this.getCatalogList().size(); ++i) {
            TSQLCatalog tsqlCatalog = this.getCatalogList().get(i);
            lcResult = lcResult + "\ndatabase:" + tsqlCatalog.getName();
            for (int j = 0; j < tsqlCatalog.getSchemaList().size(); ++j) {
                TSQLSchema tsqlSchema = tsqlCatalog.getSchemaList().get(j);
                lcResult = lcResult + "\n\tschema:" + tsqlSchema.getName();
                block7: for (int k = 0; k < tsqlSchema.getSchemaObjectList().size(); ++k) {
                    TSQLSchemaObject schemaObject = tsqlSchema.getSchemaObjectList().get(k);
                    switch (schemaObject.getDataObjectType()) {
                        case dotTable: {
                            int m;
                            TSQLTable tsqlTable = (TSQLTable)schemaObject;
                            if (tsqlTable.isView()) {
                                views.append("\n\t\t\t" + schemaObject.getName());
                                for (m = 0; m < tsqlTable.getColumnList().size(); ++m) {
                                    views.append("\n\t\t\t\t" + tsqlTable.getColumnList().get(m).getName());
                                }
                                continue block7;
                            }
                            tables.append("\n\t\t\t" + schemaObject.getName());
                            for (m = 0; m < tsqlTable.getColumnList().size(); ++m) {
                                tables.append("\n\t\t\t\t" + tsqlTable.getColumnList().get(m).getName());
                            }
                            continue block7;
                        }
                        case dotProcedure: {
                            procedures.append("\n\t\t\t" + schemaObject.getName());
                            continue block7;
                        }
                        case dotFunction: {
                            functions.append("\n\t\t\t" + schemaObject.getName());
                        }
                    }
                }
                lcResult = lcResult + "\n\t\ttables:" + tables.toString();
                lcResult = lcResult + "\n\t\tviews:" + views.toString();
                lcResult = lcResult + "\n\t\tprocedure:" + procedures.toString();
                lcResult = lcResult + "\n\t\tfunction:" + functions.toString();
                tables.setLength(0);
                views.setLength(0);
                procedures.setLength(0);
                functions.setLength(0);
            }
        }
        return lcResult;
    }
}

