/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.sqlenv;

import gudusoft.gsqlparser.sqlenv.ESQLDataObjectType;
import gudusoft.gsqlparser.sqlenv.TSQLEnv;
import gudusoft.gsqlparser.sqlenv.TSQLObject;
import gudusoft.gsqlparser.sqlenv.TSQLSchema;
import java.util.ArrayList;
import java.util.List;

public class TSQLCatalog
extends TSQLObject {
    private List<TSQLSchema> schemaList = new ArrayList<TSQLSchema>();

    public TSQLCatalog(TSQLEnv sqlEnv, String catalogName) {
        super(sqlEnv, catalogName);
        this.dataObjectType = ESQLDataObjectType.dotCatalog;
        this.sqlEnv.doAddCatalog(this);
    }

    public List<TSQLSchema> getSchemaList() {
        return this.schemaList;
    }

    protected TSQLSchema searchSchema(String schemaName) {
        TSQLSchema result = null;
        for (TSQLSchema s : this.schemaList) {
            if (s.compareTo(schemaName) != 0) continue;
            result = s;
            break;
        }
        return result;
    }

    protected void addSchema(TSQLSchema sqlSchema) {
        if (this.searchSchema(sqlSchema.name) == null) {
            this.schemaList.add(sqlSchema);
        }
    }

    public TSQLSchema getSchema(String schemaName, boolean createIfNotExist) {
        TSQLSchema result = this.searchSchema(schemaName);
        if (result == null && createIfNotExist) {
            result = new TSQLSchema(this, schemaName);
        }
        return result;
    }

    public TSQLSchema createSchema(String schemaName) {
        return this.getSchema(schemaName, true);
    }
}

