/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.scriptWriter;

import gudusoft.gsqlparser.EComparisonType;
import gudusoft.gsqlparser.EExpressionType;
import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TBaseType;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSourceTokenList;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class TScriptWriter {
    private List<TSourceToken> tokenList = new ArrayList<TSourceToken>();

    public void TScriptWriter() {
    }

    public void addComparisonOperator(EComparisonType comparisonType) {
        this.addSpace(1);
        switch (comparisonType) {
            case equals: {
                this.addSymbol("=");
                break;
            }
            case greaterThan: {
                this.addSymbol(">");
                break;
            }
            case lessThan: {
                this.addSymbol("<");
                break;
            }
            case notEqualToBrackets: {
                this.addSymbol("<>");
                break;
            }
            case notEqualToCaret: {
                this.addSymbol("^=");
                break;
            }
            case notEqualToExclamation: {
                this.addSymbol("!=");
                break;
            }
            case greaterThanOrEqualTo: {
                this.addSymbol(">=");
                break;
            }
            case lessThanOrEqualTo: {
                this.addSymbol("<=");
                break;
            }
            case notGreaterThan: {
                this.addSymbol("!>");
                break;
            }
            case notGreaterThanToCaret: {
                this.addSymbol("^>");
                break;
            }
            case notLessThan: {
                this.addSymbol("!<");
                break;
            }
            case notLessThanToCaret: {
                this.addSymbol("^<");
                break;
            }
        }
        this.addSpace(1);
    }

    public void addUnaryOperator(EExpressionType expressionType) {
        switch (expressionType) {
            case unary_plus_t: {
                this.addSymbol("+");
                break;
            }
            case unary_minus_t: {
                this.addSymbol("-");
                break;
            }
            case unary_bitwise_not_t: {
                this.addSymbol("~");
                break;
            }
            case unary_prior_t: {
                this.addKeyword("prior");
                break;
            }
            case unary_connect_by_root_t: {
                this.addKeyword("connect_by_root");
                break;
            }
        }
    }

    public void addBinaryOperator(EExpressionType expressionType) {
        if (expressionType == EExpressionType.collate_t) {
            this.addKeyword("COLLATE");
            return;
        }
        this.addSpace(1);
        switch (expressionType) {
            case arithmetic_plus_t: {
                this.addSymbol("+");
                break;
            }
            case arithmetic_minus_t: {
                this.addSymbol("-");
                break;
            }
            case arithmetic_times_t: {
                this.addSymbol("*");
                break;
            }
            case arithmetic_divide_t: {
                this.addSymbol("/");
                break;
            }
            case arithmetic_modulo_t: {
                this.addSymbol("%");
                break;
            }
            case bitwise_and_t: {
                this.addSymbol("&");
                break;
            }
            case bitwise_or_t: {
                this.addSymbol("|");
                break;
            }
            case bitwise_exclusive_or_t: {
                this.addSymbol("^");
                break;
            }
            case bitwise_xor_t: {
                this.addSymbol("#");
                break;
            }
            case logical_and_t: {
                this.addKeyword("and");
                break;
            }
            case logical_or_t: {
                this.addKeyword("or");
                break;
            }
            case concatenate_t: {
                this.addSymbol("||");
                break;
            }
            case sqlserver_proprietary_column_alias_t: {
                this.addSymbol("=");
                break;
            }
            case left_join_t: {
                this.addSymbol("*=");
                break;
            }
            case right_join_t: {
                this.addSymbol("=*");
            }
        }
        this.addSpace(1);
    }

    public void reset() {
        this.tokenList.clear();
    }

    public void writeTo(Writer writer) {
        for (TSourceToken st : this.tokenList) {
            try {
                writer.write(st.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean verifyTokens(TSourceTokenList originalTokens, boolean partialChecking) {
        int i;
        boolean result = true;
        int old = 0;
        boolean startParenthesis = false;
        int nestedParenthesis = 0;
        for (i = 0; i < this.tokenList.size(); ++i) {
            if (this.tokenList.get((int)i).tokentype == ETokenType.ttkeyword && i != this.tokenList.size() - 1) {
                if (this.tokenList.get((int)(i + 1)).tokencode == 260 || this.tokenList.get((int)(i + 1)).tokencode == 259 || this.tokenList.get((int)(i + 1)).tokencode == 40 || this.tokenList.get((int)(i + 1)).tokencode == 41) continue;
                System.out.print("lack space after keyword:" + this.tokenList.get(i).toString());
                result = false;
                break;
            }
            if (this.tokenList.get((int)i).tokentype != ETokenType.ttidentifier || i == 0 || this.tokenList.get((int)(i - 1)).tokentype != ETokenType.ttkeyword && this.tokenList.get((int)(i - 1)).tokentype != ETokenType.ttidentifier) continue;
            System.out.print("lack space between identifier and keyword:" + this.tokenList.get(i).toString());
            result = false;
            break;
        }
        if (!result) {
            return result;
        }
        for (i = 0; i < originalTokens.size(); ++i) {
            if (originalTokens.get((int)i).tokencode == 260 || originalTokens.get((int)i).tokencode == 259 || originalTokens.get((int)i).tokentype == ETokenType.ttsimplecomment || originalTokens.get((int)i).tokentype == ETokenType.ttbracketedcomment || originalTokens.get((int)i).tokentype == ETokenType.ttsemicolon) continue;
            if (partialChecking) {
                if (originalTokens.get((int)i).tokencode == 40) {
                    startParenthesis = true;
                    ++nestedParenthesis;
                } else if (originalTokens.get((int)i).tokencode == 41) {
                    if (nestedParenthesis > 0) {
                        --nestedParenthesis;
                    }
                    if (nestedParenthesis == 0 && startParenthesis) {
                        result = true;
                        break;
                    }
                }
            }
            result = false;
            for (int j = old; j < this.tokenList.size(); ++j) {
                if (this.tokenList.get((int)j).tokencode == 260 || this.tokenList.get((int)j).tokencode == 259 || this.tokenList.get((int)j).tokentype == ETokenType.ttsimplecomment || this.tokenList.get((int)j).tokentype == ETokenType.ttbracketedcomment || this.tokenList.get((int)j).tokentype == ETokenType.ttsemicolon) continue;
                result = originalTokens.get((int)i).tokencode == 289 && this.tokenList.get((int)j).tokencode == 289 ? true : originalTokens.get(i).toString().equalsIgnoreCase(this.tokenList.get(j).toString());
                old = j + 1;
                break;
            }
            if (result) continue;
            System.out.print("source token:" + originalTokens.get(i).toString() + "(" + originalTokens.get((int)i).lineNo + "," + originalTokens.get((int)i).columnNo + ")");
            System.out.print(", target token:" + this.tokenList.get(old - 1).toString() + "(" + this.tokenList.get((int)(old - 1)).lineNo + "," + this.tokenList.get((int)(old - 1)).columnNo + ")");
            break;
        }
        return result;
    }

    public void addSymbol(String symbol) {
        TSourceToken st = new TSourceToken(symbol);
        this.addToken(st);
    }

    public void addSymbol(String symbol, int tokenCode) {
        TSourceToken st = new TSourceToken(symbol);
        st.tokencode = tokenCode;
        this.addToken(st);
    }

    public void addToken(TSourceToken st) {
        if (this.tokenList.size() != 0 || st.tokencode != 259 && st.tokencode != 260) {
            this.tokenList.add(st);
        }
    }

    public void addSpace(int count) {
        TSourceToken st = new TSourceToken(String.format("%" + count + "s", " "));
        st.tokencode = 259;
        this.addToken(st);
    }

    public void addNewline() {
        TSourceToken st = new TSourceToken(TBaseType.linebreak);
        st.tokencode = 260;
        this.addToken(st);
    }

    public void addSemicolon() {
        TSourceToken st = new TSourceToken(";");
        st.tokentype = ETokenType.ttsemicolon;
        this.addToken(st);
    }

    public void addIdentifier(String text) {
        TSourceToken st = new TSourceToken(text);
        st.tokencode = 264;
        st.tokentype = ETokenType.ttidentifier;
        this.addToken(st);
    }

    public void acceptOracleHint(String text) {
        TSourceToken st = new TSourceToken(text);
        st.tokencode = 257;
        st.tokentype = ETokenType.ttbracketedcomment;
        this.addToken(st);
    }

    public void addKeyword(String text) {
        this.addKeyword(text, true);
    }

    public void addKeyword(String text, boolean spaceAround) {
        TSourceToken st = new TSourceToken(text);
        st.tokentype = ETokenType.ttkeyword;
        if (spaceAround) {
            this.addSpace(1);
        }
        this.addToken(st);
        if (spaceAround) {
            this.addSpace(1);
        }
    }

    public void addOperator(String text, ETokenType tokenType) {
        TSourceToken st = new TSourceToken(text);
        st.tokentype = tokenType;
        this.addSpace(1);
        this.addToken(st);
        this.addSpace(1);
    }

    public void addLiteral(String text) {
        TSourceToken st = new TSourceToken(text);
        this.addToken(st);
    }
}

