/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.scriptWriter;

import gudusoft.gsqlparser.EBoundaryType;
import gudusoft.gsqlparser.EComparisonType;
import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.EDeclareType;
import gudusoft.gsqlparser.EExpressionType;
import gudusoft.gsqlparser.EIndexType;
import gudusoft.gsqlparser.EKeyActionType;
import gudusoft.gsqlparser.EKeyReferenceType;
import gudusoft.gsqlparser.ELimitRowType;
import gudusoft.gsqlparser.EProcedureOptionType;
import gudusoft.gsqlparser.EQuantifierType;
import gudusoft.gsqlparser.ERestrictionType;
import gudusoft.gsqlparser.ESortType;
import gudusoft.gsqlparser.ETableKind;
import gudusoft.gsqlparser.EWindowExcludeType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TStatementList;
import gudusoft.gsqlparser.nodes.TAliasClause;
import gudusoft.gsqlparser.nodes.TAlterTableOption;
import gudusoft.gsqlparser.nodes.TCTE;
import gudusoft.gsqlparser.nodes.TCTEList;
import gudusoft.gsqlparser.nodes.TCaseExpression;
import gudusoft.gsqlparser.nodes.TColumnDefinition;
import gudusoft.gsqlparser.nodes.TColumnDefinitionList;
import gudusoft.gsqlparser.nodes.TColumnWithSortOrder;
import gudusoft.gsqlparser.nodes.TComputeClause;
import gudusoft.gsqlparser.nodes.TComputeClauseItem;
import gudusoft.gsqlparser.nodes.TComputeExpr;
import gudusoft.gsqlparser.nodes.TConnectByClause;
import gudusoft.gsqlparser.nodes.TConstant;
import gudusoft.gsqlparser.nodes.TConstraint;
import gudusoft.gsqlparser.nodes.TConstraintList;
import gudusoft.gsqlparser.nodes.TDdlEventItem;
import gudusoft.gsqlparser.nodes.TDeclareVariable;
import gudusoft.gsqlparser.nodes.TDeclareVariableList;
import gudusoft.gsqlparser.nodes.TDmlEventClause;
import gudusoft.gsqlparser.nodes.TDmlEventItem;
import gudusoft.gsqlparser.nodes.TDropIndexItem;
import gudusoft.gsqlparser.nodes.TExecParameter;
import gudusoft.gsqlparser.nodes.TExecParameterList;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TExpressionList;
import gudusoft.gsqlparser.nodes.TForUpdate;
import gudusoft.gsqlparser.nodes.TFunctionCall;
import gudusoft.gsqlparser.nodes.TGroupBy;
import gudusoft.gsqlparser.nodes.TGroupByItem;
import gudusoft.gsqlparser.nodes.TGroupingSet;
import gudusoft.gsqlparser.nodes.TGroupingSetItem;
import gudusoft.gsqlparser.nodes.THierarchical;
import gudusoft.gsqlparser.nodes.TInsertCondition;
import gudusoft.gsqlparser.nodes.TInsertIntoValue;
import gudusoft.gsqlparser.nodes.TIntoClause;
import gudusoft.gsqlparser.nodes.TJoin;
import gudusoft.gsqlparser.nodes.TJoinItem;
import gudusoft.gsqlparser.nodes.TJoinList;
import gudusoft.gsqlparser.nodes.TKeepDenseRankClause;
import gudusoft.gsqlparser.nodes.TKeyAction;
import gudusoft.gsqlparser.nodes.TKeyReference;
import gudusoft.gsqlparser.nodes.TLimitClause;
import gudusoft.gsqlparser.nodes.TMergeDeleteClause;
import gudusoft.gsqlparser.nodes.TMergeInsertClause;
import gudusoft.gsqlparser.nodes.TMergeUpdateClause;
import gudusoft.gsqlparser.nodes.TMergeWhenClause;
import gudusoft.gsqlparser.nodes.TMultiTarget;
import gudusoft.gsqlparser.nodes.TMultiTargetList;
import gudusoft.gsqlparser.nodes.TMySQLCreateTableOption;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TOrderBy;
import gudusoft.gsqlparser.nodes.TOrderByItem;
import gudusoft.gsqlparser.nodes.TOrderByItemList;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParameterDeclaration;
import gudusoft.gsqlparser.nodes.TParameterDeclarationList;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TPivotClause;
import gudusoft.gsqlparser.nodes.TPivotInClause;
import gudusoft.gsqlparser.nodes.TPivotedTable;
import gudusoft.gsqlparser.nodes.TRestrictionClause;
import gudusoft.gsqlparser.nodes.TResultColumn;
import gudusoft.gsqlparser.nodes.TResultColumnList;
import gudusoft.gsqlparser.nodes.TReturningClause;
import gudusoft.gsqlparser.nodes.TRollupCube;
import gudusoft.gsqlparser.nodes.TSelectModifier;
import gudusoft.gsqlparser.nodes.TSimpleDmlTriggerClause;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.nodes.TTableHint;
import gudusoft.gsqlparser.nodes.TTopClause;
import gudusoft.gsqlparser.nodes.TTrimArgument;
import gudusoft.gsqlparser.nodes.TTypeName;
import gudusoft.gsqlparser.nodes.TUnpivotInClause;
import gudusoft.gsqlparser.nodes.TUnpivotInClauseItem;
import gudusoft.gsqlparser.nodes.TVarDeclStmt;
import gudusoft.gsqlparser.nodes.TViewAliasClause;
import gudusoft.gsqlparser.nodes.TViewAliasItem;
import gudusoft.gsqlparser.nodes.TViewAliasItemList;
import gudusoft.gsqlparser.nodes.TWhenClauseItem;
import gudusoft.gsqlparser.nodes.TWhereClause;
import gudusoft.gsqlparser.nodes.TWindowDef;
import gudusoft.gsqlparser.nodes.TWindowFrame;
import gudusoft.gsqlparser.nodes.TWindowFrameBoundary;
import gudusoft.gsqlparser.nodes.mssql.TProcedureOption;
import gudusoft.gsqlparser.nodes.mysql.TGroupConcatParam;
import gudusoft.gsqlparser.nodes.oracle.TInvokerRightsClause;
import gudusoft.gsqlparser.scriptWriter.TScriptWriter;
import gudusoft.gsqlparser.stmt.TAlterTableStatement;
import gudusoft.gsqlparser.stmt.TAssignStmt;
import gudusoft.gsqlparser.stmt.TCreateIndexSqlStatement;
import gudusoft.gsqlparser.stmt.TCreateTableSqlStatement;
import gudusoft.gsqlparser.stmt.TCreateTriggerStmt;
import gudusoft.gsqlparser.stmt.TCreateViewSqlStatement;
import gudusoft.gsqlparser.stmt.TDeleteSqlStatement;
import gudusoft.gsqlparser.stmt.TDropIndexSqlStatement;
import gudusoft.gsqlparser.stmt.TElsifStmt;
import gudusoft.gsqlparser.stmt.TIfStmt;
import gudusoft.gsqlparser.stmt.TInsertSqlStatement;
import gudusoft.gsqlparser.stmt.TMergeSqlStatement;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;
import gudusoft.gsqlparser.stmt.TUpdateSqlStatement;
import gudusoft.gsqlparser.stmt.TUseDatabase;
import gudusoft.gsqlparser.stmt.mssql.TMssqlBlock;
import gudusoft.gsqlparser.stmt.mssql.TMssqlCreateFunction;
import gudusoft.gsqlparser.stmt.mssql.TMssqlCreateProcedure;
import gudusoft.gsqlparser.stmt.mssql.TMssqlDeclare;
import gudusoft.gsqlparser.stmt.mssql.TMssqlExecute;
import gudusoft.gsqlparser.stmt.mssql.TMssqlExecuteAs;
import gudusoft.gsqlparser.stmt.mssql.TMssqlFetch;
import gudusoft.gsqlparser.stmt.mssql.TMssqlIfElse;
import gudusoft.gsqlparser.stmt.mssql.TMssqlLabel;
import gudusoft.gsqlparser.stmt.mssql.TMssqlPrint;
import gudusoft.gsqlparser.stmt.mssql.TMssqlRaiserror;
import gudusoft.gsqlparser.stmt.mssql.TMssqlReturn;
import gudusoft.gsqlparser.stmt.mssql.TMssqlRevert;
import gudusoft.gsqlparser.stmt.mssql.TMssqlRollback;
import gudusoft.gsqlparser.stmt.mssql.TMssqlSet;
import gudusoft.gsqlparser.stmt.mssql.TMssqlStmtStub;
import gudusoft.gsqlparser.stmt.oracle.TPlsqlCreateProcedure;
import java.lang.reflect.Method;

public class TScriptGeneratorVisitor
extends TParseTreeVisitor {
    private TScriptWriter scriptWriter;

    void acceptToken(TSourceToken st) {
        this.scriptWriter.addToken(st);
    }

    void acceptSymbol(String symbol) {
        this.scriptWriter.addSymbol(symbol);
    }

    void acceptSymbol(String symbol, int tokenCode) {
        this.scriptWriter.addSymbol(symbol, tokenCode);
    }

    void acceptKeyword(String keyword) {
        this.scriptWriter.addKeyword(keyword);
    }

    void acceptKeyword(String keyword, boolean spaceAround) {
        this.scriptWriter.addKeyword(keyword, spaceAround);
    }

    void acceptNewline() {
        this.scriptWriter.addNewline();
    }

    void acceptSemicolon() {
        this.scriptWriter.addSemicolon();
    }

    void acceptSpace(int count) {
        this.scriptWriter.addSpace(count);
    }

    void acceptLiteral(String literal) {
        this.scriptWriter.addLiteral(literal);
    }

    void acceptIdentifier(String identifier) {
        this.scriptWriter.addIdentifier(identifier);
    }

    void acceptOracleHint(String identifier) {
        this.scriptWriter.acceptOracleHint(identifier);
    }

    public TScriptGeneratorVisitor(TScriptWriter scriptWriter) {
        this.scriptWriter = scriptWriter;
    }

    @Override
    public void preVisit(TConstant node) {
        switch (node.getLiteralType()) {
            case etNumber: {
                this.acceptToken(node.getValueToken());
                break;
            }
            case etFloat: {
                this.acceptToken(node.getValueToken());
                break;
            }
            case etString: {
                this.acceptToken(node.getValueToken());
                break;
            }
            case etTimestamp: {
                this.acceptKeyword("timestamp");
                this.acceptToken(node.getValueToken());
                break;
            }
            case etDate: {
                this.acceptKeyword("date");
                this.acceptToken(node.getValueToken());
                break;
            }
            case etInterval: {
                this.acceptKeyword("interval");
                this.acceptToken(node.getValueToken());
                switch (node.getIntervalType()) {
                    case itYear: {
                        this.acceptKeyword("year");
                        if (node.getLeadingPrecision() == null) break;
                        this.acceptSymbol("(");
                        this.acceptToken(node.getLeadingPrecision());
                        this.acceptSymbol(")");
                        break;
                    }
                    case itYearToYear: {
                        this.acceptKeyword("year");
                        if (node.getLeadingPrecision() != null) {
                            this.acceptSymbol("(");
                            this.acceptToken(node.getLeadingPrecision());
                            this.acceptSymbol(")");
                        }
                        this.acceptKeyword("to");
                        this.acceptKeyword("year");
                        break;
                    }
                    case itYearToMonth: {
                        this.acceptKeyword("year");
                        if (node.getLeadingPrecision() != null) {
                            this.acceptSymbol("(");
                            this.acceptToken(node.getLeadingPrecision());
                            this.acceptSymbol(")");
                        }
                        this.acceptKeyword("to");
                        this.acceptKeyword("month");
                        break;
                    }
                    case itMonth: {
                        this.acceptKeyword("month");
                        if (node.getLeadingPrecision() == null) break;
                        this.acceptSymbol("(");
                        this.acceptToken(node.getLeadingPrecision());
                        this.acceptSymbol(")");
                        break;
                    }
                    case itMonthToMonth: {
                        this.acceptKeyword("month");
                        if (node.getLeadingPrecision() != null) {
                            this.acceptSymbol("(");
                            this.acceptToken(node.getLeadingPrecision());
                            this.acceptSymbol(")");
                        }
                        this.acceptKeyword("to");
                        this.acceptKeyword("month");
                        break;
                    }
                    case itDay: {
                        this.acceptKeyword("day");
                        if (node.getLeadingPrecision() == null) break;
                        this.acceptSymbol("(");
                        this.acceptToken(node.getLeadingPrecision());
                        this.acceptSymbol(")");
                        break;
                    }
                    case itDayToDay: {
                        this.acceptKeyword("day");
                        if (node.getLeadingPrecision() != null) {
                            this.acceptSymbol("(");
                            this.acceptToken(node.getLeadingPrecision());
                            this.acceptSymbol(")");
                        }
                        this.acceptKeyword("to");
                        this.acceptKeyword("day");
                        break;
                    }
                    case itDayToHour: {
                        this.acceptKeyword("day");
                        if (node.getLeadingPrecision() != null) {
                            this.acceptSymbol("(");
                            this.acceptToken(node.getLeadingPrecision());
                            this.acceptSymbol(")");
                        }
                        this.acceptKeyword("to");
                        this.acceptKeyword("hour");
                        break;
                    }
                    case itDayToMinute: {
                        this.acceptKeyword("day");
                        if (node.getLeadingPrecision() != null) {
                            this.acceptSymbol("(");
                            this.acceptToken(node.getLeadingPrecision());
                            this.acceptSymbol(")");
                        }
                        this.acceptKeyword("to");
                        this.acceptKeyword("minute");
                        break;
                    }
                    case itDayToSecond: {
                        this.acceptKeyword("day");
                        if (node.getLeadingPrecision() != null) {
                            this.acceptSymbol("(");
                            this.acceptToken(node.getLeadingPrecision());
                            this.acceptSymbol(")");
                        }
                        this.acceptKeyword("to");
                        this.acceptKeyword("second");
                        if (node.getFractionalSecondsPrecision() == null) break;
                        this.acceptSymbol("(");
                        this.acceptToken(node.getFractionalSecondsPrecision());
                        this.acceptSymbol(")");
                        break;
                    }
                    case itHour: {
                        this.acceptKeyword("hour");
                        if (node.getLeadingPrecision() == null) break;
                        this.acceptSymbol("(");
                        this.acceptToken(node.getLeadingPrecision());
                        this.acceptSymbol(")");
                        break;
                    }
                    case itHourToHour: {
                        this.acceptKeyword("hour");
                        if (node.getLeadingPrecision() != null) {
                            this.acceptSymbol("(");
                            this.acceptToken(node.getLeadingPrecision());
                            this.acceptSymbol(")");
                        }
                        this.acceptKeyword("to");
                        this.acceptKeyword("hour");
                        break;
                    }
                    case itHourToMinute: {
                        this.acceptKeyword("hour");
                        if (node.getLeadingPrecision() != null) {
                            this.acceptSymbol("(");
                            this.acceptToken(node.getLeadingPrecision());
                            this.acceptSymbol(")");
                        }
                        this.acceptKeyword("to");
                        this.acceptKeyword("minute");
                        break;
                    }
                    case itHourToSecond: {
                        this.acceptKeyword("hour");
                        if (node.getLeadingPrecision() != null) {
                            this.acceptSymbol("(");
                            this.acceptToken(node.getLeadingPrecision());
                            this.acceptSymbol(")");
                        }
                        this.acceptKeyword("to");
                        this.acceptKeyword("second");
                        if (node.getFractionalSecondsPrecision() == null) break;
                        this.acceptSymbol("(");
                        this.acceptToken(node.getFractionalSecondsPrecision());
                        this.acceptSymbol(")");
                        break;
                    }
                    case itMinute: {
                        this.acceptKeyword("minute");
                        if (node.getLeadingPrecision() == null) break;
                        this.acceptSymbol("(");
                        this.acceptToken(node.getLeadingPrecision());
                        this.acceptSymbol(")");
                        break;
                    }
                    case itMinuteToMinute: {
                        this.acceptKeyword("minute");
                        if (node.getLeadingPrecision() != null) {
                            this.acceptSymbol("(");
                            this.acceptToken(node.getLeadingPrecision());
                            this.acceptSymbol(")");
                        }
                        this.acceptKeyword("to");
                        this.acceptKeyword("minute");
                        break;
                    }
                    case itMinuteToSecond: {
                        this.acceptKeyword("minute");
                        if (node.getLeadingPrecision() != null) {
                            this.acceptSymbol("(");
                            this.acceptToken(node.getLeadingPrecision());
                            this.acceptSymbol(")");
                        }
                        this.acceptKeyword("to");
                        this.acceptKeyword("second");
                        if (node.getFractionalSecondsPrecision() == null) break;
                        this.acceptSymbol("(");
                        this.acceptToken(node.getFractionalSecondsPrecision());
                        this.acceptSymbol(")");
                        break;
                    }
                    case itSecond: {
                        this.acceptKeyword("second");
                        if (node.getLeadingPrecision() == null) break;
                        this.acceptSymbol("(");
                        this.acceptToken(node.getLeadingPrecision());
                        if (node.getFractionalSecondsPrecision() != null) {
                            this.acceptSymbol(",");
                            this.acceptToken(node.getFractionalSecondsPrecision());
                        }
                        this.acceptSymbol(")");
                    }
                }
                break;
            }
            case etBindVar: {
                this.acceptToken(node.getBind1());
                if (node.getIndicator() != null) {
                    this.acceptToken(node.getIndicator());
                }
                this.acceptToken(node.getBind2());
                break;
            }
            default: {
                if (node.getValueToken() != null) {
                    this.acceptToken(node.getValueToken());
                    break;
                }
                if (node.getStringValue() == null) break;
                this.acceptLiteral(node.getStringValue());
            }
        }
    }

    @Override
    public void preVisit(TObjectName node) {
        if (node.getServerToken() != null) {
            this.acceptIdentifier(node.getServerToken().toString());
            this.acceptSymbol(".");
        }
        if (node.getDatabaseToken() != null) {
            this.acceptIdentifier(node.getDatabaseToken().toString());
            this.acceptSymbol(".");
        }
        if (node.getSchemaToken() != null) {
            this.acceptIdentifier(node.getSchemaToken().toString());
            this.acceptSymbol(".");
        }
        if (node.getObjectToken() != null) {
            this.acceptIdentifier(node.getObjectToken().toString());
        }
        if (node.getPartToken() != null) {
            if (node.getObjectToken() != null) {
                this.acceptSymbol(".");
            }
            this.acceptIdentifier(node.getPartToken().toString());
        }
        if (node.getDblink() != null) {
            this.acceptSymbol("@");
            node.getDblink().accept(this);
        } else if (node.getExclamationmark() != null) {
            this.acceptSymbol("@");
            this.acceptSymbol("!");
        }
    }

    @Override
    public void preVisit(TExpressionList node) {
        for (int i = 0; i < node.size(); ++i) {
            node.getExpression(i).accept(this);
            if (i == node.size() - 1) continue;
            this.acceptSymbol(",");
        }
    }

    @Override
    public void preVisit(TFunctionCall node) {
        node.getFunctionName().accept(this);
        this.acceptSymbol("(");
        switch (node.getAggregateType()) {
            case distinct: {
                this.acceptKeyword("distinct");
                break;
            }
            case all: {
                this.acceptKeyword("all");
                break;
            }
            case unique: {
                this.acceptKeyword("unique");
            }
        }
        switch (node.getFunctionType()) {
            case unknown_t: {
                if (node.getArgs() == null) break;
                node.getArgs().accept(this);
                break;
            }
            case udf_t: 
            case case_n_t: 
            case chr_t: {
                if (node.getArgs() != null) {
                    node.getArgs().accept(this);
                }
                if (node.getWindowDef() == null) break;
                node.getWindowDef().accept(this);
                break;
            }
            case cast_t: {
                node.getExpr1().accept(this);
                this.acceptKeyword("as");
                node.getTypename().accept(this);
                break;
            }
            case convert_t: {
                if (node.getTypename() != null) {
                    node.getTypename().accept(this);
                }
                if (node.getParameter() != null) {
                    this.acceptSymbol(",");
                    node.getParameter().accept(this);
                }
                if (node.getStyle() == null) break;
                this.acceptSymbol(",");
                node.getStyle().accept(this);
                break;
            }
            case trim_t: {
                if (node.getTrimArgument() == null) break;
                TTrimArgument trimArgument = node.getTrimArgument();
                if (trimArgument.isBoth()) {
                    this.acceptKeyword("both");
                }
                if (trimArgument.isTrailing()) {
                    this.acceptKeyword("trailing");
                }
                if (trimArgument.isLeading()) {
                    this.acceptKeyword("leading");
                }
                if (trimArgument.getTrimCharacter() != null) {
                    trimArgument.getTrimCharacter().accept(this);
                    this.acceptKeyword("from");
                }
                trimArgument.getStringExpression().accept(this);
                break;
            }
            case extract_t: {
                if (node.getArgs() != null) {
                    node.getArgs().accept(this);
                    break;
                }
                this.acceptKeyword(node.getExtract_time_token().toString());
                this.acceptKeyword("from");
                if (node.getExpr1() == null) break;
                node.getExpr1().accept(this);
                break;
            }
            case treat_t: {
                node.getExpr1().accept(this);
                node.getTypename().accept(this);
                break;
            }
            case contains_t: {
                node.getExpr1().accept(this);
                this.acceptSymbol(",");
                node.getExpr2().accept(this);
                break;
            }
            case freetext_t: {
                node.getExpr1().accept(this);
                this.acceptSymbol(",");
                node.getExpr2().accept(this);
                break;
            }
            case group_concat_t: {
                node.getGroupConcatParam().accept(this);
                break;
            }
            case timestampadd_t: 
            case timestampdiff_t: {
                this.acceptKeyword(node.getIntervalUnit());
                this.acceptSymbol(",");
                node.getExpr1().accept(this);
                this.acceptSymbol(",");
                node.getExpr2().accept(this);
                break;
            }
            default: {
                if (node.getExpr1() != null) {
                    node.getExpr1().accept(this);
                }
                if (node.getExpr2() != null) {
                    this.acceptSymbol(",");
                    node.getExpr2().accept(this);
                }
                if (node.getArgs() == null) break;
                node.getArgs().accept(this);
            }
        }
        this.acceptSymbol(")");
        if (node.getWindowDef() != null) {
            node.getWindowDef().accept(this);
        }
    }

    @Override
    public void preVisit(TGroupConcatParam node) {
        if (node.isDistinct()) {
            this.acceptKeyword("distinct");
        }
        node.getExprList().accept(this);
        if (node.getOrderBy() != null) {
            node.getOrderBy().accept(this);
        }
        if (node.getSeparatorToken() != null) {
            this.acceptKeyword("separator");
            this.acceptToken(node.getSeparatorToken());
        }
    }

    @Override
    public void preVisit(TWindowDef node) {
        if (node.getKeepDenseRankClause() != null) {
            node.getKeepDenseRankClause().accept(this);
        }
        if (node.getWithinGroup() != null) {
            this.acceptKeyword("within");
            this.acceptKeyword("group");
            this.acceptSymbol("(");
            if (node.getWithinGroup().getOrderBy() != null) {
                node.getWithinGroup().getOrderBy().accept(this);
            }
            this.acceptSymbol(")");
        }
        if (node.isIncludingOverClause()) {
            this.acceptKeyword("over");
            this.acceptSymbol("(");
            if (node.getPartitionClause() != null) {
                this.acceptKeyword("partition");
                this.acceptKeyword("by");
                this.visitExprList(node.getPartitionClause().getExpressionList());
            }
            if (node.getOrderBy() != null) {
                node.getOrderBy().accept(this);
            }
            if (node.getWindowFrame() != null) {
                this.acceptNewline();
                node.getWindowFrame().accept(this);
            }
            this.acceptSymbol(")");
        }
        if (node.getName() != null) {
            this.preVisit(node.getName());
        }
    }

    @Override
    public void preVisit(TWindowFrame node) {
        if (node.getLimitRowType() == ELimitRowType.Rows) {
            this.acceptKeyword("rows");
        } else if (node.getLimitRowType() == ELimitRowType.Range) {
            this.acceptKeyword("range");
        }
        if (node.getStartBoundary() != null && node.getEndBoundary() != null) {
            this.acceptKeyword("between");
            node.getStartBoundary().accept(this);
            this.acceptKeyword("and");
            node.getEndBoundary().accept(this);
        } else if (node.getStartBoundary() != null) {
            node.getStartBoundary().accept(this);
        }
    }

    @Override
    public void preVisit(TWindowFrameBoundary node) {
        if (node.getBoundaryNumber() != null) {
            node.getBoundaryNumber().accept(this);
        }
        if (node.getExclusionClause() != null && node.getExclusionClause().getExcludeType() == EWindowExcludeType.currentRow) {
            this.acceptKeyword("current");
            this.acceptKeyword("row");
        }
        if (node.getBoundaryType() == EBoundaryType.ebtCurrentRow) {
            this.acceptKeyword("current");
            this.acceptKeyword("row");
        } else if (node.getBoundaryType() == EBoundaryType.ebtFollowing) {
            this.acceptKeyword("following");
        } else if (node.getBoundaryType() == EBoundaryType.ebtPreceding) {
            this.acceptKeyword("preceding");
        } else if (node.getBoundaryType() == EBoundaryType.ebtUnboundedFollowing) {
            this.acceptKeyword("unbounded");
            this.acceptKeyword("following");
        } else if (node.getBoundaryType() == EBoundaryType.ebtUnboundedPreceding) {
            this.acceptKeyword("unbounded");
            this.acceptKeyword("preceding");
        }
    }

    @Override
    public void preVisit(TExpression node) {
        switch (node.getExpressionType()) {
            case simple_object_name_t: {
                node.getObjectOperand().accept(this);
                if (!node.isOracleOuterJoin()) break;
                this.acceptSymbol("(+)", 289);
                break;
            }
            case simple_constant_t: {
                node.getConstantOperand().accept(this);
                break;
            }
            case new_structured_type_t: 
            case function_t: {
                node.getFunctionCall().accept(this);
                break;
            }
            case type_constructor_t: {
                this.acceptKeyword("new");
                node.getFunctionCall().accept(this);
                break;
            }
            case cursor_t: {
                this.acceptKeyword("cursor");
                node.getSubQuery().accept(this);
                break;
            }
            case multiset_t: 
            case subquery_t: {
                node.getSubQuery().accept(this);
                break;
            }
            case exists_t: {
                this.acceptKeyword("exists");
                node.getSubQuery().accept(this);
                break;
            }
            case assignment_t: {
                node.getLeftOperand().accept(this);
                if (node.getOperatorToken() != null && node.getOperatorToken().toString().equals(":=")) {
                    this.acceptSymbol(":=");
                } else {
                    this.acceptSymbol("=");
                }
                node.getRightOperand().accept(this);
                break;
            }
            case simple_comparison_t: {
                if (node.getSubQuery() != null) {
                    node.getExprList().accept(this);
                    this.scriptWriter.addComparisonOperator(node.getComparisonType());
                    node.getSubQuery().accept(this);
                    break;
                }
                node.getLeftOperand().accept(this);
                this.scriptWriter.addComparisonOperator(node.getComparisonType());
                node.getRightOperand().accept(this);
                break;
            }
            case group_comparison_t: {
                if (node.getExprList() != null) {
                    node.getExprList().accept(this);
                } else {
                    node.getLeftOperand().accept(this);
                }
                this.scriptWriter.addComparisonOperator(node.getComparisonType());
                if (node.getQuantifierType() != EQuantifierType.none) {
                    switch (node.getQuantifierType()) {
                        case all: {
                            this.acceptKeyword("all");
                            break;
                        }
                        case some: {
                            this.acceptKeyword("some");
                            break;
                        }
                        case any: {
                            this.acceptKeyword("any");
                        }
                    }
                }
                node.getRightOperand().accept(this);
                break;
            }
            case in_t: {
                if (node.getExprList() != null) {
                    this.acceptSymbol("(");
                    this.visitExprList(node.getExprList());
                    this.acceptSymbol(")");
                } else {
                    node.getLeftOperand().accept(this);
                }
                if (node.isNotOperator()) {
                    this.acceptKeyword("not");
                }
                this.acceptKeyword("in");
                node.getRightOperand().accept(this);
                break;
            }
            case collection_constructor_list_t: 
            case collection_constructor_multiset_t: 
            case collection_constructor_set_t: 
            case list_t: {
                if (node.getExprList() == null) break;
                this.acceptSymbol("(");
                this.visitExprList(node.getExprList());
                this.acceptSymbol(")");
                break;
            }
            case pattern_matching_t: {
                node.getLeftOperand().accept(this);
                if (node.isNotOperator()) {
                    this.acceptKeyword("not");
                }
                if (node.getOperatorToken() != null) {
                    this.acceptSpace(1);
                    this.acceptToken(node.getOperatorToken());
                    this.acceptSpace(1);
                } else {
                    this.acceptKeyword("like");
                }
                node.getRightOperand().accept(this);
                if (node.getLikeEscapeOperand() == null) break;
                this.acceptKeyword("escape");
                node.getLikeEscapeOperand().accept(this);
                break;
            }
            case between_t: {
                node.getBetweenOperand().accept(this);
                if (node.isNotOperator()) {
                    this.acceptKeyword("not");
                }
                this.acceptKeyword("between");
                node.getLeftOperand().accept(this);
                this.acceptKeyword("and");
                node.getRightOperand().accept(this);
                break;
            }
            case logical_not_t: {
                this.acceptKeyword("not");
                node.getRightOperand().accept(this);
                break;
            }
            case null_t: {
                node.getLeftOperand().accept(this);
                this.acceptKeyword("is");
                if (node.isNotOperator()) {
                    this.acceptKeyword("not");
                }
                this.acceptKeyword("null");
                break;
            }
            case parenthesis_t: {
                this.acceptSymbol("(");
                node.getLeftOperand().accept(this);
                this.acceptSymbol(")");
                break;
            }
            case at_local_t: {
                node.getLeftOperand().accept(this);
                this.acceptKeyword("at");
                this.acceptKeyword("local");
                break;
            }
            case day_to_second_t: {
                node.getLeftOperand().accept(this);
                this.acceptKeyword("day");
                if (node.getLeadingPrecision() != null) {
                    this.acceptSymbol("(");
                    this.acceptToken(node.getLeadingPrecision());
                    this.acceptSymbol(")");
                }
                this.acceptKeyword("to");
                this.acceptKeyword("second");
                if (node.getFractionalSecondsPrecision() == null) break;
                this.acceptSymbol("(");
                this.acceptToken(node.getFractionalSecondsPrecision());
                this.acceptSymbol(")");
                break;
            }
            case year_to_month_t: {
                node.getLeftOperand().accept(this);
                this.acceptKeyword("year");
                if (node.getLeadingPrecision() != null) {
                    this.acceptSymbol("(");
                    this.acceptToken(node.getLeadingPrecision());
                    this.acceptSymbol(")");
                }
                this.acceptKeyword("to");
                this.acceptKeyword("month");
                break;
            }
            case floating_point_t: 
            case typecast_t: 
            case unary_factorial_t: {
                node.getLeftOperand().accept(this);
                break;
            }
            case is_of_type_t: {
                this.visitNodeByToken(node);
                break;
            }
            case unary_plus_t: 
            case unary_minus_t: 
            case unary_prior_t: 
            case unary_connect_by_root_t: 
            case unary_binary_operator_t: 
            case unary_squareroot_t: 
            case unary_cuberoot_t: 
            case unary_factorialprefix_t: 
            case unary_absolutevalue_t: 
            case unary_bitwise_not_t: {
                this.scriptWriter.addUnaryOperator(node.getExpressionType());
                node.getRightOperand().accept(this);
                break;
            }
            case arithmetic_plus_t: 
            case arithmetic_minus_t: 
            case arithmetic_times_t: 
            case arithmetic_divide_t: 
            case power_t: 
            case range_t: 
            case concatenate_t: 
            case period_ldiff_t: 
            case period_rdiff_t: 
            case period_p_intersect_t: 
            case period_p_normalize_t: 
            case contains_t: 
            case arithmetic_modulo_t: 
            case bitwise_exclusive_or_t: 
            case bitwise_or_t: 
            case bitwise_and_t: 
            case bitwise_xor_t: 
            case exponentiate_t: 
            case scope_resolution_t: 
            case member_of_t: 
            case logical_and_t: 
            case logical_or_t: 
            case logical_xor_t: 
            case is_t: 
            case collate_t: 
            case left_join_t: 
            case right_join_t: 
            case ref_arrow_t: 
            case left_shift_t: 
            case right_shift_t: 
            case bitwise_shift_left_t: 
            case bitwise_shift_right_t: 
            case multiset_union_t: 
            case multiset_union_distinct_t: 
            case multiset_intersect_t: 
            case multiset_intersect_distinct_t: 
            case multiset_except_t: 
            case multiset_except_distinct_t: 
            case json_get_text: 
            case json_get_text_at_path: 
            case json_get_object: 
            case json_get_object_at_path: 
            case json_left_contain: 
            case json_right_contain: 
            case json_exist: 
            case json_any_exist: 
            case json_all_exist: 
            case sqlserver_proprietary_column_alias_t: 
            case submultiset_t: {
                node.getLeftOperand().accept(this);
                this.scriptWriter.addBinaryOperator(node.getExpressionType());
                node.getRightOperand().accept(this);
                break;
            }
            case at_time_zone_t: {
                node.getLeftOperand().accept(this);
                this.acceptKeyword("at");
                this.acceptKeyword("time");
                this.acceptKeyword("zone");
                node.getRightOperand().accept(this);
                break;
            }
            case row_constructor_t: {
                if (node.getExprList() == null) break;
                node.getExprList().accept(this);
                break;
            }
            case array_constructor_t: {
                if (node.getSubQuery() != null) {
                    node.getSubQuery().accept(this);
                }
                if (node.getExprList() == null) break;
                node.getExprList().accept(this);
                break;
            }
            case case_t: {
                node.getCaseExpression().accept(this);
                break;
            }
            case arrayaccess_t: {
                break;
            }
            case interval_t: {
                break;
            }
            case simple_source_token_t: {
                this.acceptIdentifier(node.getSourcetokenOperand().toString());
                break;
            }
            case place_holder_t: {
                this.acceptLiteral(node.toString());
                break;
            }
        }
    }

    @Override
    public void preVisit(TSelectModifier node) {
        switch (node.getSelectModifier()) {
            case HIGH_PRIORITY: {
                this.acceptKeyword("HIGH_PRIORITY");
                break;
            }
            case STRAIGHT_JOIN: {
                this.acceptKeyword("STRAIGHT_JOIN");
                break;
            }
            case SQL_SMALL_RESULT: {
                this.acceptKeyword("SQL_SMALL_RESULT");
                break;
            }
            case SQL_BIG_RESULT: {
                this.acceptKeyword("SQL_BIG_RESULT");
                break;
            }
            case SQL_BUFFER_RESULT: {
                this.acceptKeyword("SQL_BUFFER_RESULT");
                break;
            }
            case SQL_NO_CACHE: {
                this.acceptKeyword("SQL_NO_CACHE");
                break;
            }
            case SQL_CALC_FOUND_ROWS: {
                this.acceptKeyword("SQL_CALC_FOUND_ROWS");
                break;
            }
            case SQL_CACHE: {
                this.acceptKeyword("SQL_CACHE");
                break;
            }
            case ALL: {
                this.acceptKeyword("ALL");
                break;
            }
            case DISTINCT: {
                this.acceptKeyword("DISTINCT");
                break;
            }
            case DISTINCTROW: {
                this.acceptKeyword("DISTINCTROW");
                break;
            }
        }
    }

    @Override
    public void preVisit(TSelectSqlStatement node) {
        int i;
        for (i = 0; i < node.getParenthesisCount(); ++i) {
            this.acceptSymbol("(");
        }
        for (i = 0; i < node.getParenthesisCountBeforeOrder(); ++i) {
            this.acceptSymbol("(");
        }
        if (node.getCteList() != null) {
            this.acceptKeyword("with");
            this.visitCTEList(node.getCteList());
        }
        if (node.isCombinedQuery()) {
            this.acceptNewline();
            node.getLeftStmt().accept(this);
            this.acceptNewline();
            this.acceptKeyword(node.getSetOperatorType().toString());
            if (node.isAll()) {
                this.acceptKeyword("all");
            }
            this.acceptNewline();
            node.getRightStmt().accept(this);
            for (i = 0; i < node.getParenthesisCountBeforeOrder(); ++i) {
                this.acceptSymbol(")");
            }
            if (node.getOrderbyClause() != null) {
                this.acceptNewline();
                node.getOrderbyClause().accept(this);
            }
            if (node.getLimitClause() != null) {
                node.getLimitClause().accept(this);
            }
            if (node.getForUpdateClause() != null) {
                node.getForUpdateClause().accept(this);
            }
            if (node.getComputeClause() != null) {
                node.getComputeClause().accept(this);
            }
            for (i = 0; i < node.getParenthesisCount(); ++i) {
                this.acceptSymbol(")");
            }
            return;
        }
        if (node.getValueClause() != null) {
            return;
        }
        this.acceptKeyword("select");
        if (node.getSelectDistinct() != null) {
            switch (node.getSelectDistinct().getUniqueRowFilter()) {
                case urfDistinct: {
                    this.acceptKeyword("distinct");
                    break;
                }
                case urfAll: {
                    this.acceptKeyword("all");
                    break;
                }
                case urfUnique: {
                    this.acceptKeyword("unique");
                    break;
                }
                case urfDistinctOn: {
                    this.acceptKeyword("distinct");
                    this.acceptKeyword("on");
                }
            }
        }
        if (node.getOracleHint() != null && node.getOracleHint().length() > 0) {
            this.acceptOracleHint(node.getOracleHint());
        }
        if (node.getTopClause() != null) {
            node.getTopClause().accept(this);
        }
        if (node.getSelectModifiers() != null) {
            for (i = 0; i < node.getSelectModifiers().size(); ++i) {
                node.getSelectModifiers().get(i).accept(this);
            }
        }
        if (node.getResultColumnList() != null) {
            this.acceptNewline();
            this.visitResultColumnList(node.getResultColumnList());
        }
        if (node.getIntoClause() != null) {
            this.acceptNewline();
            node.getIntoClause().accept(this);
        }
        if (node.joins.size() > 0) {
            this.acceptNewline();
            this.acceptKeyword("from");
            this.visitJoinList(node.joins);
        }
        if (node.getWhereClause() != null) {
            this.acceptNewline();
            node.getWhereClause().accept(this);
        }
        if (node.getHierarchicalClause() != null) {
            this.acceptNewline();
            node.getHierarchicalClause().accept(this);
        }
        if (node.getGroupByClause() != null) {
            this.acceptNewline();
            node.getGroupByClause().accept(this);
        }
        if (node.getQualifyClause() != null) {
            node.getQualifyClause().accept(this);
        }
        for (i = 0; i < node.getParenthesisCountBeforeOrder(); ++i) {
            this.acceptSymbol(")");
        }
        if (node.getOrderbyClause() != null) {
            this.acceptNewline();
            node.getOrderbyClause().accept(this);
        }
        if (node.getLimitClause() != null) {
            node.getLimitClause().accept(this);
        }
        if (node.getForUpdateClause() != null) {
            node.getForUpdateClause().accept(this);
        }
        if (node.getComputeClause() != null) {
            node.getComputeClause().accept(this);
        }
        for (i = 0; i < node.getParenthesisCount(); ++i) {
            this.acceptSymbol(")");
        }
    }

    @Override
    public void preVisit(TComputeClause computeClause) {
        for (int i = 0; i < computeClause.getItems().size(); ++i) {
            computeClause.getItems().getElement(i).accept(this);
        }
    }

    @Override
    public void preVisit(TComputeExpr computeExpr) {
        switch (computeExpr.getComputeFunctionType()) {
            case cftNone: {
                break;
            }
            case cftCount: {
                this.acceptKeyword("count");
                break;
            }
            case cftMax: {
                this.acceptKeyword("max");
                break;
            }
            case cftMin: {
                this.acceptKeyword("min");
                break;
            }
            case cftSum: {
                this.acceptKeyword("sum");
                break;
            }
            case cftAvg: {
                this.acceptKeyword("avg");
                break;
            }
            case cftStdev: {
                this.acceptKeyword("stdev");
                break;
            }
            case cftStdevp: {
                this.acceptKeyword("stdevp");
                break;
            }
            case cftVar: {
                this.acceptKeyword("var");
                break;
            }
            case cftVarp: {
                this.acceptKeyword("varp");
            }
        }
        this.acceptSymbol("(");
        computeExpr.getExpr().accept(this);
        this.acceptSymbol(")");
    }

    @Override
    public void preVisit(TComputeClauseItem computeClauseItem) {
        int i;
        this.acceptNewline();
        this.acceptKeyword("compute");
        if (computeClauseItem.getComputerExprList() != null) {
            for (i = 0; i < computeClauseItem.getComputerExprList().size(); ++i) {
                computeClauseItem.getComputerExprList().getElement(i).accept(this);
                if (i == computeClauseItem.getComputerExprList().size() - 1) continue;
                this.acceptSymbol(",");
            }
        }
        if (computeClauseItem.getByExprlist() != null) {
            this.acceptKeyword("by");
            for (i = 0; i < computeClauseItem.getByExprlist().size(); ++i) {
                computeClauseItem.getByExprlist().getExpression(i).accept(this);
                if (i == computeClauseItem.getByExprlist().size() - 1) continue;
                this.acceptSymbol(",");
            }
        }
    }

    @Override
    public void preVisit(TCreateViewSqlStatement stmt) {
        if (stmt.getCteList() != null) {
            this.acceptKeyword("with");
            this.visitCTEList(stmt.getCteList());
        }
        this.acceptKeyword("create");
        if (stmt.getStReplace() != null) {
            this.acceptKeyword("or");
            this.acceptKeyword("replace");
        }
        if (stmt.getStForce() != null) {
            if (stmt.isForce()) {
                this.acceptKeyword("force");
            }
            if (stmt.isNoForce()) {
                this.acceptKeyword("noforce");
            }
        }
        this.acceptKeyword("view");
        stmt.getViewName().accept(this);
        if (stmt.getViewAliasClause() != null) {
            stmt.getViewAliasClause().accept(this);
        }
        this.acceptNewline();
        this.acceptKeyword("as");
        this.acceptNewline();
        if (stmt.getSubquery() != null) {
            stmt.getSubquery().accept(this);
        }
        if (stmt.getRestrictionClause() != null) {
            this.acceptNewline();
            this.preVisit(stmt.getRestrictionClause());
        }
    }

    public void preVisit(TRestrictionClause clause) {
        if (clause.getRestrictionType() == ERestrictionType.withCheckOption) {
            this.acceptKeyword("with");
            this.acceptKeyword("check");
            this.acceptKeyword("option");
        } else if (clause.getRestrictionType() == ERestrictionType.withReadOnly) {
            this.acceptKeyword("with");
            this.acceptKeyword("read");
            this.acceptKeyword("only");
        } else if (clause.getRestrictionType() == ERestrictionType.withLocalCheckOption) {
            this.acceptKeyword("with");
            this.acceptKeyword("local");
            this.acceptKeyword("check");
            this.acceptKeyword("option");
        } else if (clause.getRestrictionType() == ERestrictionType.withCascadedCheckOption) {
            this.acceptKeyword("with");
            this.acceptKeyword("cascaded");
            this.acceptKeyword("check");
            this.acceptKeyword("option");
        }
        if (clause.getConstraintName() != null) {
            clause.getConstraintName().accept(this);
        }
    }

    @Override
    public void preVisit(TViewAliasClause clause) {
        this.acceptSymbol("(");
        this.visitViewAliasItemList(clause.getViewAliasItemList());
        this.acceptSymbol(")");
    }

    void visitViewAliasItemList(TViewAliasItemList viewAliasItemList) {
        for (int i = 0; i < viewAliasItemList.size(); ++i) {
            TViewAliasItem aliasItem = viewAliasItemList.getViewAliasItem(i);
            this.visitViewAliasItem(aliasItem);
            if (i == viewAliasItemList.size() - 1) continue;
            this.acceptSymbol(",");
        }
    }

    private void visitViewAliasItem(TViewAliasItem aliasItem) {
        aliasItem.getAlias().accept(this);
    }

    @Override
    public void preVisit(TResultColumn node) {
        node.getExpr().accept(this);
        if (node.getAliasClause() != null && node.getExpr().getExpressionType() != EExpressionType.sqlserver_proprietary_column_alias_t) {
            this.acceptSpace(1);
            node.getAliasClause().accept(this);
        }
    }

    @Override
    public void preVisit(TColumnDefinitionList node) {
        for (int i = 0; i < node.size(); ++i) {
            node.getColumn(i).accept(this);
            if (i == node.size() - 1) continue;
            this.acceptSymbol(",");
        }
    }

    @Override
    public void preVisit(TObjectNameList node) {
        for (int i = 0; i < node.size(); ++i) {
            node.getObjectName(i).accept(this);
            if (i == node.size() - 1) continue;
            this.acceptSymbol(",");
        }
    }

    @Override
    public void preVisit(TConstraintList node) {
        for (int i = 0; i < node.size(); ++i) {
            node.getConstraint(i).accept(this);
            if (i == node.size() - 1) continue;
            this.acceptSymbol(",");
        }
    }

    @Override
    public void preVisit(TParameterDeclarationList params) {
        for (int i = 0; i < params.size(); ++i) {
            TParameterDeclaration param = params.getParameterDeclarationItem(i);
            param.accept(this);
            if (i == params.size() - 1) continue;
            this.acceptSymbol(",");
        }
    }

    @Override
    public void preVisit(TParameterDeclaration param) {
        if (param.getParameterName() != null) {
            param.getParameterName().accept(this);
        }
        if (param.getDataType() != null) {
            param.getDataType().accept(this);
        }
    }

    @Override
    public void preVisit(TMssqlCreateFunction function) {
        this.acceptKeyword("create");
        this.acceptKeyword("function");
        if (function.getFunctionName() != null) {
            function.getFunctionName().accept(this);
        }
        if (function.getParameterDeclarations() != null && function.getParameterDeclarations().size() > 0) {
            this.acceptSymbol("(");
            function.getParameterDeclarations().accept(this);
            this.acceptSymbol(")");
        }
        if (function.getReturnDataType() != null) {
            this.acceptNewline();
            this.acceptSpace(4);
            this.acceptKeyword("returns");
            function.getReturnDataType().accept(this);
        }
        this.acceptNewline();
        this.acceptKeyword("as");
        this.acceptNewline();
        if (function.getBodyStatements() != null) {
            function.getBodyStatements().accept(this);
        }
    }

    @Override
    public void preVisit(TDmlEventItem node) {
        switch (node.getDmlType()) {
            case sstinsert: {
                this.acceptKeyword("insert");
                break;
            }
            case sstdelete: {
                this.acceptKeyword("delete");
                break;
            }
            case sstupdate: {
                this.acceptKeyword("update");
                if (node.getColumnList() == null) break;
                this.acceptKeyword("of");
                node.getColumnList().accept(this);
            }
        }
    }

    @Override
    public void preVisit(TDdlEventItem node) {
        this.acceptIdentifier(node.getEventName().toString());
    }

    @Override
    public void preVisit(TSimpleDmlTriggerClause node) {
        this.acceptNewline();
        this.acceptSpace(4);
        this.acceptKeyword("on");
        TDmlEventClause dmlEventClause = (TDmlEventClause)node.getEventClause();
        dmlEventClause.getTableName().accept(this);
        this.acceptNewline();
        switch (node.getActionTime()) {
            case tatFor: {
                this.acceptKeyword("for");
                break;
            }
            case tatBefore: {
                this.acceptKeyword("before");
                break;
            }
            case tatAfter: {
                this.acceptKeyword("after");
                break;
            }
            case tatInsteadOf: {
                this.acceptKeyword("instead of");
            }
        }
        for (int i = 0; i < dmlEventClause.getEventItems().size(); ++i) {
            dmlEventClause.getEventItems().get(i).accept(this);
            if (i == dmlEventClause.getEventItems().size() - 1) continue;
            this.acceptSymbol(",");
        }
    }

    @Override
    public void preVisit(TCreateTriggerStmt trigger) {
        if (trigger.isAlterTrigger()) {
            this.acceptKeyword("alter");
        } else {
            this.acceptKeyword("create");
        }
        this.acceptKeyword("trigger");
        if (trigger.getTriggerName() != null) {
            trigger.getTriggerName().accept(this);
        }
        trigger.getTriggeringClause().accept(this);
        this.acceptNewline();
        this.acceptKeyword("as");
        this.acceptNewline();
        if (trigger.getBodyStatements() != null) {
            trigger.getBodyStatements().accept(this);
        }
    }

    @Override
    public void preVisit(TProcedureOption option) {
        if (option.getOptionType() == EProcedureOptionType.potExecuteAs) {
            this.acceptKeyword("execute");
            this.acceptKeyword("as");
            this.acceptKeyword("caller");
        }
        if (option.getOptionType() == EProcedureOptionType.potCalledOnNullInput) {
            this.acceptKeyword("called");
            this.acceptKeyword("on");
            this.acceptKeyword("null");
            this.acceptKeyword("input");
        }
        if (option.getOptionType() == EProcedureOptionType.potEncryption) {
            this.acceptKeyword("encryption");
        }
        if (option.getOptionType() == EProcedureOptionType.potNativeCompilation) {
            this.acceptKeyword("native");
            this.acceptKeyword("compilation");
        }
        if (option.getOptionType() == EProcedureOptionType.potRecompile) {
            this.acceptKeyword("recompile");
        }
        if (option.getOptionType() == EProcedureOptionType.potReturnsNullOnNullInput) {
            this.acceptKeyword("returns");
            this.acceptKeyword("null");
            this.acceptKeyword("on");
            this.acceptKeyword("null");
            this.acceptKeyword("input");
        }
        if (option.getOptionType() == EProcedureOptionType.potSchemaBinding) {
            this.acceptKeyword("schema");
            this.acceptKeyword("binding");
        }
    }

    @Override
    public void preVisit(TMssqlCreateProcedure procedure) {
        this.acceptKeyword("create");
        this.acceptKeyword("procedure");
        if (procedure.getProcedureName() != null) {
            procedure.getProcedureName().accept(this);
        }
        this.acceptNewline();
        this.acceptSpace(4);
        if (procedure.getParameterDeclarations() != null && procedure.getDeclareStatements().size() > 0) {
            procedure.getParameterDeclarations().accept(this);
        }
        if (procedure.getProcedureOptions() != null && procedure.getProcedureOptions().size() > 0) {
            this.acceptKeyword("with");
            for (int i = 0; i < procedure.getProcedureOptions().size(); ++i) {
                TProcedureOption option = procedure.getProcedureOptions().getElement(i);
                option.accept(this);
                if (i == procedure.getProcedureOptions().size() - 1) continue;
                this.acceptSymbol(",");
            }
        }
        if (procedure.isForReplication()) {
            this.acceptKeyword("for");
            this.acceptKeyword("replication");
        }
        this.acceptNewline();
        this.acceptKeyword("as");
        this.acceptNewline();
        this.acceptKeyword("begin");
        this.acceptNewline();
        if (procedure.getBodyStatements() != null) {
            procedure.getBodyStatements().accept(this);
        }
        this.acceptKeyword("end");
    }

    @Override
    public void preVisit(TMssqlFetch stmt) {
        this.acceptKeyword("fetch");
        this.acceptKeyword("from");
        if (stmt.getCursorName() != null) {
            stmt.getCursorName().accept(this);
        }
        this.acceptKeyword("into");
        if (stmt.getVariableNames() != null) {
            stmt.getVariableNames().accept(this);
        }
    }

    @Override
    public void preVisit(TMssqlBlock block) {
        this.acceptKeyword("begin");
        this.acceptNewline();
        if (block.getBodyStatements() != null) {
            block.getBodyStatements().accept(this);
            this.acceptNewline();
        }
        this.acceptKeyword("end");
    }

    @Override
    public void preVisit(TMssqlRollback rollback) {
        this.acceptKeyword("rollback");
        if (rollback.getTrans_or_work() != null) {
            this.acceptToken(rollback.getTrans_or_work());
        }
        if (rollback.getTransactionName() != null) {
            rollback.getTransactionName().accept(this);
        }
    }

    @Override
    public void preVisit(TMssqlRaiserror raiseError) {
        this.acceptKeyword("raiserror");
        this.acceptSymbol("(");
        if (raiseError.getMessageText() != null) {
            raiseError.getMessageText().accept(this);
        }
        if (raiseError.getSeverity() != null) {
            this.acceptSymbol(",");
            raiseError.getSeverity().accept(this);
        }
        if (raiseError.getState() != null) {
            this.acceptSymbol(",");
            raiseError.getState().accept(this);
        }
        if (raiseError.getArgs() != null && raiseError.getArgs().size() > 0) {
            for (int i = 0; i < raiseError.getArgs().size(); ++i) {
                this.acceptSymbol(",");
                raiseError.getArgs().getExpression(i).accept(this);
            }
        }
        this.acceptSymbol(")");
    }

    @Override
    public void preVisit(TMssqlPrint stmt) {
        this.acceptKeyword("print");
        if (stmt.getMessages() != null) {
            stmt.getMessages().accept(this);
        }
    }

    @Override
    public void preVisit(TMssqlDeclare stmt) {
        this.acceptKeyword("declare");
        if (stmt.getVariables() != null) {
            stmt.getVariables().accept(this);
        }
        if (stmt.getCursorName() != null) {
            stmt.getCursorName().accept(this);
            this.acceptKeyword("cursor");
            if (stmt.getSubquery() != null) {
                this.acceptKeyword("for");
                stmt.getSubquery().accept(this);
            }
        }
    }

    @Override
    public void preVisit(TVarDeclStmt stmt) {
        if (stmt.getElementName() != null) {
            stmt.getElementName().accept(this);
        }
        if (stmt.getDataType() != null) {
            stmt.getDataType().accept(this);
        }
        if (stmt.getDefaultValue() != null) {
            if (stmt.getDeclareType() == EDeclareType.variable) {
                this.acceptKeyword("default");
                stmt.getDefaultValue().accept(this);
            } else if (stmt.getDeclareType() == EDeclareType.constant) {
                this.acceptSymbol(":=");
                stmt.getDefaultValue().accept(this);
            }
        }
    }

    @Override
    public void preVisit(TMssqlSet stmt) {
        this.acceptKeyword("set");
        if (stmt.getVarName() != null) {
            stmt.getVarName().accept(this);
            this.acceptSymbol("=");
        }
        if (stmt.getVarExpr() != null) {
            stmt.getVarExpr().accept(this);
        }
    }

    @Override
    public void preVisit(TMssqlReturn stmt) {
        this.acceptKeyword("return");
        if (stmt.getReturnExpr() != null) {
            stmt.getReturnExpr().accept(this);
        }
    }

    @Override
    public void preVisit(TMssqlLabel stmt) {
        super.preVisit(stmt);
    }

    @Override
    public void preVisit(TDeclareVariableList variables) {
        for (int i = 0; i < variables.size(); ++i) {
            variables.getDeclareVariable(i).accept(this);
            if (i == variables.size() - 1) continue;
            this.acceptSymbol(",");
        }
    }

    @Override
    public void preVisit(TDeclareVariable variable) {
        if (variable.getVariableName() != null) {
            variable.getVariableName().accept(this);
        }
        if (variable.getDatatype() != null) {
            variable.getDatatype().accept(this);
        }
    }

    @Override
    public void preVisit(TMssqlExecute stmt) {
        this.acceptKeyword("exec");
        if (stmt.getModuleName() != null) {
            stmt.getModuleName().accept(this);
        }
        if (stmt.getParameters() != null && stmt.getParameters().size() > 0) {
            this.acceptSpace(1);
            stmt.getParameters().accept(this);
        }
    }

    @Override
    public void preVisit(TMssqlExecuteAs stmt) {
        this.acceptKeyword("execute");
        this.acceptKeyword("as");
        if (stmt.getExecuteAsOption() != null) {
            switch (stmt.getExecuteAsOption()) {
                case eaoCaller: {
                    this.acceptKeyword("caller");
                    break;
                }
                case eaoLogin: {
                    this.acceptKeyword("login");
                    break;
                }
                case eaoOwner: {
                    this.acceptKeyword("owner");
                    break;
                }
                case eaoSelf: {
                    this.acceptKeyword("self");
                    break;
                }
                case eaoString: {
                    this.acceptKeyword("string");
                    break;
                }
                case eaoUser: {
                    this.acceptKeyword("user");
                    break;
                }
            }
        }
        if (stmt.getLoginName() != null) {
            stmt.getLoginName().accept(this);
        }
    }

    @Override
    public void preVisit(TMssqlRevert stmt) {
        this.acceptKeyword("revert");
        if (stmt.getCookie() != null) {
            this.acceptKeyword("with");
            this.acceptIdentifier("cookie");
            this.acceptSymbol("=");
            stmt.getCookie().accept(this);
        }
    }

    @Override
    public void preVisit(TMssqlStmtStub stmt) {
        super.preVisit(stmt);
    }

    @Override
    public void preVisit(TExecParameter param) {
        if (param.getParameterName() != null) {
            param.getParameterName().accept(this);
        }
        if (param.getParameterValue() != null) {
            param.getParameterValue().accept(this);
        }
    }

    @Override
    public void preVisit(TExecParameterList params) {
        for (int i = 0; i < params.size(); ++i) {
            params.getExecParameter(i).accept(this);
            if (i == params.size() - 1) continue;
            this.acceptSymbol(",");
        }
    }

    @Override
    public void preVisit(TAlterTableOption node) {
        switch (node.getOptionType()) {
            case AddColumn: {
                this.acceptKeyword("add");
                if (node.getColumnDefinitionList().size() > 1) {
                    this.acceptSymbol("(");
                }
                node.getColumnDefinitionList().accept(this);
                if (node.getColumnDefinitionList().size() <= 1) break;
                this.acceptSymbol(")");
                break;
            }
            case AlterColumn: {
                this.acceptKeyword("alter");
                this.acceptKeyword("column");
                node.getColumnName().accept(this);
                break;
            }
            case ChangeColumn: {
                this.acceptKeyword("change");
                node.getColumnName().accept(this);
                break;
            }
            case DropColumn: {
                this.acceptKeyword("drop");
                this.acceptKeyword("column");
                if (node.getColumnNameList().size() > 1) {
                    this.acceptSymbol("(");
                }
                node.getColumnNameList().accept(this);
                if (node.getColumnNameList().size() <= 1) break;
                this.acceptSymbol(")");
                break;
            }
            case ModifyColumn: {
                this.acceptKeyword("modify");
                this.acceptKeyword("column");
                if (node.getColumnDefinitionList().size() > 1) {
                    this.acceptSymbol("(");
                }
                node.getColumnDefinitionList().accept(this);
                if (node.getColumnDefinitionList().size() <= 1) break;
                this.acceptSymbol(")");
                break;
            }
            case RenameColumn: {
                this.acceptKeyword("rename");
                this.acceptKeyword("column");
                node.getColumnName().accept(this);
                this.acceptKeyword("to");
                node.getNewColumnName().accept(this);
                break;
            }
            case AddConstraint: {
                this.acceptKeyword("add");
                node.getConstraintList().accept(this);
                break;
            }
        }
    }

    @Override
    public void preVisit(TAlterTableStatement stmt) {
        this.acceptKeyword("alter");
        this.acceptKeyword("table");
        stmt.getTableName().accept(this);
        this.acceptNewline();
        if (stmt.getAlterTableOptionList() != null) {
            for (int i = 0; i < stmt.getAlterTableOptionList().size(); ++i) {
                stmt.getAlterTableOptionList().getAlterTableOption(i).accept(this);
                if (i == stmt.getAlterTableOptionList().size() - 1) continue;
                this.acceptSymbol(",");
                this.acceptNewline();
            }
        }
    }

    @Override
    public void preVisit(TStatementList stmts) {
        for (int i = 0; i < stmts.size(); ++i) {
            TCustomSqlStatement stmt = stmts.get(i);
            this.preVisit(stmt);
            if (stmts.size() > 1) {
                this.acceptSemicolon();
            }
            if (i == stmts.size() - 1) continue;
            this.acceptNewline();
        }
    }

    protected void preVisit(TCustomSqlStatement stmt) {
        try {
            Class<?> clazz = stmt.getClass();
            Method m = this.getClass().getMethod("preVisit", clazz);
            m.setAccessible(true);
            m.invoke((Object)this, stmt);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(stmt.sqlstatementtype.name(), e);
        }
    }

    @Override
    public void preVisit(TElsifStmt elsifStmt) {
        this.acceptKeyword("elsif");
        if (elsifStmt.getCondition() != null) {
            elsifStmt.getCondition().accept(this);
        }
        if (elsifStmt.getThenStatements() != null && elsifStmt.getThenStatements().size() > 0) {
            this.acceptKeyword("then");
            this.acceptNewline();
            this.acceptSpace(4);
            this.preVisit(elsifStmt.getThenStatements());
            this.acceptNewline();
        }
    }

    @Override
    public void preVisit(TAssignStmt assignStmt) {
        assignStmt.getLeft().accept(this);
        this.scriptWriter.addComparisonOperator(EComparisonType.equals);
        assignStmt.getExpression().accept(this);
    }

    @Override
    public void preVisit(TIfStmt ifStmt) {
        this.acceptKeyword("if");
        if (ifStmt.getCondition() != null) {
            ifStmt.getCondition().accept(this);
        }
        if (ifStmt.getThenStatements() != null && ifStmt.getThenStatements().size() > 0) {
            this.acceptKeyword("then");
            this.acceptNewline();
            this.acceptSpace(4);
            this.preVisit(ifStmt.getThenStatements());
            this.acceptNewline();
        }
        if (ifStmt.getElseifStatements() != null) {
            this.preVisit(ifStmt.getElseifStatements());
        }
        if (ifStmt.getElseStatements() != null && ifStmt.getElseStatements().size() > 0) {
            this.acceptKeyword("else");
            this.preVisit(ifStmt.getElseStatements());
            this.acceptNewline();
        }
        this.acceptKeyword("end");
        this.acceptKeyword("if");
        this.acceptNewline();
    }

    @Override
    public void preVisit(TMssqlIfElse ifElse) {
        this.acceptKeyword("if");
        if (ifElse.getCondition() != null) {
            ifElse.getCondition().accept(this);
        }
        if (ifElse.getStmt() != null) {
            this.acceptNewline();
            this.acceptSpace(4);
            this.preVisit(ifElse.getStmt());
        }
        if (ifElse.getElseStmt() != null) {
            this.acceptNewline();
            this.acceptSpace(4);
            this.acceptKeyword("else");
            this.acceptNewline();
            this.acceptSpace(4);
            this.preVisit(ifElse.getElseStmt());
        }
    }

    @Override
    public void preVisit(TAliasClause node) {
        if (node.isHasAs()) {
            this.acceptKeyword("as");
        }
        node.getAliasName().accept(this);
        if (node.getColumns() != null) {
            this.acceptSpace(1);
            this.acceptSymbol("(");
            this.visitObjectNameList(node.getColumns());
            this.acceptSymbol(")");
        }
    }

    @Override
    public void preVisit(TWhereClause node) {
        if (node.getCondition() == null) {
            return;
        }
        this.acceptKeyword("where");
        node.getCondition().accept(this);
    }

    @Override
    public void preVisit(TIntoClause node) {
        if (node.isBulkCollect()) {
            this.acceptKeyword("bulk");
            this.acceptKeyword("collect");
        }
        this.acceptKeyword("into");
        if (node.getExprList() != null) {
            this.acceptNewline();
            node.getExprList().accept(this);
        } else {
            node.getIntoName().accept(this);
        }
    }

    @Override
    public void preVisit(TTopClause node) {
        this.acceptKeyword("top");
        node.getExpr().accept(this);
        if (node.isPercent()) {
            this.acceptKeyword("percent");
        }
        if (node.isWithties()) {
            this.acceptKeyword("with ties");
        }
    }

    @Override
    public void preVisit(TLimitClause node) {
        this.acceptNewline();
        this.acceptKeyword("limit");
        if (node.getOffset() != null) {
            node.getOffset().accept(this);
            if (node.getRow_count() != null) {
                this.acceptSymbol(",");
                node.getRow_count().accept(this);
            }
        } else {
            node.getRow_count().accept(this);
        }
    }

    @Override
    public void preVisit(TJoin node) {
        int i;
        if (node.getJoinItems().size() > 0) {
            if (node.getTable() != null) {
                node.setKind(2);
            } else if (node.getJoin() != null) {
                node.setKind(3);
            }
        }
        if (node.isWithParen()) {
            for (i = 0; i < node.getNestedParen(); ++i) {
                this.acceptSymbol("(");
            }
        }
        switch (node.getKind()) {
            case 1: {
                node.getTable().accept(this);
                break;
            }
            case 2: 
            case 3: {
                if (node.getKind() == 2) {
                    node.getTable().accept(this);
                } else if (node.getKind() == 3) {
                    node.getJoin().accept(this);
                }
                for (i = 0; i < node.getJoinItems().size(); ++i) {
                    TJoinItem joinItem = node.getJoinItems().getJoinItem(i);
                    this.acceptNewline();
                    joinItem.accept(this);
                }
                break;
            }
        }
        if (node.isWithParen()) {
            for (i = 0; i < node.getNestedParen(); ++i) {
                this.acceptSymbol(")");
            }
        }
        if (node.getAliasClause() != null) {
            this.acceptSpace(1);
            node.getAliasClause().accept(this);
        }
    }

    @Override
    public void preVisit(TJoinItem joinItem) {
        switch (joinItem.getJoinType()) {
            case inner: {
                this.acceptKeyword("inner");
                this.acceptKeyword("join");
                break;
            }
            case join: {
                this.acceptKeyword("join");
                break;
            }
            case left: {
                this.acceptKeyword("left");
                this.acceptKeyword("join");
                break;
            }
            case leftouter: {
                this.acceptKeyword("left");
                this.acceptKeyword("outer");
                this.acceptKeyword("join");
                break;
            }
            case right: {
                this.acceptKeyword("right");
                this.acceptKeyword("join");
                break;
            }
            case rightouter: {
                this.acceptKeyword("right");
                this.acceptKeyword("outer");
                this.acceptKeyword("join");
                break;
            }
            case full: {
                this.acceptKeyword("full");
                this.acceptKeyword("join");
                break;
            }
            case fullouter: {
                this.acceptKeyword("full");
                this.acceptKeyword("outer");
                this.acceptKeyword("join");
                break;
            }
            case cross: {
                this.acceptKeyword("cross");
                this.acceptKeyword("join");
                break;
            }
            case natural: {
                this.acceptKeyword("natural");
                this.acceptKeyword("join");
                break;
            }
            case natural_inner: {
                this.acceptKeyword("natural");
                this.acceptKeyword("inner");
                this.acceptKeyword("join");
                break;
            }
            case crossapply: {
                this.acceptKeyword("cross");
                this.acceptKeyword("apply");
                break;
            }
            case outerapply: {
                this.acceptKeyword("outer");
                this.acceptKeyword("apply");
                break;
            }
            default: {
                this.acceptKeyword("join");
            }
        }
        if (joinItem.getTable() != null) {
            joinItem.getTable().accept(this);
        } else if (joinItem.getJoin() != null) {
            joinItem.getJoin().accept(this);
        }
        if (joinItem.getOnCondition() != null) {
            this.acceptKeyword("on");
            joinItem.getOnCondition().accept(this);
        }
        if (joinItem.getUsingColumns() != null) {
            this.acceptKeyword("using");
            this.acceptSymbol("(");
            this.visitObjectNameList(joinItem.getUsingColumns());
            this.acceptSymbol(")");
        }
    }

    @Override
    public void preVisit(TTable node) {
        int i;
        if (node.getParenthesisCount() > 0) {
            for (i = 0; i < node.getParenthesisCount(); ++i) {
                this.acceptSymbol("(");
            }
        }
        if (node.getParenthesisAfterAliasCount() > 0) {
            for (i = 0; i < node.getParenthesisAfterAliasCount(); ++i) {
                this.acceptSymbol("(");
            }
        }
        if (node.isTableKeyword()) {
            this.acceptKeyword("table");
            this.acceptSymbol("(");
        }
        if (node.isOnlyKeyword()) {
            this.acceptKeyword("only");
            this.acceptSymbol("(");
        }
        switch (node.getTableType()) {
            case objectname: {
                node.getTableName().accept(this);
                if (node.getFlashback() == null) break;
                this.acceptNewline();
                this.visitNodeByToken(node.getFlashback());
                break;
            }
            case tableExpr: {
                node.getTableExpr().accept(this);
                break;
            }
            case subquery: {
                node.getSubquery().accept(this);
                break;
            }
            case function: {
                node.getFuncCall().accept(this);
                break;
            }
            case pivoted_table: {
                node.getPivotedTable().accept(this);
                break;
            }
            case output_merge: {
                break;
            }
            case containsTable: {
                node.getContainsTable().accept(this);
                break;
            }
            case openrowset: {
                node.getOpenRowSet().accept(this);
                break;
            }
            case openxml: {
                node.getOpenXML().accept(this);
                break;
            }
            case opendatasource: {
                node.getOpenDatasource().accept(this);
                break;
            }
            case openquery: {
                node.getOpenquery().accept(this);
                break;
            }
            case datachangeTable: {
                node.getDatachangeTable().accept(this);
                break;
            }
            case rowList: {
                node.getRowList().accept(this);
                break;
            }
            case xmltable: {
                node.getXmlTable().accept(this);
                break;
            }
            case informixOuter: {
                node.getOuterClause().accept(this);
                break;
            }
            case table_ref_list: {
                node.getFromTableList().accept(this);
                break;
            }
            case hiveFromQuery: {
                node.getHiveFromQuery().accept(this);
                break;
            }
        }
        if (node.isTableKeyword()) {
            this.acceptSymbol(")");
        }
        if (node.isOnlyKeyword()) {
            this.acceptSymbol(")");
        }
        if (node.getParenthesisCount() > 0) {
            for (i = 0; i < node.getParenthesisCount(); ++i) {
                this.acceptSymbol(")");
            }
        }
        if (node.getPxGranule() != null) {
            this.acceptNewline();
            this.visitNodeByToken(node.getPxGranule());
        }
        if (node.getTableSample() != null) {
            this.acceptNewline();
            this.visitNodeByToken(node.getTableSample());
        }
        if (node.getAliasClause() != null) {
            this.acceptSpace(1);
            node.getAliasClause().accept(this);
        }
        if (node.getParenthesisAfterAliasCount() > 0) {
            for (i = 0; i < node.getParenthesisAfterAliasCount(); ++i) {
                this.acceptSymbol(")");
            }
        }
        if (node.getTableHintList() != null) {
            for (i = 0; i < node.getTableHintList().size(); ++i) {
                TTableHint tableHint = node.getTableHintList().getElement(i);
                tableHint.accept(this);
            }
        }
    }

    @Override
    public void preVisit(THierarchical node) {
        if (node.getStartWithClause() != null) {
            this.acceptKeyword("start");
            this.acceptKeyword("with");
            node.getStartWithClause().accept(this);
        }
        for (int i = 0; i < node.getConnectByList().size(); ++i) {
            node.getConnectByList().getElement(i).accept(this);
            if (i == node.getConnectByList().size() - 1) continue;
            this.acceptNewline();
        }
    }

    @Override
    public void preVisit(TConnectByClause node) {
        this.acceptKeyword("connect");
        this.acceptKeyword("by");
        if (node.isNoCycle()) {
            this.acceptKeyword("nocycle");
        }
        node.getCondition().accept(this);
    }

    @Override
    public void preVisit(TGroupBy node) {
        if (node.getItems() != null && node.getItems().size() > 0) {
            this.acceptKeyword("group");
            this.acceptKeyword("by");
            for (int i = 0; i < node.getItems().size(); ++i) {
                node.getItems().getElement(i).accept(this);
                if (i == node.getItems().size() - 1) continue;
                this.acceptSymbol(",");
            }
        }
        if (node.getHavingClause() != null) {
            this.acceptKeyword("having");
            node.getHavingClause().accept(this);
        }
    }

    @Override
    public void preVisit(TGroupByItem node) {
        if (node.getExpr() != null) {
            node.getExpr().accept(this);
        } else if (node.getGroupingSet() != null) {
            node.getGroupingSet().accept(this);
        } else if (node.getRollupCube() != null) {
            node.getRollupCube().accept(this);
        }
    }

    @Override
    public void preVisit(TOrderBy node) {
        if (node.getItems().size() == 0) {
            return;
        }
        this.acceptKeyword("order");
        if (node.isSiblings()) {
            this.acceptKeyword("siblings");
        }
        this.acceptKeyword("by");
        for (int i = 0; i < node.getItems().size(); ++i) {
            node.getItems().getOrderByItem(i).accept(this);
            if (i == node.getItems().size() - 1) continue;
            this.acceptSymbol(",");
        }
    }

    @Override
    public void preVisit(TOrderByItem node) {
        if (node.getSortKey() != null) {
            node.getSortKey().accept(this);
        }
        if (node.getSortOrder() == ESortType.asc) {
            this.acceptKeyword("asc");
        } else if (node.getSortOrder() == ESortType.desc) {
            this.acceptKeyword("desc");
        }
    }

    @Override
    public void preVisit(TCTE node) {
        node.getTableName().accept(this);
        if (node.getColumnList() != null) {
            this.acceptSymbol("(");
            for (int i = 0; i < node.getColumnList().size(); ++i) {
                node.getColumnList().getObjectName(i).accept(this);
                if (i == node.getColumnList().size() - 1) continue;
                this.acceptSymbol(",");
            }
            this.acceptSymbol(")");
        }
        this.acceptKeyword("as");
        this.acceptNewline();
        if (node.getSubquery() != null) {
            node.getSubquery().accept(this);
        } else if (node.getUpdateStmt() != null) {
            node.getUpdateStmt().accept(this);
        } else if (node.getInsertStmt() != null) {
            node.getInsertStmt().accept(this);
        } else if (node.getDeleteStmt() != null) {
            node.getDeleteStmt().accept(this);
        }
    }

    @Override
    public void preVisit(TPivotInClause node) {
        this.acceptKeyword("in");
        if (node.getItems() != null) {
            this.acceptSymbol("(");
            this.visitResultColumnList(node.getItems());
            this.acceptSymbol(")");
        }
        if (node.getSubQuery() != null) {
            node.getSubQuery().accept(this);
        }
    }

    @Override
    public void preVisit(TPivotedTable node) {
        for (int i = 0; i < node.getPivotClauseList().size(); ++i) {
            TPivotClause pivotClause;
            if (i == 0) {
                node.getTableSource().accept(this);
            }
            if ((pivotClause = node.getPivotClauseList().getElement(i)).getAliasClause() != null) {
                pivotClause.getAliasClause().accept(this);
            }
            pivotClause.accept(this);
        }
    }

    @Override
    public void preVisit(TPivotClause node) {
        if (node.getType() == 1) {
            int i;
            this.acceptKeyword("pivot");
            this.acceptSymbol("(");
            if (node.getAggregation_function() != null) {
                node.getAggregation_function().accept(this);
            } else if (node.getAggregation_function_list() != null) {
                if (node.getAggregation_function_list().size() > 1) {
                    this.acceptSymbol("(");
                }
                for (i = 0; i < node.getAggregation_function_list().size(); ++i) {
                    node.getAggregation_function_list().getResultColumn(i).accept(this);
                    if (i == node.getAggregation_function_list().size() - 1) continue;
                    this.acceptSymbol(",");
                }
                if (node.getAggregation_function_list().size() > 1) {
                    this.acceptSymbol(")");
                }
            }
            this.acceptKeyword("for");
            if (node.getPivotColumnList().size() > 1) {
                this.acceptSymbol("(");
            }
            for (i = 0; i < node.getPivotColumnList().size(); ++i) {
                node.getPivotColumnList().getElement(i).accept(this);
                if (i == node.getPivotColumnList().size() - 1) continue;
                this.acceptSymbol(",");
            }
            if (node.getPivotColumnList().size() > 1) {
                this.acceptSymbol(")");
            }
            node.getPivotInClause().accept(this);
            this.acceptSymbol(")");
        } else {
            int i;
            this.acceptKeyword("unpivot");
            this.acceptSymbol("(");
            if (node.getValueColumnList().size() > 1) {
                this.acceptSymbol("(");
            }
            for (i = 0; i < node.getValueColumnList().size(); ++i) {
                node.getValueColumnList().getObjectName(i).accept(this);
                if (i == node.getValueColumnList().size() - 1) continue;
                this.acceptSymbol(",");
            }
            if (node.getValueColumnList().size() > 1) {
                this.acceptSymbol(")");
            }
            this.acceptKeyword("for");
            if (node.getPivotColumnList().size() > 1) {
                this.acceptSymbol("(");
            }
            for (i = 0; i < node.getPivotColumnList().size(); ++i) {
                node.getPivotColumnList().getElement(i).accept(this);
                if (i == node.getPivotColumnList().size() - 1) continue;
                this.acceptSymbol(",");
            }
            if (node.getPivotColumnList().size() > 1) {
                this.acceptSymbol(")");
            }
            node.getUnpivotInClause().accept(this);
            this.acceptSymbol(")");
        }
    }

    @Override
    public void preVisit(TUnpivotInClauseItem node) {
        int i;
        if (node.getColumn() != null) {
            node.getColumn().accept(this);
        } else if (node.getColumnList() != null) {
            this.acceptSymbol("(");
            for (i = 0; i < node.getColumnList().size(); ++i) {
                node.getColumnList().getObjectName(i).accept(this);
                if (i == node.getColumnList().size() - 1) continue;
                this.acceptSymbol(",");
            }
            this.acceptSymbol(")");
        }
        if (node.getConstant() != null) {
            this.acceptKeyword("as");
            node.getConstant().accept(this);
        } else if (node.getConstantList() != null) {
            this.acceptKeyword("as");
            this.acceptSymbol("(");
            for (i = 0; i < node.getConstantList().size(); ++i) {
                node.getConstantList().getElement(i).accept(this);
                if (i == node.getConstantList().size() - 1) continue;
                this.acceptSymbol(",");
            }
            this.acceptSymbol(")");
        }
    }

    @Override
    public void preVisit(TUnpivotInClause node) {
        this.acceptKeyword("in");
        this.acceptSymbol("(");
        for (int i = 0; i < node.getItems().size(); ++i) {
            node.getItems().getElement(i).accept(this);
            if (i == node.getItems().size() - 1) continue;
            this.acceptSymbol(",");
        }
        this.acceptSymbol(")");
    }

    @Override
    public void preVisit(TCaseExpression node) {
        this.acceptKeyword("case");
        if (node.getInput_expr() != null) {
            node.getInput_expr().accept(this);
        }
        for (int i = 0; i < node.getWhenClauseItemList().size(); ++i) {
            node.getWhenClauseItemList().getWhenClauseItem(i).accept(this);
            if (i == node.getWhenClauseItemList().size() - 1) continue;
            this.acceptNewline();
        }
        if (node.getElse_expr() != null) {
            this.acceptNewline();
            this.acceptKeyword("else");
            node.getElse_expr().accept(this);
        }
        if (node.getElse_statement_list().size() > 0) {
            node.getElse_statement_list().accept(this);
        }
        this.acceptNewline();
        this.acceptKeyword("end");
    }

    @Override
    public void preVisit(TWhenClauseItem node) {
        this.acceptKeyword("when");
        node.getComparison_expr().accept(this);
        this.acceptNewline();
        this.acceptKeyword("then");
        if (node.getReturn_expr() != null) {
            node.getReturn_expr().accept(this);
        } else if (node.getStatement_list().size() > 0) {
            for (int i = 0; i < node.getStatement_list().size(); ++i) {
                node.getStatement_list().get(i).accept(this);
            }
        }
    }

    @Override
    public void preVisit(TForUpdate node) {
        switch (node.getForUpdateType()) {
            case forReadOnly: {
                this.acceptKeyword("read");
                this.acceptKeyword("only");
                break;
            }
            case forUpdate: {
                this.acceptKeyword("for");
                this.acceptKeyword("update");
                break;
            }
            case forUpdateOf: {
                this.acceptKeyword("for");
                this.acceptKeyword("update");
                this.acceptKeyword("of");
            }
        }
        if (node.getColumnRefs() != null) {
            this.visitObjectNameList(node.getColumnRefs());
        }
        if (node.isNowait()) {
            this.acceptKeyword("nowait");
        }
        if (node.isWait()) {
            this.acceptKeyword("wait");
            this.acceptIdentifier(node.getWaitValue());
        }
    }

    @Override
    public void preVisit(TDeleteSqlStatement stmt) {
        if (stmt.getCteList() != null) {
            this.acceptKeyword("with");
            this.visitCTEList(stmt.getCteList());
        }
        this.acceptKeyword("delete");
        if (stmt.getTopClause() != null) {
            stmt.getTopClause().accept(this);
        }
        if (stmt.isFromKeyword()) {
            this.acceptKeyword("from");
        }
        stmt.getTargetTable().accept(this);
        if (stmt.joins.size() > 0) {
            this.acceptNewline();
            this.acceptKeyword("from");
            this.visitJoinList(stmt.joins);
        }
        if (stmt.getOutputClause() != null) {
            stmt.getOutputClause().accept(this);
        }
        if (stmt.getWhereClause() != null) {
            this.acceptNewline();
            stmt.getWhereClause().accept(this);
        }
        if (stmt.getReturningClause() != null) {
            stmt.getReturningClause().accept(this);
        }
    }

    @Override
    public void preVisit(TUpdateSqlStatement stmt) {
        if (stmt.getCteList() != null) {
            this.acceptKeyword("with");
            this.visitCTEList(stmt.getCteList());
        }
        this.acceptKeyword("update");
        if (stmt.getTopClause() != null) {
            stmt.getTopClause().accept(this);
        }
        if (this.getDBVerdor(stmt) == EDbVendor.dbvmysql) {
            if (stmt.joins.size() > 0) {
                this.visitJoinList(stmt.joins);
            } else {
                stmt.getTargetTable().accept(this);
            }
        } else {
            stmt.getTargetTable().accept(this);
        }
        this.acceptNewline();
        this.acceptKeyword("set");
        this.visitResultColumnList(stmt.getResultColumnList());
        if (this.getDBVerdor(stmt) != EDbVendor.dbvmysql && stmt.joins.size() > 0) {
            this.acceptNewline();
            this.acceptKeyword("from");
            this.visitJoinList(stmt.joins);
        }
        if (stmt.getWhereClause() != null) {
            this.acceptNewline();
            stmt.getWhereClause().accept(this);
        }
        if (stmt.getOrderByClause() != null) {
            stmt.getOrderByClause().accept(this);
        }
        if (stmt.getLimitClause() != null) {
            stmt.getLimitClause().accept(this);
        }
        if (stmt.getOutputClause() != null) {
            stmt.getOutputClause().accept(this);
        }
        if (stmt.getReturningClause() != null) {
            stmt.getReturningClause().accept(this);
        }
    }

    private EDbVendor getDBVerdor(TCustomSqlStatement stmt) {
        if (stmt.dbvendor != null) {
            return stmt.dbvendor;
        }
        if (stmt.getGsqlparser() != null) {
            return stmt.getGsqlparser().getDbVendor();
        }
        return null;
    }

    @Override
    public void preVisit(TInsertSqlStatement stmt) {
        int i;
        boolean insertAll = false;
        if (stmt.getCteList() != null) {
            this.acceptKeyword("with");
            this.visitCTEList(stmt.getCteList());
        }
        this.acceptKeyword("insert");
        if (stmt.isInsertAll()) {
            this.acceptKeyword("all");
        }
        if (stmt.isInsertFirst()) {
            this.acceptKeyword("first");
        }
        if (stmt.getInsertConditions() != null && stmt.getInsertConditions().size() > 0) {
            for (i = 0; i < stmt.getInsertConditions().size(); ++i) {
                TInsertCondition condition = stmt.getInsertConditions().getElement(i);
                this.preVisit(condition);
            }
            insertAll = true;
        }
        if (stmt.getElseIntoValues() != null) {
            this.acceptKeyword("else");
            for (i = 0; i < stmt.getElseIntoValues().size(); ++i) {
                stmt.getElseIntoValues().getElement(i).accept(this);
            }
            insertAll = true;
        }
        if (insertAll && stmt.getSubQuery() != null) {
            this.acceptNewline();
            stmt.getSubQuery().accept(this);
        }
        if (!insertAll) {
            this.acceptKeyword("into");
            if (stmt.getTargetTable() != null) {
                stmt.getTargetTable().accept(this);
            }
            if (stmt.getColumnList() != null) {
                this.acceptSymbol("(");
                this.visitObjectNameList(stmt.getColumnList());
                this.acceptSymbol(")");
            }
            switch (stmt.getInsertSource()) {
                case values: {
                    this.acceptNewline();
                    this.acceptKeyword("values");
                    TMultiTargetList multiTargetList = stmt.getValues();
                    this.visitMultiTargetList(multiTargetList);
                    break;
                }
                case subquery: {
                    this.acceptNewline();
                    stmt.getSubQuery().accept(this);
                    break;
                }
                case values_empty: {
                    break;
                }
                case values_function: {
                    this.acceptNewline();
                    this.acceptKeyword("values");
                    stmt.getFunctionCall().accept(this);
                    break;
                }
                case values_oracle_record: {
                    this.acceptNewline();
                    this.acceptKeyword("values");
                    stmt.getRecordName().accept(this);
                    break;
                }
                case set_column_value: {
                    break;
                }
            }
        }
        if (stmt.getOnDuplicateKeyUpdate() != null) {
            this.acceptKeyword("on");
            this.acceptKeyword("duplicate");
            this.acceptKeyword("key");
            this.acceptKeyword("update");
            this.visitResultColumnList(stmt.getOnDuplicateKeyUpdate());
        }
        if (stmt.getReturningClause() != null) {
            this.acceptNewline();
            stmt.getReturningClause().accept(this);
        }
    }

    @Override
    public void preVisit(TInsertCondition node) {
        if (node.getCondition() != null) {
            this.acceptNewline();
            this.acceptKeyword("when");
            this.preVisit(node.getCondition());
            this.acceptKeyword("then");
        }
        if (node.getInsertIntoValues() != null && node.getInsertIntoValues().size() > 0) {
            this.acceptNewline();
            for (int i = 0; i < node.getInsertIntoValues().size(); ++i) {
                TInsertIntoValue value = node.getInsertIntoValues().getElement(i);
                this.preVisit(value);
            }
        }
    }

    @Override
    public void preVisit(TInsertIntoValue node) {
        if (node.getTable() != null) {
            this.acceptKeyword("into");
            this.preVisit(node.getTable());
            if (node.getColumnList() != null && node.getColumnList().size() > 0) {
                this.acceptSymbol("(");
                this.visitObjectNameList(node.getColumnList());
                this.acceptSymbol(")");
            }
            if (node.getTargetList() != null && node.getTargetList().size() > 0) {
                this.acceptKeyword("values");
                TMultiTargetList multiTargetList = node.getTargetList();
                this.visitMultiTargetList(multiTargetList);
            }
        }
    }

    private void visitMultiTargetList(TMultiTargetList multiTargetList) {
        for (int i = 0; i < multiTargetList.size(); ++i) {
            TMultiTarget multiTarget = multiTargetList.getMultiTarget(i);
            this.acceptSymbol("(");
            for (int j = 0; j < multiTarget.getColumnList().size(); ++j) {
                if (multiTarget.getColumnList().getResultColumn(j).isPlaceHolder()) continue;
                multiTarget.getColumnList().getResultColumn(j).getExpr().accept(this);
                if (j == multiTarget.getColumnList().size() - 1) continue;
                this.acceptSymbol(",");
            }
            this.acceptSymbol(")");
            if (i == multiTargetList.size() - 1) continue;
            this.acceptSymbol(",");
        }
    }

    @Override
    public void preVisit(TMergeSqlStatement stmt) {
        if (stmt.getCteList() != null) {
            this.acceptKeyword("with");
            this.visitCTEList(stmt.getCteList());
        }
        this.acceptKeyword("merge");
        this.acceptKeyword("into");
        stmt.getTargetTable().accept(this);
        this.acceptKeyword("using");
        stmt.getUsingTable().accept(this);
        this.acceptKeyword("on");
        this.acceptSymbol("(");
        stmt.getCondition().accept(this);
        this.acceptSymbol(")");
        this.acceptNewline();
        if (stmt.getWhenClauses() != null) {
            for (int i = 0; i < stmt.getWhenClauses().size(); ++i) {
                TMergeWhenClause whenClause = stmt.getWhenClauses().getElement(i);
                whenClause.accept(this);
            }
        }
    }

    @Override
    public void preVisit(TMergeWhenClause node) {
        switch (node.getType()) {
            case 1: {
                this.acceptKeyword("when");
                this.acceptKeyword("matched");
                this.acceptKeyword("then");
                break;
            }
            case 2: {
                this.acceptKeyword("when");
                this.acceptKeyword("not");
                this.acceptKeyword("matched");
                this.acceptKeyword("then");
                break;
            }
            case 3: {
                this.acceptKeyword("when");
                this.acceptKeyword("matched");
                this.acceptKeyword("and");
                node.getCondition().accept(this);
                this.acceptKeyword("then");
                break;
            }
            case 4: {
                this.acceptKeyword("when");
                this.acceptKeyword("not");
                this.acceptKeyword("matched");
                this.acceptKeyword("and");
                node.getCondition().accept(this);
                this.acceptKeyword("then");
                break;
            }
            case 5: {
                this.acceptKeyword("when");
                this.acceptKeyword("not");
                this.acceptKeyword("matched");
                this.acceptKeyword("by");
                this.acceptKeyword("target");
                this.acceptKeyword("then");
                break;
            }
            case 6: {
                this.acceptKeyword("when");
                this.acceptKeyword("not");
                this.acceptKeyword("matched");
                this.acceptKeyword("by");
                this.acceptKeyword("target");
                this.acceptKeyword("and");
                node.getCondition().accept(this);
                this.acceptKeyword("then");
                break;
            }
            case 7: {
                this.acceptKeyword("when");
                this.acceptKeyword("not");
                this.acceptKeyword("matched");
                this.acceptKeyword("by");
                this.acceptKeyword("source");
                this.acceptKeyword("then");
                break;
            }
            case 8: {
                this.acceptKeyword("when");
                this.acceptKeyword("not");
                this.acceptKeyword("matched");
                this.acceptKeyword("by");
                this.acceptKeyword("source");
                this.acceptKeyword("and");
                node.getCondition().accept(this);
                this.acceptKeyword("then");
                break;
            }
        }
        if (node.getUpdateClause() != null) {
            node.getUpdateClause().accept(this);
        }
        if (node.getInsertClause() != null) {
            node.getInsertClause().accept(this);
        }
        if (node.getDeleteClause() != null) {
            node.getDeleteClause().accept(this);
        }
    }

    @Override
    public void preVisit(TMergeUpdateClause node) {
        this.acceptKeyword("update");
        this.acceptKeyword("set");
        if (node.getUpdateColumnList() != null) {
            this.visitResultColumnList(node.getUpdateColumnList());
        }
        if (node.getUpdateWhereClause() != null) {
            this.acceptNewline();
            this.acceptKeyword("where");
            node.getUpdateWhereClause().accept(this);
        }
        if (node.getDeleteWhereClause() != null) {
            this.acceptNewline();
            this.acceptKeyword("delete");
            node.getDeleteWhereClause().accept(this);
        }
    }

    @Override
    public void preVisit(TMergeInsertClause node) {
        this.acceptKeyword("insert");
        if (node.getColumnList() != null) {
            this.acceptSymbol("(");
            this.visitObjectNameList(node.getColumnList());
            this.acceptSymbol(")");
        }
        this.acceptKeyword("values");
        if (node.getValuelist() != null) {
            this.acceptSymbol("(");
            this.visitResultColumnList(node.getValuelist());
            this.acceptSymbol(")");
        }
        if (node.getInsertWhereClause() != null) {
            this.acceptNewline();
            this.acceptKeyword("where");
            node.getInsertWhereClause().accept(this);
        }
    }

    @Override
    public void preVisit(TMergeDeleteClause node) {
    }

    @Override
    public void preVisit(TCreateTableSqlStatement stmt) {
        this.acceptKeyword("create");
        if (!stmt.getTableKinds().isEmpty()) {
            if (stmt.getTableKinds().contains((Object)ETableKind.etkBase)) {
                this.acceptKeyword("base");
            }
            if (stmt.getTableKinds().contains((Object)ETableKind.etkTemporary)) {
                this.acceptKeyword("temporary");
            }
            if (stmt.getTableKinds().contains((Object)ETableKind.etkGlobalTemporary)) {
                this.acceptKeyword("global");
                this.acceptKeyword("temporary");
            }
            if (stmt.getTableKinds().contains((Object)ETableKind.etkLocalTemporary)) {
                this.acceptKeyword("local");
                this.acceptKeyword("temporary");
            }
            if (stmt.getTableKinds().contains((Object)ETableKind.etkTemp)) {
                this.acceptKeyword("temp");
            }
            if (stmt.getTableKinds().contains((Object)ETableKind.etkGlobalTemp)) {
                this.acceptKeyword("global");
                this.acceptKeyword("temp");
            }
            if (stmt.getTableKinds().contains((Object)ETableKind.etkLocalTemp)) {
                this.acceptKeyword("local");
                this.acceptKeyword("temp");
            }
            if (stmt.getTableKinds().contains((Object)ETableKind.etkVolatile)) {
                this.acceptKeyword("volatile");
            }
            if (stmt.getTableKinds().contains((Object)ETableKind.etkSet)) {
                this.acceptKeyword("set");
            }
            if (stmt.getTableKinds().contains((Object)ETableKind.etkMultiset)) {
                this.acceptKeyword("multiset");
            }
            if (stmt.getTableKinds().contains((Object)ETableKind.etkExternal)) {
                this.acceptKeyword("external");
            }
        }
        this.acceptKeyword("table");
        stmt.getTargetTable().accept(this);
        if (stmt.getSubQuery() != null) {
            this.acceptKeyword("as");
            this.acceptNewline();
            stmt.getSubQuery().accept(this);
        } else {
            int i;
            this.acceptSymbol("(");
            this.acceptNewline();
            for (i = 0; i < stmt.getColumnList().size(); ++i) {
                stmt.getColumnList().getColumn(i).accept(this);
                if (i == stmt.getColumnList().size() - 1) continue;
                this.acceptSymbol(",");
            }
            if (stmt.getTableConstraints() != null && stmt.getTableConstraints().size() > 0) {
                this.acceptNewline();
                this.acceptSymbol(",");
                for (i = 0; i < stmt.getTableConstraints().size(); ++i) {
                    stmt.getTableConstraints().getConstraint(i).accept(this);
                    if (i == stmt.getTableConstraints().size() - 1) continue;
                    this.acceptSymbol(",");
                }
            }
            this.acceptNewline();
            this.acceptSymbol(")");
        }
        if (stmt.getMySQLTableOptionList() != null && stmt.getMySQLTableOptionList().size() > 0) {
            this.preVisit(stmt.getMySQLTableOptionList());
        }
    }

    @Override
    public void preVisit(TPTNodeList options) {
        for (int i = 0; i < options.size(); ++i) {
            Object element = options.getElement(i);
            if (!(element instanceof TMySQLCreateTableOption)) continue;
            this.preVisit((TMySQLCreateTableOption)options.getElement(i));
        }
    }

    @Override
    public void preVisit(TMySQLCreateTableOption option) {
        this.acceptKeyword(option.getOptionName());
        this.acceptSymbol("=");
        this.acceptKeyword(option.getOptionValue());
    }

    @Override
    public void preVisit(TColumnDefinition node) {
        node.getColumnName().accept(this);
        if (node.getDatatype() != null) {
            node.getDatatype().accept(this);
        }
        if (node.getDefaultExpression() != null) {
            this.acceptKeyword("default");
            node.getDefaultExpression().accept(this);
        }
        if (node.isNull()) {
            this.acceptKeyword("null");
        }
        if (node.getConstraints() != null && node.getConstraints().size() > 0) {
            for (int i = 0; i < node.getConstraints().size(); ++i) {
                node.getConstraints().getConstraint(i).accept(this);
            }
        }
        if (node.isIdentity()) {
            this.acceptKeyword("identity");
            if (node.getSeed() != null) {
                this.acceptSymbol("(");
                node.getSeed().accept(this);
                this.acceptSymbol(",");
                node.getIncrement().accept(this);
                this.acceptSymbol(")");
            }
        }
    }

    @Override
    public void preVisit(TColumnWithSortOrder node) {
        node.getColumnName().accept(this);
        if (node.getLength() != null) {
            this.acceptSymbol("(");
            node.getLength().accept(this);
            this.acceptSymbol(")");
        }
        if (node.getSortType() == ESortType.desc) {
            this.acceptKeyword("desc");
        }
        if (node.getSortType() == ESortType.asc) {
            this.acceptKeyword("asc");
        }
    }

    @Override
    public void preVisit(TConstraint node) {
        if (node.getConstraintName() != null) {
            this.acceptKeyword("constraint");
            node.getConstraintName().accept(this);
        }
        switch (node.getConstraint_type()) {
            case notnull: {
                this.acceptKeyword("not");
                this.acceptKeyword("null");
                break;
            }
            case unique: {
                this.acceptKeyword("unique");
                if (node.isClustered()) {
                    this.acceptKeyword("clustered");
                }
                if (node.isNonClustered()) {
                    this.acceptKeyword("nonclustered");
                }
                if (node.getColumnList() == null) break;
                this.acceptSymbol("(");
                for (int i = 0; i < node.getColumnList().size(); ++i) {
                    node.getColumnList().getElement(i).accept(this);
                    if (i == node.getColumnList().size() - 1) continue;
                    this.acceptSymbol(",");
                }
                this.acceptSymbol(")");
                break;
            }
            case check: {
                this.acceptKeyword("check");
                if (node.getCheckCondition() == null) break;
                this.acceptSymbol("(");
                node.getCheckCondition().accept(this);
                this.acceptSymbol(")");
                break;
            }
            case primary_key: {
                this.acceptKeyword("primary");
                this.acceptKeyword("key");
                if (node.isClustered()) {
                    this.acceptKeyword("clustered");
                }
                if (node.isNonClustered()) {
                    this.acceptKeyword("nonclustered");
                }
                if (node.getColumnList() == null) break;
                this.acceptSymbol("(");
                for (int i = 0; i < node.getColumnList().size(); ++i) {
                    node.getColumnList().getElement(i).accept(this);
                    if (i == node.getColumnList().size() - 1) continue;
                    this.acceptSymbol(",");
                }
                this.acceptSymbol(")");
                break;
            }
            case foreign_key: {
                int i;
                this.acceptKeyword("foreign");
                this.acceptKeyword("key");
                if (node.getColumnList() != null) {
                    this.acceptSymbol("(");
                    for (i = 0; i < node.getColumnList().size(); ++i) {
                        node.getColumnList().getElement(i).accept(this);
                        if (i == node.getColumnList().size() - 1) continue;
                        this.acceptSymbol(",");
                    }
                    this.acceptSymbol(")");
                }
                if (node.getReferencedObject() != null) {
                    this.acceptKeyword("references");
                    node.getReferencedObject().accept(this);
                }
                if (node.getReferencedColumnList() != null) {
                    this.acceptSymbol("(");
                    this.visitObjectNameList(node.getReferencedColumnList());
                    this.acceptSymbol(")");
                }
                if (node.getKeyActions() == null || node.getKeyActions().size() <= 0) break;
                for (i = 0; i < node.getKeyActions().size(); ++i) {
                    TKeyAction keyAction = node.getKeyActions().getElement(i);
                    this.preVisit(keyAction);
                }
                break;
            }
            case reference: {
                this.acceptKeyword("references");
                if (node.getReferencedObject() != null) {
                    node.getReferencedObject().accept(this);
                }
                if (node.getReferencedColumnList() != null) {
                    this.acceptSymbol("(");
                    this.visitObjectNameList(node.getReferencedColumnList());
                    this.acceptSymbol(")");
                }
                if (node.getKeyActions() == null || node.getKeyActions().size() <= 0) break;
                for (int i = 0; i < node.getKeyActions().size(); ++i) {
                    TKeyAction keyAction = node.getKeyActions().getElement(i);
                    this.preVisit(keyAction);
                }
                break;
            }
            case default_value: {
                this.acceptKeyword("default");
                node.getDefaultExpression().accept(this);
                break;
            }
        }
    }

    public void preVisit(TKeyAction node) {
        if (node.getActionType() == EKeyActionType.delete) {
            this.acceptKeyword("on");
            this.acceptKeyword("delete");
        }
        if (node.getActionType() == EKeyActionType.update) {
            this.acceptKeyword("on");
            this.acceptKeyword("update");
        }
        if (node.getKeyReference() != null) {
            this.preVisit(node.getKeyReference());
        }
    }

    public void preVisit(TKeyReference node) {
        if (node.getReferenceType() == EKeyReferenceType.set_null) {
            this.acceptKeyword("set");
            this.acceptKeyword("null");
        }
        if (node.getReferenceType() == EKeyReferenceType.set_default) {
            this.acceptKeyword("set");
            this.acceptKeyword("default");
        }
        if (node.getReferenceType() == EKeyReferenceType.cascade) {
            this.acceptKeyword("cascade");
        }
        if (node.getReferenceType() == EKeyReferenceType.restrict) {
            this.acceptKeyword("restrict");
        }
        if (node.getReferenceType() == EKeyReferenceType.no_action) {
            this.acceptKeyword("no");
            this.acceptKeyword("action");
        }
    }

    @Override
    public void preVisit(TTypeName node) {
        this.acceptKeyword(node.getDataTypeName());
        switch (node.getDataType()) {
            case bigint_t: 
            case bit_t: 
            case money_t: 
            case smallmoney_t: 
            case smallint_t: 
            case tinyint_t: 
            case real_t: 
            case smalldatetime_t: 
            case datetime_t: 
            case text_t: 
            case ntext_t: 
            case image_t: 
            case rowversion_t: 
            case uniqueidentifier_t: 
            case sql_variant_t: 
            case binary_float_t: 
            case binary_double_t: 
            case integer_t: 
            case int_t: 
            case double_t: 
            case date_t: {
                if (node.getPrecision() == null) break;
                this.acceptSymbol("(");
                node.getPrecision().accept(this);
                if (node.getScale() != null) {
                    this.acceptSymbol(",");
                    node.getScale().accept(this);
                }
                this.acceptSymbol(")");
                break;
            }
            case binary_t: 
            case varbinary_t: 
            case timestamp_t: 
            case long_t: 
            case raw_t: 
            case long_raw_t: 
            case blob_t: 
            case clob_t: 
            case nclob_t: 
            case bfile_t: 
            case urowid_t: {
                if (node.getLength() == null) break;
                this.acceptSymbol("(");
                node.getLength().accept(this);
                this.acceptSymbol(")");
                break;
            }
            case decimal_t: 
            case dec_t: 
            case numeric_t: 
            case number_t: 
            case float_t: {
                if (node.getPrecision() == null) break;
                this.acceptSymbol("(");
                node.getPrecision().accept(this);
                if (node.getScale() != null) {
                    this.acceptSymbol(",");
                    node.getScale().accept(this);
                }
                this.acceptSymbol(")");
                break;
            }
            case char_t: 
            case character_t: 
            case varchar_t: 
            case nchar_t: 
            case nvarchar_t: 
            case ncharacter_t: 
            case nvarchar2_t: 
            case varchar2_t: {
                if (node.isVarying()) {
                    this.acceptKeyword("varying");
                }
                if (node.getLength() != null) {
                    this.acceptSymbol("(");
                    node.getLength().accept(this);
                    if (node.isByteUnit()) {
                        this.acceptKeyword("byte");
                    }
                    if (node.isCharUnit()) {
                        this.acceptKeyword("char");
                    }
                    this.acceptSymbol(")");
                }
                if (node.getCharsetName() == null) break;
                if (node.getGsqlparser() != null && node.getGsqlparser().getDbVendor() == EDbVendor.dbvmysql) {
                    this.acceptKeyword("CHARACTER");
                    this.acceptKeyword("SET");
                    this.acceptSpace(1);
                    this.acceptIdentifier(node.getCharsetName());
                    break;
                }
                this.acceptSpace(1);
                this.acceptIdentifier(node.getCharsetName());
                break;
            }
            case datetimeoffset_t: 
            case datetime2_t: 
            case time_t: {
                if (node.getFractionalSecondsPrecision() == null) break;
                this.acceptSymbol("(");
                node.getFractionalSecondsPrecision().accept(this);
                this.acceptSymbol(")");
                break;
            }
            case timestamp_with_time_zone_t: {
                if (node.getFractionalSecondsPrecision() != null) {
                    this.acceptSymbol("(");
                    node.getFractionalSecondsPrecision().accept(this);
                    this.acceptSymbol(")");
                }
                this.acceptKeyword("with");
                this.acceptKeyword("time");
                this.acceptKeyword("zone");
                break;
            }
            case timestamp_with_local_time_zone_t: {
                if (node.getFractionalSecondsPrecision() != null) {
                    this.acceptSymbol("(");
                    node.getFractionalSecondsPrecision().accept(this);
                    this.acceptSymbol(")");
                }
                this.acceptKeyword("with");
                this.acceptKeyword("local");
                this.acceptKeyword("time");
                this.acceptKeyword("zone");
                break;
            }
            case interval_year_to_month_t: {
                if (node.getPrecision() != null) {
                    this.acceptSymbol("(");
                    node.getPrecision().accept(this);
                    this.acceptSymbol(")");
                }
                this.acceptKeyword("to");
                this.acceptKeyword("month");
                break;
            }
            case interval_day_to_second_t: {
                if (node.getPrecision() != null) {
                    this.acceptSymbol("(");
                    node.getPrecision().accept(this);
                    this.acceptSymbol(")");
                }
                this.acceptKeyword("to");
                this.acceptKeyword("second");
                if (node.getSecondsPrecision() == null) break;
                this.acceptSymbol("(");
                node.getSecondsPrecision().accept(this);
                this.acceptSymbol(")");
                break;
            }
            case generic_t: {
                break;
            }
        }
    }

    @Override
    public void preVisit(TKeepDenseRankClause node) {
        this.acceptKeyword("keep");
        this.acceptSymbol("(");
        this.acceptKeyword("dense_rank");
        if (node.isFirst()) {
            this.acceptKeyword("first");
        }
        if (node.isLast()) {
            this.acceptKeyword("last");
        }
        node.getOrderBy().accept(this);
        this.acceptSymbol(")");
    }

    @Override
    public void preVisit(TRollupCube node) {
        if (node.getOperation() == 2) {
            this.acceptKeyword("cube");
        } else if (node.getOperation() == 1) {
            this.acceptKeyword("rollup");
        }
        this.acceptSymbol("(");
        this.visitExprList(node.getItems());
        this.acceptSymbol(")");
    }

    @Override
    public void preVisit(TGroupingSet node) {
        this.acceptKeyword("grouping");
        this.acceptKeyword("sets");
        this.acceptSymbol("(");
        for (int i = 0; i < node.getItems().size(); ++i) {
            node.getItems().getGroupingSetItem(i).accept(this);
            if (i == node.getItems().size() - 1) continue;
            this.acceptSymbol(",");
        }
        this.acceptSymbol(")");
    }

    @Override
    public void preVisit(TGroupingSetItem node) {
        if (node.getRollupCubeClause() != null) {
            node.getRollupCubeClause().accept(this);
        } else if (node.getGrouping_expression() != null) {
            node.getGrouping_expression().accept(this);
        }
    }

    @Override
    public void preVisit(TReturningClause node) {
        this.acceptKeyword("returning");
        this.visitExprList(node.getColumnValueList());
        if (node.isBulkCollect()) {
            this.acceptKeyword("bulk");
            this.acceptKeyword("collect");
        }
        this.acceptKeyword("into");
        this.visitExprList(node.getVariableList());
    }

    @Override
    public void preVisit(TDropIndexSqlStatement dropIndex) {
        this.acceptKeyword("drop");
        this.acceptKeyword("index");
        if (dropIndex.getIndexName() != null) {
            dropIndex.getIndexName().accept(this);
        }
        if (dropIndex.getDropIndexItemList() != null && dropIndex.getDropIndexItemList().size() > 0) {
            for (int i = 0; i < dropIndex.getDropIndexItemList().size(); ++i) {
                TDropIndexItem item = dropIndex.getDropIndexItemList().getDropIndexItem(i);
                if (item.getIndexName() != null) {
                    item.getIndexName().accept(this);
                }
                if (item.getObjectName() == null) continue;
                this.acceptKeyword("on");
                item.getObjectName().accept(this);
            }
        }
    }

    @Override
    public void preVisit(TCreateIndexSqlStatement createIndex) {
        this.acceptKeyword("create");
        if (createIndex.isNonClustered()) {
            this.acceptKeyword("nonclustered");
        }
        if (createIndex.isClustered()) {
            this.acceptKeyword("clustered");
        }
        if (createIndex.getIndexType() == EIndexType.itUnique) {
            this.acceptKeyword("unique");
        }
        this.acceptKeyword("index");
        if (createIndex.getIndexName() != null) {
            createIndex.getIndexName().accept(this);
        }
        if (createIndex.getTableName() != null) {
            this.acceptKeyword("on");
            createIndex.getTableName().accept(this);
            if (createIndex.getColumnNameList() != null && createIndex.getColumnNameList().size() > 0) {
                this.acceptSpace(1);
                this.acceptSymbol("(");
                createIndex.getColumnNameList().accept(this);
                this.acceptSymbol(")");
            }
        }
        if (createIndex.getFilegroupOrPartitionSchemeName() != null) {
            this.acceptKeyword("on");
            createIndex.getFilegroupOrPartitionSchemeName().accept(this);
            if (createIndex.getPartitionSchemeColumns() != null && createIndex.getPartitionSchemeColumns().size() > 0) {
                this.acceptSpace(1);
                this.acceptSymbol("(");
                createIndex.getPartitionSchemeColumns().accept(this);
                this.acceptSymbol(")");
            }
        }
    }

    @Override
    public void preVisit(TOrderByItemList orderByList) {
        for (int i = 0; i < orderByList.size(); ++i) {
            orderByList.getOrderByItem(i).accept(this);
            if (i == orderByList.size() - 1) continue;
            this.acceptSymbol(",");
        }
    }

    @Override
    public void preVisit(TUseDatabase useDataBase) {
        this.acceptKeyword("use");
        if (useDataBase.getDatabaseName() != null) {
            useDataBase.getDatabaseName().accept(this);
        }
    }

    @Override
    public void preVisit(TPlsqlCreateProcedure procedure) {
        this.acceptKeyword("create");
        this.acceptKeyword("procedure");
        if (procedure.getProcedureName() != null) {
            procedure.getProcedureName().accept(this);
        }
        if (procedure.getParameterDeclarations() != null && procedure.getParameterDeclarations().size() > 0) {
            this.acceptSymbol("(");
            procedure.getParameterDeclarations().accept(this);
            this.acceptSymbol(")");
        }
        this.acceptNewline();
        if (procedure.getInvokerRightsClause() != null) {
            procedure.getInvokerRightsClause().accept(this);
        }
        this.acceptKeyword("as");
        if (procedure.getDeclareStatements() != null && procedure.getDeclareStatements().size() > 0) {
            this.acceptNewline();
            procedure.getDeclareStatements().accept(this);
            if (procedure.getDeclareStatements().size() == 1) {
                this.acceptSemicolon();
            }
        }
        this.acceptNewline();
        this.acceptKeyword("begin");
        if (procedure.getBodyStatements() != null && procedure.getBodyStatements().size() > 0) {
            this.acceptNewline();
            procedure.getBodyStatements().accept(this);
            if (procedure.getBodyStatements().size() == 1) {
                this.acceptSemicolon();
            }
        }
        this.acceptNewline();
        this.acceptKeyword("end");
        this.acceptSemicolon();
    }

    @Override
    public void preVisit(TInvokerRightsClause clause) {
        this.acceptKeyword("authid");
        if (clause.getDefiner() != null) {
            clause.getDefiner().accept(this);
        }
    }

    void visitPrecisionScale(TConstant precision, TConstant scale) {
        if (precision != null) {
            this.acceptSymbol("(");
            precision.accept(this);
            if (scale != null) {
                this.acceptSymbol(",");
                scale.accept(this);
            }
            this.acceptSymbol(")");
        }
    }

    void visitExprList(TExpressionList expressionList) {
        for (int i = 0; i < expressionList.size(); ++i) {
            expressionList.getExpression(i).accept(this);
            if (i == expressionList.size() - 1) continue;
            this.acceptSymbol(",");
        }
    }

    void visitObjectNameList(TObjectNameList objectNameList) {
        for (int i = 0; i < objectNameList.size(); ++i) {
            objectNameList.getObjectName(i).accept(this);
            if (i == objectNameList.size() - 1) continue;
            this.acceptSymbol(",");
        }
    }

    void visitCTEList(TCTEList cteList) {
        for (int i = 0; i < cteList.size(); ++i) {
            cteList.getCTE(i).accept(this);
            if (i == cteList.size() - 1) continue;
            this.acceptSymbol(",");
            this.acceptNewline();
        }
    }

    void visitJoinList(TJoinList joinList) {
        for (int i = 0; i < joinList.size(); ++i) {
            this.acceptNewline();
            joinList.getJoin(i).accept(this);
            if (i == joinList.size() - 1) continue;
            this.acceptSymbol(",");
        }
    }

    void visitResultColumnList(TResultColumnList resultColumnList) {
        for (int i = 0; i < resultColumnList.size(); ++i) {
            resultColumnList.getElement(i).accept(this);
            if (i == resultColumnList.size() - 1) continue;
            this.acceptSymbol(",");
        }
    }

    void visitNodeByToken(TParseTreeNode node) {
        if (node.getStartToken() == null) {
            return;
        }
        if (node.getEndToken() == null) {
            return;
        }
        if (node.getStartToken().container == null) {
            return;
        }
        this.acceptSpace(1);
        for (int i = node.getStartToken().posinlist; i <= node.getEndToken().posinlist; ++i) {
            this.acceptToken(node.getStartToken().container.get(i));
        }
        this.acceptSpace(1);
    }
}

