/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.utils;

import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TSourceToken;
import java.util.Arrays;

class WhitespaceSourceTokenHelper {
    WhitespaceSourceTokenHelper() {
    }

    public static TSourceToken createWhitespaceSourceToken(int length) {
        if (length == 0) {
            return null;
        }
        if (length <= 32) {
            return SourceTokenCache.cache[length - 1];
        }
        char[] tmp = new char[length];
        Arrays.fill(tmp, 0, length, ' ');
        TSourceToken token = new TSourceToken(String.copyValueOf(tmp));
        token.tokentype = ETokenType.ttwhitespace;
        return token;
    }

    private static class SourceTokenCache {
        public static final int COUNT = 32;
        static final TSourceToken[] cache = new TSourceToken[32];

        private SourceTokenCache() {
        }

        static {
            char[] tmp = new char[32];
            Arrays.fill(tmp, 0, 32, ' ');
            for (int i = 0; i < cache.length; ++i) {
                SourceTokenCache.cache[i] = new TSourceToken(String.copyValueOf(tmp, 0, i + 1));
                SourceTokenCache.cache[i].tokentype = ETokenType.ttwhitespace;
            }
        }
    }
}

