/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.utils;

import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSourceTokenList;

public class SourceTokenSearcher {
    public static int indexOf(TSourceTokenList list, int startPos, int endPos, String text) {
        if (text == null) {
            return -1;
        }
        for (int i = startPos; i < endPos; ++i) {
            if (i >= 0 && i < list.size()) {
                if (list.get((int)i).astext == null || !list.get((int)i).astext.trim().equalsIgnoreCase(text)) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    public static int indexOf(TSourceTokenList list, int startPos, int endPos, ETokenType type) {
        for (int i = startPos; i < endPos; ++i) {
            if (i >= 0 && i < list.size()) {
                if (type != list.get((int)i).tokentype) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    public static int indexOf(TSourceTokenList list, int startPos, String text) {
        return SourceTokenSearcher.indexOf(list, startPos, list.size() - 1, text);
    }

    public static TSourceToken backforwardSearch(TSourceToken token, int backsearchSize, String text) {
        int pos = SourceTokenSearcher.lastIndexOf(token.container, token.posinlist - backsearchSize, token.posinlist, text);
        if (pos == -1) {
            return null;
        }
        return token.container.get(pos);
    }

    public static TSourceToken forwardSearch(TSourceToken token, int forwardSearchSize, String text) {
        int pos = SourceTokenSearcher.indexOf(token.container, token.posinlist, token.posinlist + forwardSearchSize, text);
        if (pos == -1) {
            return null;
        }
        return token.container.get(pos);
    }

    public static int lastIndexOf(TSourceTokenList list, int startPos, int endPos, String text) {
        if (text == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        if (endPos - 1 > list.size()) {
            endPos = list.size();
        }
        for (int i = endPos - 1; i >= startPos; --i) {
            if (i >= 0 && i < list.size()) {
                if (list.get((int)i).astext == null || !list.get((int)i).astext.trim().equalsIgnoreCase(text)) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    public static int lastIndexOf(TSourceTokenList list, int endPos, String text) {
        return SourceTokenSearcher.lastIndexOf(list, 0, endPos, text);
    }

    public static TSourceToken lastNotWhitespaceAndReturnToken(TSourceTokenList list, int startPos, int endPos) {
        for (int i = endPos - 1; i >= startPos; --i) {
            if (i >= 0 && i < list.size()) {
                if (list.get((int)i).tokentype == ETokenType.ttwhitespace || list.get((int)i).tokentype == ETokenType.ttreturn || list.get((int)i).tokentype == ETokenType.ttsimplecomment || list.get((int)i).tokentype == ETokenType.ttbracketedcomment) continue;
                return list.get(i);
            }
            return null;
        }
        return null;
    }

    public static TSourceToken lastNotWhitespaceAndReturnToken(TSourceTokenList list, int endPos) {
        return SourceTokenSearcher.lastNotWhitespaceAndReturnToken(list, 0, endPos);
    }

    public static TSourceToken lastSelectedNotWhitespaceAndReturnToken(TSourceTokenList list, int endPos, String text) {
        TSourceToken token = SourceTokenSearcher.lastNotWhitespaceAndReturnToken(list, endPos);
        if (token != null && token.astext != null && token.astext.trim().equalsIgnoreCase(text)) {
            return token;
        }
        return null;
    }

    public static TSourceToken firstNotWhitespaceAndReturnToken(TSourceTokenList list, int startPos, int endPos) {
        for (int i = startPos; i < endPos; ++i) {
            if (i >= 0 && i < list.size()) {
                if (list.get((int)i).tokentype == ETokenType.ttwhitespace || list.get((int)i).tokentype == ETokenType.ttreturn || list.get((int)i).tokentype == ETokenType.ttsimplecomment || list.get((int)i).tokentype == ETokenType.ttbracketedcomment) continue;
                return list.get(i);
            }
            return null;
        }
        return null;
    }

    public static TSourceToken firstSelectNotWhitespaceAndReturnToken(TSourceTokenList list, int startPos, String text) {
        for (int i = startPos; i < list.size(); ++i) {
            if (i < 0 || i >= list.size()) continue;
            TSourceToken token = list.get(i);
            if (token.tokentype == ETokenType.ttwhitespace || token.tokentype == ETokenType.ttreturn || list.get((int)i).tokentype == ETokenType.ttsimplecomment || list.get((int)i).tokentype == ETokenType.ttbracketedcomment) continue;
            if (token.astext != null && token.astext.trim().equalsIgnoreCase(text)) {
                return token;
            }
            return null;
        }
        return null;
    }

    public static TSourceToken lastSelectedNotWhitespaceAndReturnToken(TSourceToken token, String text) {
        if (token == null) {
            return null;
        }
        return SourceTokenSearcher.lastSelectedNotWhitespaceAndReturnToken(token.container, token.posinlist, text);
    }

    public static boolean isNewLineToken(TSourceToken token) {
        return token != null && token.tokentype == ETokenType.ttreturn;
    }

    public static boolean isSimpleComment(TSourceToken token) {
        return token != null && token.tokentype == ETokenType.ttsimplecomment;
    }

    public static TSourceToken backforwardSearchNotWhitespaceAndReturnToken(TSourceToken endToken, int backforwardSearchSize, String text) {
        TSourceToken currentToken = endToken;
        while (backforwardSearchSize > 0) {
            currentToken = SourceTokenSearcher.lastNotWhitespaceAndReturnToken(currentToken.container, currentToken.posinlist);
            if (currentToken != null && currentToken.astext != null && currentToken.astext.trim().equalsIgnoreCase(text)) {
                return currentToken;
            }
            --backforwardSearchSize;
        }
        return null;
    }

    public static TSourceToken lastSelectedToken(TSourceTokenList list, int startPos, int endPos, String text) {
        for (int i = endPos; i >= startPos; --i) {
            if (i >= 0 && i < list.size()) {
                TSourceToken token = list.get(i);
                if (!token.toString().equalsIgnoreCase(text)) continue;
                return token;
            }
            return null;
        }
        return null;
    }

    public static TSourceToken firstSelectedToken(TSourceTokenList list, int startPos, int endPos, String text) {
        for (int i = startPos; i <= endPos; ++i) {
            if (i >= 0 && i < list.size()) {
                TSourceToken token = list.get(i);
                if (!token.toString().equalsIgnoreCase(text)) continue;
                return token;
            }
            return null;
        }
        return null;
    }
}

