/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.utils;

import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSourceTokenList;
import gudusoft.gsqlparser.pp.logger.PPLogger;
import gudusoft.gsqlparser.pp.para.GFmtOpt;
import gudusoft.gsqlparser.pp.utils.SourceTokenConstant;
import gudusoft.gsqlparser.pp.utils.WhitespaceSourceTokenHelper;

public class SourceTokenOperator {
    private static TSourceToken noFormatFlag = null;

    public static int removeWhitespaceBackward(GFmtOpt opt, TSourceTokenList list, int end) {
        if (end == 0) {
            return 0;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("removeWhitespaceAndReturnFromEnd:\ntargetToken:").append(list.get((int)end).astext).append(" newToken:").append(list.get((int)end).astext.replaceAll("\\n", "\\\\n")).append("(type:").append((Object)list.get((int)end).tokentype).append(")");
        int deleteWhitespaceCount = 0;
        int pos = end - 1;
        TSourceToken token = list.get(pos);
        while (token.tokentype == ETokenType.ttwhitespace) {
            if (token.tokentype == ETokenType.ttwhitespace) {
                ++deleteWhitespaceCount;
            }
            if (opt.opearateSourceToken) {
                token.setReplaceToken(SourceTokenConstant.EMPTY);
            }
            if (--pos < 0) break;
            token = token.container.get(pos);
        }
        if (token.tokentype == ETokenType.ttreturn) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < token.astext.length(); ++i) {
                char c = token.astext.charAt(i);
                if (c == ' ') continue;
                b.append(c);
            }
            token.astext = b.toString();
        }
        buf.append("\nDeleteWhiteSpace:").append(deleteWhitespaceCount);
        PPLogger.info(2, buf.toString(), null);
        return pos;
    }

    public static int removeWhitespaceAndReturnFromEnd(GFmtOpt opt, TSourceTokenList list, int end) {
        if (end == 0) {
            return 0;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("removeWhitespaceAndReturnFromEnd:\ntargetToken:").append(list.get((int)end).astext).append(" newToken:").append(list.get((int)end).astext.replaceAll("\\n", "\\\\n")).append("(type:").append((Object)list.get((int)end).tokentype).append(")");
        int deleteWhitespaceCount = 0;
        int deleteReturn = 0;
        int pos = end - 1;
        TSourceToken token = list.get(pos);
        while (token.tokentype == ETokenType.ttwhitespace || token.tokentype == ETokenType.ttreturn) {
            if (token.tokentype == ETokenType.ttwhitespace) {
                ++deleteWhitespaceCount;
            }
            if (token.tokentype == ETokenType.ttreturn) {
                ++deleteReturn;
            }
            if (opt.opearateSourceToken) {
                token.setReplaceToken(SourceTokenConstant.EMPTY);
            }
            if (--pos < 0) break;
            token = token.container.get(pos);
        }
        buf.append("\nDeleteWhiteSpace:").append(deleteWhitespaceCount).append(", DeleteReturn:").append(deleteReturn);
        PPLogger.info(2, buf.toString(), null);
        return pos;
    }

    public static int removeWhitespaceAndReturnFromEnd(GFmtOpt opt, TSourceToken token) {
        if (token == null) {
            return -1;
        }
        return SourceTokenOperator.removeWhitespaceAndReturnFromEnd(opt, token.container, token.posinlist);
    }

    public static void removeWhitespaceAndReturnFormBeforeAndAfter(GFmtOpt opt, TSourceToken token) {
        if (token == null) {
            return;
        }
        SourceTokenOperator.removeWhitespaceAndReturnFromEnd(opt, token);
        SourceTokenOperator.removeWhitespaceAndReturnFromStart(opt, token.container, token.posinlist + 1);
    }

    public static void removeWhitespaceAndReturn(GFmtOpt opt, TSourceTokenList list, int start, int end) {
        StringBuilder buf = new StringBuilder();
        buf.append("removeWhitespaceAndReturn:\ntargetToken:").append(list.get((int)end).astext).append(" newToken:").append(list.get((int)end).astext.replaceAll("\\n", "\\\\n")).append("(type:").append((Object)list.get((int)end).tokentype).append(")");
        int deleteWhitespaceCount = 0;
        int deleteReturn = 0;
        for (int i = start; i < end; ++i) {
            if (i < 0 || i > list.size()) {
                return;
            }
            TSourceToken token = list.get(i);
            if (token.tokentype != ETokenType.ttwhitespace && token.tokentype != ETokenType.ttreturn) continue;
            if (token.tokentype == ETokenType.ttwhitespace) {
                ++deleteWhitespaceCount;
            }
            if (token.tokentype == ETokenType.ttreturn) {
                ++deleteReturn;
            }
            if (!opt.opearateSourceToken) continue;
            token.setReplaceToken(SourceTokenConstant.EMPTY);
        }
        buf.append("\nDeleteWhiteSpace:").append(deleteWhitespaceCount).append(", DeleteReturn:").append(deleteReturn);
        PPLogger.info(2, buf.toString(), null);
    }

    public static int removeWhitespaceAndReturnFromStart(GFmtOpt opt, TSourceTokenList list, int startPos) {
        StringBuilder buf = new StringBuilder();
        if (list.size() <= startPos) {
            return list.size() - 1;
        }
        buf.append("removeWhitespaceAndReturnFromStart:\ntargetToken:").append(list.get((int)startPos).astext).append(" newToken:").append(list.get((int)startPos).astext.replaceAll("\\n", "\\\\n")).append("(type:").append((Object)list.get((int)startPos).tokentype).append(")");
        int deleteWhitespaceCount = 0;
        int deleteReturn = 0;
        int pos = startPos;
        TSourceToken token = list.get(pos);
        while (token.tokentype == ETokenType.ttwhitespace || token.tokentype == ETokenType.ttreturn) {
            if (token.tokentype == ETokenType.ttwhitespace) {
                ++deleteWhitespaceCount;
            }
            if (token.tokentype == ETokenType.ttreturn) {
                ++deleteReturn;
            }
            if (opt.opearateSourceToken) {
                token.setReplaceToken(SourceTokenConstant.EMPTY);
            }
            if (++pos >= list.size()) break;
            token = token.container.get(pos);
        }
        buf.append("\nDeleteWhiteSpace:").append(deleteWhitespaceCount).append(", DeleteReturn:").append(deleteReturn);
        PPLogger.info(2, buf.toString(), null);
        return pos;
    }

    public static int textLengthVT(TSourceTokenList list, int start, int end) {
        int total = 0;
        for (int i = start; i < end; ++i) {
            TSourceToken token = list.get(i);
            if (token.getTokensBefore().size() > 0) {
                total += SourceTokenOperator.textLengthVT(token.getTokensBefore(), 0, token.getTokensBefore().size());
            }
            total = token.getReplaceToken() != null ? (total += token.getReplaceToken().astext != null ? token.getReplaceToken().astext.length() : 0) : (total += token.astext != null ? token.astext.length() : 0);
            if (token.getTokensAfter().size() <= 0) continue;
            total += SourceTokenOperator.textLengthVT(token.getTokensAfter(), 0, token.getTokensAfter().size());
        }
        return total;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int curColumnNumberVT(TSourceTokenList list, int pos) {
        int total = 0;
        for (int i = pos; i >= 0; --i) {
            int j;
            TSourceToken token = list.get(i);
            if (i != pos && token.getTokensAfter().size() > 0) {
                for (j = token.getTokensAfter().size() - 1; j >= 0; --j) {
                    TSourceToken after = token.getTokensAfter().get(j);
                    if (after.tokentype == ETokenType.ttreturn) return total;
                    total += after.astext != null ? after.astext.length() : 0;
                }
            }
            if (i != pos) {
                if (token.getReplaceToken() != null) {
                    if (token.getReplaceToken().tokentype == ETokenType.ttreturn) return total;
                    total += token.getReplaceToken().astext != null ? token.getReplaceToken().astext.length() : 0;
                } else {
                    if (token.tokentype == ETokenType.ttreturn) return total;
                    if (token.tokentype == ETokenType.ttsimplecomment) {
                        if (token.nextToken() == null || token.nextToken().astext == null || token.nextToken().astext.trim().length() != 0) continue;
                        total -= token.nextToken().astext.length();
                        continue;
                    }
                    if (SourceTokenOperator.isOracleHint(token)) {
                        if (token.nextToken() == null || token.nextToken().astext == null || token.nextToken().astext.trim().length() != 0) continue;
                        total -= token.nextToken().astext.length();
                        continue;
                    }
                    total += token.astext != null ? token.astext.length() : 0;
                }
            }
            if (token.getTokensBefore().size() <= 0) continue;
            for (j = token.getTokensBefore().size() - 1; j >= 0; --j) {
                TSourceToken before = token.getTokensBefore().get(j);
                if (before.tokentype == ETokenType.ttreturn) return total;
                total += before.astext != null ? before.astext.length() : 0;
            }
        }
        return total;
    }

    private static boolean isOracleHint(TSourceToken token) {
        return token != null && token.astext != null && token.astext.startsWith("/*+");
    }

    public static int curColumnNumberVT(TSourceToken token) {
        return SourceTokenOperator.curColumnNumberVT(token.container, token.posinlist);
    }

    public static int curIndentLenVT(TSourceTokenList list, int pos) {
        int indentLen = 0;
        for (int i = pos; i >= 0; --i) {
            int j;
            TSourceToken token = list.get(i);
            if (i != pos && token.getTokensAfter().size() > 0) {
                for (j = token.getTokensAfter().size() - 1; j >= 0; --j) {
                    TSourceToken after = token.getTokensAfter().get(j);
                    if (after.tokentype == ETokenType.ttreturn) {
                        return indentLen;
                    }
                    if (after.tokentype == ETokenType.ttwhitespace) {
                        indentLen += after.astext != null ? after.astext.length() : 0;
                        continue;
                    }
                    indentLen = 0;
                }
            }
            if (i != pos) {
                if (token.getReplaceToken() != null) {
                    if (token.getReplaceToken().tokentype == ETokenType.ttreturn) {
                        return indentLen;
                    }
                    indentLen = token.getReplaceToken().tokentype == ETokenType.ttwhitespace ? (indentLen += token.getReplaceToken().astext != null ? token.getReplaceToken().astext.length() : 0) : 0;
                } else {
                    if (token.tokentype == ETokenType.ttreturn) {
                        return indentLen;
                    }
                    indentLen = token.tokentype == ETokenType.ttwhitespace ? (indentLen += token.astext != null ? token.astext.length() : 0) : 0;
                }
            }
            if (token.getTokensBefore().size() <= 0) continue;
            for (j = token.getTokensBefore().size() - 1; j >= 0; --j) {
                TSourceToken before = token.getTokensBefore().get(j);
                if (before.tokentype == ETokenType.ttreturn) {
                    return indentLen;
                }
                if (before.tokentype == ETokenType.ttwhitespace) {
                    indentLen += before.astext != null ? before.astext.length() : 0;
                    continue;
                }
                indentLen = 0;
            }
        }
        return indentLen;
    }

    public static int curIndentLenVT(TSourceToken token) {
        return SourceTokenOperator.curIndentLenVT(token.container, token.posinlist);
    }

    public static TSourceToken createWhitespaceSourceToken(int length) {
        return WhitespaceSourceTokenHelper.createWhitespaceSourceToken(length);
    }

    public static TSourceToken createNoFormatFlagToken() {
        return noFormatFlag;
    }

    public static TSourceToken createReturnSourceToken() {
        TSourceToken t = new TSourceToken("\n");
        t.tokentype = ETokenType.ttreturn;
        return t;
    }

    public static void combineWhitespace(TSourceTokenList list, int startPos, int endPos) {
        boolean findWhitespace = false;
        for (int i = startPos; i < endPos; ++i) {
            if (i < 0 || i >= list.size()) continue;
            TSourceToken token = list.get(i);
            if (token.tokentype != ETokenType.ttwhitespace) continue;
            token.setReplaceToken(SourceTokenConstant.EMPTY);
            findWhitespace = true;
        }
        if (findWhitespace) {
            list.get(endPos).getTokensBefore().add(SourceTokenOperator.createWhitespaceSourceToken(1));
        }
    }

    public static void addBefore(GFmtOpt opt, TSourceToken targetToken, TSourceToken needAddToken) {
        if (needAddToken == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("AddBefore:\ntargetToken:").append(targetToken.astext).append("(pos:").append(targetToken.posinlist).append(")").append(" newToken:").append(needAddToken.astext.replaceAll("\\n", "\\\\n")).append("(type:").append((Object)needAddToken.tokentype).append(")");
        if (targetToken.getTokensBefore().size() > 0) {
            buf.append("\noldTokenBefore:");
            for (int i = 0; i < targetToken.getTokensBefore().size(); ++i) {
                TSourceToken token = targetToken.getTokensBefore().get(i);
                buf.append("[").append(token.astext != null ? token.astext.replaceAll("\\n", "\\\\n") : "").append("] ").append("(type:").append((Object)token.tokentype).append(")");
            }
        }
        PPLogger.info(2, buf.toString(), null);
        if (opt.opearateSourceToken) {
            targetToken.getTokensBefore().add(needAddToken);
        }
    }

    public static void addAfter(GFmtOpt opt, TSourceToken targetToken, TSourceToken needAddToken) {
        if (needAddToken == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("AddAfter:\ntargetToken:").append(targetToken.astext).append("(pos:").append(targetToken.posinlist).append(")").append(" newToken:").append(needAddToken.astext != null ? needAddToken.astext.replaceAll("\\n", "\\\\n") : "").append("(type:").append((Object)needAddToken.tokentype).append(")");
        if (targetToken.getTokensAfter().size() > 0) {
            buf.append("\noldTokenAfter:");
            for (int i = 0; i < targetToken.getTokensAfter().size(); ++i) {
                TSourceToken token = targetToken.getTokensAfter().get(i);
                buf.append("[").append(token.astext != null ? token.astext.replaceAll("\\n", "\\\\n") : "").append("] ").append("(type:").append((Object)token.tokentype).append(")");
            }
        }
        PPLogger.info(2, buf.toString(), null);
        if (opt.opearateSourceToken) {
            targetToken.getTokensAfter().add(needAddToken);
        }
    }

    public static void removeAllBeforeTokenVT(GFmtOpt opt, TSourceToken targetToken) {
        StringBuilder buf = new StringBuilder();
        buf.append("RemoveAllBeforeTokenVT:");
        while (targetToken.getTokensBefore().size() > 0) {
            TSourceToken token = targetToken.getTokensBefore().get(0);
            buf.append("\nremoveToken:").append("[").append(token.astext != null ? token.astext.replaceAll("\\n", "\\\\n") : "").append("] ").append("(type:").append((Object)token.tokentype).append(")");
            if (!opt.opearateSourceToken) continue;
            targetToken.getTokensBefore().remove(0);
        }
        PPLogger.info(2, buf.toString(), null);
    }

    public static void removeThisToken(TSourceToken token) {
        token.setReplaceToken(SourceTokenOperator.createWhitespaceSourceToken(1));
    }

    static {
        noFormatFlag = new TSourceToken("");
        SourceTokenOperator.noFormatFlag.tokentype = ETokenType.ttwhitespace;
    }
}

