/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.stmtformatter.type.comm;

import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TGroupByItemList;
import gudusoft.gsqlparser.nodes.TJoin;
import gudusoft.gsqlparser.nodes.TJoinItem;
import gudusoft.gsqlparser.nodes.TJoinList;
import gudusoft.gsqlparser.nodes.TOrderByItemList;
import gudusoft.gsqlparser.nodes.TResultColumn;
import gudusoft.gsqlparser.nodes.TResultColumnList;
import gudusoft.gsqlparser.nodes.TTableList;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.processor.type.select.UnionProcessor;
import gudusoft.gsqlparser.pp.stmtformatter.type.AbstractStmtFormatter;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;
import java.util.ArrayList;
import java.util.List;

public class SelectStmtFormatter
extends AbstractStmtFormatter<TSelectSqlStatement> {
    private List<AbstractProcessor> itemListProcessors;
    private List<AbstractProcessor> itemListAlignProcessors;
    private List<AbstractProcessor> tableClauseProcessors;
    private List<AbstractProcessor> fromJoinClauseProcessors;
    private List<AbstractProcessor> groupByClauseProcessors;
    private List<AbstractProcessor> orderByClauseProcessors;
    private List<AbstractProcessor> whereClauseProcessors;
    private List<AbstractProcessor> whereExpProcessors;
    private List<AbstractProcessor> havingClauseProcessors;
    private List<AbstractProcessor> intoClauseProcessors;
    private UnionProcessor unionProcessor;

    public void addItemListProcessor(AbstractProcessor p) {
        if (this.itemListProcessors == null) {
            this.itemListProcessors = new ArrayList<AbstractProcessor>();
        }
        this.itemListProcessors.add(p);
    }

    public void addItemListAlignProcessor(AbstractProcessor p) {
        if (this.itemListAlignProcessors == null) {
            this.itemListAlignProcessors = new ArrayList<AbstractProcessor>();
        }
        this.itemListAlignProcessors.add(p);
    }

    public void addTableClauseProcessor(AbstractProcessor p) {
        if (this.tableClauseProcessors == null) {
            this.tableClauseProcessors = new ArrayList<AbstractProcessor>();
        }
        this.tableClauseProcessors.add(p);
    }

    public void addFromJoinClauseProcessor(AbstractProcessor p) {
        if (this.fromJoinClauseProcessors == null) {
            this.fromJoinClauseProcessors = new ArrayList<AbstractProcessor>();
        }
        this.fromJoinClauseProcessors.add(p);
    }

    public void addGroupByClauseProcessor(AbstractProcessor p) {
        if (this.groupByClauseProcessors == null) {
            this.groupByClauseProcessors = new ArrayList<AbstractProcessor>();
        }
        this.groupByClauseProcessors.add(p);
    }

    public void addOrderByClauseProcessor(AbstractProcessor p) {
        if (this.orderByClauseProcessors == null) {
            this.orderByClauseProcessors = new ArrayList<AbstractProcessor>();
        }
        this.orderByClauseProcessors.add(p);
    }

    public void addWhereClauseProcessor(AbstractProcessor p) {
        if (this.whereClauseProcessors == null) {
            this.whereClauseProcessors = new ArrayList<AbstractProcessor>();
        }
        this.whereClauseProcessors.add(p);
    }

    public void addWhereExpProcessors(AbstractProcessor p) {
        if (this.whereExpProcessors == null) {
            this.whereExpProcessors = new ArrayList<AbstractProcessor>();
        }
        this.whereExpProcessors.add(p);
    }

    public void addHavingClauseProcessor(AbstractProcessor p) {
        if (this.havingClauseProcessors == null) {
            this.havingClauseProcessors = new ArrayList<AbstractProcessor>();
        }
        this.havingClauseProcessors.add(p);
    }

    public void addIntoClauseProcessor(AbstractProcessor p) {
        if (this.intoClauseProcessors == null) {
            this.intoClauseProcessors = new ArrayList<AbstractProcessor>();
        }
        this.intoClauseProcessors.add(p);
    }

    @Override
    protected void doFormat(TSelectSqlStatement sql) {
        this.formatSingleStatmenet(sql);
        boolean isUnion = false;
        if (sql.getLeftStmt() != null || sql.getRightStmt() != null) {
            isUnion = true;
        }
        if (isUnion) {
            TSelectSqlStatement rightSql;
            TSelectSqlStatement leftSql = sql.getLeftStmt();
            if (leftSql != null) {
                this.format(leftSql);
            }
            if (this.unionProcessor != null) {
                ArrayList<AbstractProcessor> processors = new ArrayList<AbstractProcessor>();
                processors.add(this.unionProcessor);
                this.runProcessor(processors, sql);
            }
            if ((rightSql = sql.getRightStmt()) != null) {
                this.format(rightSql);
            }
            return;
        }
    }

    private void formatSingleStatmenet(TSelectSqlStatement sql) {
        TOrderByItemList orders;
        this.runProcessor(this.getSpecialProcessors(), sql);
        TResultColumnList columnList = sql.getResultColumnList();
        this.runProcessor(this.itemListProcessors, columnList);
        if (columnList != null) {
            for (int i = 0; i < columnList.size(); ++i) {
                TResultColumn column = columnList.getResultColumn(i);
                if (column.getExpr() == null) continue;
                this.runProcessor(this.getExpressionProcessors(), column.getExpr());
            }
        }
        this.runProcessor(this.itemListAlignProcessors, columnList);
        TTableList tables = sql.tables;
        this.runProcessor(this.tableClauseProcessors, tables);
        this.runProcessor(this.fromJoinClauseProcessors, sql);
        if (sql.getWhereClause() != null) {
            this.runProcessor(this.whereClauseProcessors, sql.getWhereClause().getCondition());
            this.runProcessor(this.whereExpProcessors, sql.getWhereClause().getCondition());
        }
        if (sql.getGroupByClause() != null) {
            TExpression havingClause;
            TGroupByItemList groups = sql.getGroupByClause().getItems();
            if (groups.size() > 0) {
                this.runProcessor(this.groupByClauseProcessors, groups);
            }
            if ((havingClause = sql.getGroupByClause().getHavingClause()) != null) {
                this.runProcessor(this.havingClauseProcessors, havingClause);
                this.runProcessor(this.getExpressionProcessors(), havingClause);
            }
        }
        if (sql.getOrderbyClause() != null && (orders = sql.getOrderbyClause().getItems()).size() > 0) {
            this.runProcessor(this.orderByClauseProcessors, orders);
            for (int i = 0; i < orders.size(); ++i) {
                this.runProcessor(this.getExpressionProcessors(), orders.getOrderByItem(i).getSortKey());
            }
        }
        TJoinList joins = sql.joins;
        for (int i = 0; i < joins.size(); ++i) {
            TJoin join = joins.getJoin(i);
            for (int j = 0; j < join.getJoinItems().size(); ++j) {
                TJoinItem lcitem = join.getJoinItems().getJoinItem(j);
                if (lcitem == null || lcitem.getOnCondition() == null) continue;
                this.runProcessor(this.getExpressionProcessors(), lcitem.getOnCondition());
            }
        }
        if (sql.getIntoClause() != null) {
            this.runProcessor(this.intoClauseProcessors, sql.getIntoClause().getExprList());
        }
    }

    public UnionProcessor getUnionProcessor() {
        return this.unionProcessor;
    }

    public void setUnionProcessor(UnionProcessor unionProcessor) {
        this.unionProcessor = unionProcessor;
    }
}

