/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.stmtformatter.type.comm;

import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TInsertIntoValue;
import gudusoft.gsqlparser.nodes.TMultiTarget;
import gudusoft.gsqlparser.nodes.TMultiTargetList;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TResultColumn;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.processor.type.comm.ExpressionProcessor;
import gudusoft.gsqlparser.pp.stmtformatter.type.AbstractStmtFormatter;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import gudusoft.gsqlparser.stmt.TInsertSqlStatement;
import java.util.ArrayList;
import java.util.List;

public class InsertStmtFormatter
extends AbstractStmtFormatter<TInsertSqlStatement> {
    private List<AbstractProcessor> itemListProcessors;
    private List<AbstractProcessor> valueListProcessors;

    public void addItemListProcessor(AbstractProcessor p) {
        if (this.itemListProcessors == null) {
            this.itemListProcessors = new ArrayList<AbstractProcessor>();
        }
        this.itemListProcessors.add(p);
    }

    public void addValueListProcessor(AbstractProcessor p) {
        if (this.valueListProcessors == null) {
            this.valueListProcessors = new ArrayList<AbstractProcessor>();
        }
        this.valueListProcessors.add(p);
    }

    @Override
    protected void doFormat(TInsertSqlStatement stmt) {
        this.runProcessor(this.getSpecialProcessors(), stmt);
        TObjectNameList columns = stmt.getColumnList();
        this.runProcessor(this.itemListProcessors, columns);
        TMultiTargetList multiTarget = stmt.getValues();
        this.processValues(multiTarget);
        if (stmt.getInsertIntoValues() != null && stmt.getInsertIntoValues().size() > 0) {
            for (int i = 0; i < stmt.getInsertIntoValues().size(); ++i) {
                TInsertIntoValue insertValue = stmt.getInsertIntoValues().getElement(i);
                this.runProcessor(this.itemListProcessors, insertValue.getColumnList());
                this.processValues(insertValue.getTargetList());
            }
        }
        if (stmt.getSubQuery() != null) {
            TSourceToken selectToken;
            TSourceToken token = stmt.getStartToken();
            int curIndetLen = SourceTokenOperator.curIndentLenVT(token);
            if (stmt.getHiveInsertType() != null && (selectToken = SourceTokenSearcher.firstSelectedToken(stmt.getSubQuery().getEndToken().container, stmt.getSubQuery().getStartToken().posinlist, stmt.getSubQuery().getEndToken().posinlist, "select")) != null) {
                SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), selectToken);
                SourceTokenOperator.addBefore(this.getOption(), selectToken, SourceTokenOperator.createReturnSourceToken());
                SourceTokenOperator.addBefore(this.getOption(), selectToken, SourceTokenOperator.createWhitespaceSourceToken(curIndetLen + this.getOption().indentLen));
            }
            if (stmt.getInsertIntoValues() != null && stmt.getInsertIntoValues().size() > 0) {
                SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), stmt.getSubQuery().getStartToken());
                SourceTokenOperator.addBefore(this.getOption(), stmt.getSubQuery().getStartToken(), SourceTokenOperator.createReturnSourceToken());
                SourceTokenOperator.addBefore(this.getOption(), stmt.getSubQuery().getStartToken(), SourceTokenOperator.createWhitespaceSourceToken(curIndetLen));
            }
            ExpressionProcessor.processParenthesesNodeInSubQuery(this.getOption(), stmt.getSubQuery(), stmt.getSubQuery().getStartToken(), stmt.getSubQuery().getEndToken());
        }
    }

    private void processValues(TMultiTargetList multiTarget) {
        if (multiTarget != null) {
            for (int i = 0; i < multiTarget.size(); ++i) {
                TMultiTarget value = multiTarget.getMultiTarget(i);
                if (value.getColumnList() != null && value.getColumnList().size() > 0) {
                    this.runProcessor(this.valueListProcessors, value.getColumnList());
                    for (int j = 0; j < value.getColumnList().size(); ++j) {
                        TResultColumn column = value.getColumnList().getResultColumn(j);
                        if (column.getExpr() == null) continue;
                        this.runProcessor(this.getExpressionProcessors(), column.getExpr());
                    }
                }
                if (value.getSubQuery() == null) continue;
                ExpressionProcessor.processParenthesesNodeInSubQuery(this.getOption(), value.getSubQuery(), value.getSubQuery().getStartToken(), value.getSubQuery().getEndToken());
            }
        }
    }
}

