/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.stmtformatter.type.comm;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TColumnDefinition;
import gudusoft.gsqlparser.nodes.TColumnDefinitionList;
import gudusoft.gsqlparser.nodes.TConstraintList;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.processor.type.comm.ExpressionProcessor;
import gudusoft.gsqlparser.pp.stmtformatter.type.AbstractStmtFormatter;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import gudusoft.gsqlparser.stmt.TCreateTableSqlStatement;
import java.util.ArrayList;
import java.util.List;

public class CreateTableStmtFormatter
extends AbstractStmtFormatter<TCreateTableSqlStatement> {
    private List<AbstractProcessor> itemListProcessors;
    private List<AbstractProcessor> constraintListProcessors;

    public void addItemListProcessor(AbstractProcessor p) {
        if (this.itemListProcessors == null) {
            this.itemListProcessors = new ArrayList<AbstractProcessor>();
        }
        this.itemListProcessors.add(p);
    }

    public void addConstraintListProcessor(AbstractProcessor p) {
        if (this.constraintListProcessors == null) {
            this.constraintListProcessors = new ArrayList<AbstractProcessor>();
        }
        this.constraintListProcessors.add(p);
    }

    @Override
    protected void doFormat(TCreateTableSqlStatement sql) {
        TConstraintList constraints;
        this.runProcessor(this.getSpecialProcessors(), sql);
        TColumnDefinitionList items = sql.getColumnList();
        if (items != null && items.size() > 0) {
            this.runProcessor(this.itemListProcessors, items);
            for (int i = 0; i < items.size(); ++i) {
                TColumnDefinition item = items.getColumn(i);
                if (item == null || item.getDatatype() == null) continue;
                ExpressionProcessor.processTypeName(this.getOption(), item.getDatatype());
            }
        }
        if ((constraints = sql.getTableConstraints()) != null && constraints.size() > 0) {
            this.runProcessor(this.constraintListProcessors, constraints);
        }
        if (sql.getSubQuery() != null) {
            ExpressionProcessor.processParenthesesNodeInSubQuery(this.getOption(), sql.getSubQuery(), sql.getSubQuery().getStartToken(), sql.getSubQuery().getEndToken());
        }
        if (sql.getGsqlparser() != null && sql.getGsqlparser().getDbVendor() == EDbVendor.dbvhive) {
            TSourceToken token = sql.getStartToken();
            int curIndetLen = SourceTokenOperator.curIndentLenVT(token);
            ArrayList<TSourceToken> tokens = new ArrayList<TSourceToken>();
            if (sql.getTableComment() != null) {
                TSourceToken commentToken = SourceTokenSearcher.backforwardSearchNotWhitespaceAndReturnToken(sql.getTableComment().getStartToken(), 5, "comment");
                tokens.add(commentToken);
            }
            if (sql.getHiveRowFormat() != null) {
                tokens.add(sql.getHiveRowFormat().getStartToken());
            }
            if (sql.getHiveTablePartition() != null) {
                tokens.add(sql.getHiveTablePartition().getStartToken());
            }
            if (sql.getHiveTableBuckets() != null) {
                tokens.add(sql.getHiveTableBuckets().getStartToken());
            }
            if (sql.getHiveTableFileFormat() != null) {
                tokens.add(sql.getHiveTableFileFormat().getStartToken());
            }
            if (sql.getHiveTableProperties() != null) {
                tokens.add(sql.getHiveTableProperties().getStartToken());
            }
            if (sql.getHiveTableSkewed() != null) {
                tokens.add(sql.getHiveTableSkewed().getStartToken());
            }
            for (int i = 0; i < tokens.size(); ++i) {
                TSourceToken currentToken = (TSourceToken)tokens.get(i);
                SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), currentToken);
                SourceTokenOperator.addBefore(this.getOption(), currentToken, SourceTokenOperator.createReturnSourceToken());
                SourceTokenOperator.addBefore(this.getOption(), currentToken, SourceTokenOperator.createWhitespaceSourceToken(curIndetLen));
            }
        }
    }
}

