/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.stmtformatter.type.comm;

import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.pp.stmtformatter.type.AbstractStmtFormatter;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;

public class CompactModeStmtFormatter
extends AbstractStmtFormatter<TCustomSqlStatement> {
    @Override
    public void format(TCustomSqlStatement stmt) {
        this.runProcessor(this.getSpecialProcessors(), stmt);
        this.compact(stmt);
    }

    private void compact(TCustomSqlStatement stmt) {
        if (stmt == null) {
            return;
        }
        TSourceToken startToken = stmt.getStartToken();
        TSourceToken endToken = stmt.getEndToken();
        if (startToken == null || endToken == null) {
            return;
        }
        int maxLineWidth = this.getOption().lineWidth;
        int currentLineWidth = 0;
        for (int i = startToken.posinlist; i <= endToken.posinlist; ++i) {
            TSourceToken t = startToken.container.get(i);
            SourceTokenOperator.addBefore(this.getOption(), t, SourceTokenOperator.createNoFormatFlagToken());
            if (t.astext == null) continue;
            if (t.tokentype == ETokenType.ttsimplecomment) {
                t.astext = "/* " + t.astext + "*/";
            }
            if (t.astext.length() >= maxLineWidth) {
                t.astext = "\n" + t.astext + "\n";
                currentLineWidth = 0;
                continue;
            }
            if ((currentLineWidth += t.astext.length()) <= maxLineWidth) continue;
            t.astext = "\n" + t.astext;
            currentLineWidth = t.astext.length();
        }
    }
}

