/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.stmtformatter.type.comm;

import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSourceTokenList;
import gudusoft.gsqlparser.TStatementList;
import gudusoft.gsqlparser.pp.mediator.MediatorFactory;
import gudusoft.gsqlparser.pp.mediator.type.SourceTokenTextTempMediator;
import gudusoft.gsqlparser.pp.para.GFmtOpt;
import gudusoft.gsqlparser.pp.para.styleenums.TCompactMode;
import gudusoft.gsqlparser.pp.para.styleenums.TEmptyLinesOption;
import gudusoft.gsqlparser.pp.stmtformatter.type.AbstractAllStmtsFormatter;
import gudusoft.gsqlparser.pp.utils.SourceTokenConstant;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import gudusoft.gsqlparser.stmt.db2.TDb2SetStmt;
import gudusoft.gsqlparser.stmt.mssql.TMssqlDeclare;
import gudusoft.gsqlparser.stmt.mssql.TMssqlGo;
import gudusoft.gsqlparser.stmt.mssql.TMssqlSet;
import gudusoft.gsqlparser.stmt.mysql.TMySQLSet;
import java.util.ArrayList;
import java.util.Arrays;

public class AllStmtsFormatter
extends AbstractAllStmtsFormatter {
    @Override
    public void doFormat(TStatementList stmts) {
        if (stmts == null || stmts.size() == 0) {
            return;
        }
        AllStmtsFormatter.processEmptyLine(stmts, this.getOption(), false);
        this.processComment(stmts);
        this.processTab(stmts);
        this.processLineNumber(stmts);
    }

    @Override
    public void beforeFormat(TStatementList stmt) {
        if (stmt == null || stmt.size() == 0) {
            return;
        }
        this.processFormatFlag(stmt);
        this.alignLine(stmt);
    }

    @Override
    public void afterFormat(TStatementList stmt) {
        if (stmt == null || stmt.size() == 0) {
            return;
        }
    }

    private void processComment(TStatementList stmts) {
        TSourceToken t;
        int i;
        Boolean removeComment = this.getOption().removeComment;
        TSourceToken startToken = stmts.get(0).getStartToken();
        if (startToken == null) {
            return;
        }
        TSourceTokenList list = startToken.container;
        SourceTokenTextTempMediator mediator = MediatorFactory.getMediator(SourceTokenTextTempMediator.class, this.getOption().sessionId);
        for (i = 0; i < list.size(); ++i) {
            t = list.get(i);
            if (t.tokentype != ETokenType.ttsimplecomment && t.tokentype != ETokenType.ttbracketedcomment) continue;
            if (t.astext != null && (t.astext.contains("--begin_no_format") || t.astext.contains("--end_no_format"))) {
                if (!t.astext.contains("--begin_no_format")) continue;
                SourceTokenOperator.addBefore(this.getOption(), t, SourceTokenOperator.createReturnSourceToken());
                continue;
            }
            boolean containReturn = this.dealReturnComment(list, mediator, i, t);
            if (t.tokentype != ETokenType.ttsimplecomment || this.getOption().compactMode == TCompactMode.Cpmugly) continue;
            boolean isOracleHint = false;
            for (int position = t.posinlist - 1; position >= 0; --position) {
                TSourceToken temp = list.get(position);
                if (temp.tokentype == ETokenType.ttwhitespace) {
                    continue;
                }
                if (!temp.astext.startsWith("/*+")) break;
                isOracleHint = true;
                break;
            }
            if (!isOracleHint) {
                int j;
                TSourceTokenList beforeList;
                boolean hasReturn;
                TSourceToken temp;
                int position;
                ArrayList<TSourceToken> tokenList = new ArrayList<TSourceToken>();
                boolean nonWhite = false;
                for (position = t.posinlist + 1; position < list.size(); ++position) {
                    temp = list.get(position);
                    if (temp.tokentype == ETokenType.ttreturn) {
                        temp.astext = "\n";
                        break;
                    }
                    hasReturn = false;
                    beforeList = temp.getTokensBefore();
                    if (beforeList != null) {
                        for (j = 0; j < beforeList.size(); ++j) {
                            if (beforeList.get((int)j).tokentype != ETokenType.ttreturn) continue;
                            hasReturn = true;
                            break;
                        }
                    }
                    if (hasReturn) break;
                    if (!nonWhite && temp.tokentype != ETokenType.ttwhitespace) {
                        nonWhite = true;
                    }
                    if (temp.getReplaceToken() == SourceTokenConstant.EMPTY) continue;
                    tokenList.add(temp);
                }
                if (!tokenList.isEmpty()) {
                    int j2;
                    if (containReturn) {
                        nonWhite = false;
                        for (position = t.posinlist; position >= 0; --position) {
                            temp = list.get(position);
                            if (temp.tokentype == ETokenType.ttreturn) break;
                            hasReturn = false;
                            beforeList = temp.getTokensBefore();
                            if (beforeList != null) {
                                for (j = 0; j < beforeList.size(); ++j) {
                                    if (beforeList.get((int)j).tokentype != ETokenType.ttreturn) continue;
                                    hasReturn = true;
                                    break;
                                }
                            }
                            if (!hasReturn) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        position = t.posinlist - 1;
                    }
                    if (position > 0) {
                        TSourceToken token = SourceTokenSearcher.lastNotWhitespaceAndReturnToken(list, 0, position);
                        position = token.posinlist;
                    }
                    if ((j2 = 0) < tokenList.size()) {
                        TSourceToken temp2 = (TSourceToken)tokenList.get(j2);
                        if (temp2.tokentype == ETokenType.ttsimplecomment || temp2.tokentype == ETokenType.ttbracketedcomment) {
                            this.dealReturnComment(list, mediator, temp2.posinlist, temp2);
                            this.removeComment(list, this.getOption(), removeComment, temp2, position + j2 + 1);
                        }
                        list.remove(temp2.posinlist);
                        for (int z = position + j2 + 1; z < temp2.posinlist; ++z) {
                            ++list.get((int)z).posinlist;
                        }
                        list.add(position + j2 + 1, temp2);
                        temp2.posinlist = position + j2 + 1;
                        ++i;
                    }
                }
            }
            this.removeComment(list, this.getOption(), removeComment, t, i);
        }
        for (i = 0; i < list.size(); ++i) {
            TSourceToken token;
            int j;
            int position;
            t = list.get(i);
            if (t.tokentype != ETokenType.ttsimplecomment || this.getOption().compactMode == TCompactMode.Cpmugly || (position = t.posinlist + 1) >= list.size()) continue;
            TSourceToken next = list.get(position);
            boolean hasReturnToken = false;
            block8: while ((next.getReplaceToken() == SourceTokenConstant.EMPTY || next.getReplaceToken() == null && next.tokentype == ETokenType.ttwhitespace) && next.posinlist < list.size() - 1) {
                next = list.get(next.posinlist + 1);
                if (next.getTokensBefore() == null) continue;
                for (j = 0; j < next.getTokensBefore().size(); ++j) {
                    token = next.getTokensBefore().get(j);
                    if (token.tokentype != ETokenType.ttreturn) continue;
                    hasReturnToken = true;
                    continue block8;
                }
            }
            if (!hasReturnToken && next.getTokensBefore() != null) {
                for (j = 0; j < next.getTokensBefore().size(); ++j) {
                    token = next.getTokensBefore().get(j);
                    if (token.tokentype != ETokenType.ttreturn) continue;
                    hasReturnToken = true;
                    break;
                }
            }
            if (hasReturnToken || next.getReplaceToken() == SourceTokenConstant.EMPTY || hasReturnToken) continue;
            if (next.getReplaceToken() != null) {
                if (next.getReplaceToken().astext.indexOf("\n") != -1) continue;
                SourceTokenOperator.addBefore(this.getOption(), next, SourceTokenOperator.createReturnSourceToken());
                continue;
            }
            if (next.astext.indexOf("\n") != -1) continue;
            int curIndent = SourceTokenOperator.curColumnNumberVT(next);
            SourceTokenOperator.addBefore(this.getOption(), next, SourceTokenOperator.createReturnSourceToken());
            SourceTokenOperator.addBefore(this.getOption(), next, SourceTokenOperator.createWhitespaceSourceToken(curIndent));
        }
    }

    private boolean dealReturnComment(TSourceTokenList list, SourceTokenTextTempMediator mediator, int i, TSourceToken t) {
        boolean containReturn = false;
        if (i > 1) {
            TSourceToken prevToken = list.get(i - 1);
            String originPrevTokenText = mediator.get(prevToken.posinlist);
            int line = AllStmtsFormatter.countLine(originPrevTokenText);
            if (line > 0) {
                TSourceTokenList beforeTokens = t.getTokensBefore();
                if (beforeTokens != null && beforeTokens.size() > 0) {
                    for (int j = 0; j < beforeTokens.size(); ++j) {
                        if (!SourceTokenSearcher.isNewLineToken(beforeTokens.get(j))) continue;
                        containReturn = true;
                        break;
                    }
                }
                if (!containReturn) {
                    SourceTokenOperator.addBefore(this.getOption(), t, SourceTokenOperator.createReturnSourceToken());
                }
            }
        }
        return containReturn;
    }

    private void removeComment(TSourceTokenList list, GFmtOpt opt, Boolean removeComment, TSourceToken t, int index) {
        if (removeComment.booleanValue()) {
            if (t.toString().startsWith("/*+")) {
                return;
            }
            t.astext = "";
            t.tokentype = ETokenType.ttwhitespace;
            if (t.getTokensBefore() != null) {
                t.getTokensBefore().clear();
            }
            SourceTokenOperator.removeWhitespaceAndReturnFromStart(opt, list, index + 1);
        }
    }

    private void processFormatFlag(TStatementList stmts) {
        if (stmts == null || stmts.size() == 0 || stmts.get(0) == null) {
            return;
        }
        TSourceToken startToken = stmts.get(0).getStartToken();
        if (startToken == null) {
            return;
        }
        TSourceTokenList list = startToken.container;
        boolean isNeedFormat = true;
        for (int i = 0; i < list.size(); ++i) {
            TSourceToken t = list.get(i);
            if ((t.tokentype == ETokenType.ttsimplecomment || t.tokentype == ETokenType.ttbracketedcomment) && t.astext != null && (t.astext.contains("--begin_no_format") || t.astext.contains("--end_no_format"))) {
                if (t.astext.contains("--begin_no_format")) {
                    SourceTokenOperator.addBefore(this.getOption(), t, SourceTokenOperator.createNoFormatFlagToken());
                    isNeedFormat = false;
                    continue;
                }
                if (!t.astext.contains("--end_no_format")) continue;
                SourceTokenOperator.addBefore(this.getOption(), t, SourceTokenOperator.createNoFormatFlagToken());
                isNeedFormat = true;
                continue;
            }
            if (isNeedFormat) continue;
            SourceTokenOperator.addBefore(this.getOption(), t, SourceTokenOperator.createNoFormatFlagToken());
        }
    }

    private void alignLine(TStatementList stmts) {
        if (stmts == null || stmts.size() == 0) {
            return;
        }
        int firstStmtIndent = SourceTokenOperator.curColumnNumberVT(stmts.get(0).getStartToken());
        for (int i = 0; i < stmts.size(); ++i) {
            TSourceToken preToken;
            TCustomSqlStatement stmt = stmts.get(i);
            TSourceToken startToken = stmt.getStartToken();
            TSourceToken endToken = stmt.getEndToken();
            if (startToken == null) continue;
            if (startToken.posinlist - 1 > 0 && SourceTokenSearcher.isNewLineToken(preToken = startToken.container.get(startToken.posinlist - 1))) {
                if (i > 0 && preToken == stmts.get(i - 1).getEndToken()) {
                    if (!(stmt instanceof TMssqlGo) && !(stmt instanceof TMssqlSet)) {
                        SourceTokenOperator.addBefore(this.getOption(), startToken, SourceTokenOperator.createReturnSourceToken());
                    }
                } else {
                    preToken.astext = AllStmtsFormatter.removeEndWhitespace(preToken.astext);
                }
            }
            SourceTokenOperator.curIndentLenVT(startToken);
        }
    }

    private static String removeEndWhitespace(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder tmp = new StringBuilder();
        for (int i = text.length() - 1; i >= 0; --i) {
            char c = text.charAt(i);
            if (c == ' ') continue;
            tmp.insert(0, c);
        }
        return tmp.toString();
    }

    public static void processEmptyLine(TStatementList stmts, GFmtOpt opt, boolean isInBlock) {
        int preEndPos = stmts.get((int)0).getEndToken().posinlist;
        TCustomSqlStatement preStmt = stmts.get(0);
        int firstStmtIndent = SourceTokenOperator.curColumnNumberVT(preStmt.getStartToken());
        SourceTokenTextTempMediator mediator = MediatorFactory.getMediator(SourceTokenTextTempMediator.class, opt.sessionId);
        for (int i = 1; i < stmts.size(); ++i) {
            TCustomSqlStatement stmt = stmts.get(i);
            TSourceToken st = stmt.getStartToken();
            TSourceToken et = stmt.getEndToken();
            TSourceToken beforeStmtComment = null;
            if (st == null || et == null || st.posinlist < 0 || st.posinlist > et.posinlist) continue;
            int sPos = st.posinlist;
            preEndPos = SourceTokenSearcher.lastNotWhitespaceAndReturnToken((TSourceTokenList)et.container, (int)preStmt.getStartToken().posinlist, (int)(preEndPos + 1)).posinlist;
            int lineCount = 0;
            for (int pos = preEndPos + 1; pos < sPos; ++pos) {
                TSourceToken curToken = st.container.get(pos);
                if (SourceTokenSearcher.isNewLineToken(curToken) || mediator.get(curToken.posinlist) != null) {
                    String text = mediator.get(curToken.posinlist);
                    if (text == null) {
                        text = curToken.astext;
                    }
                    int currentCountLine = AllStmtsFormatter.countLine(text);
                    lineCount += currentCountLine;
                    if (SourceTokenSearcher.isNewLineToken(curToken)) {
                        curToken.astext = "";
                        curToken.tokentype = ETokenType.ttwhitespace;
                    }
                }
                if (!SourceTokenSearcher.isSimpleComment(curToken) || lineCount <= 0) continue;
                if (beforeStmtComment == null) {
                    beforeStmtComment = curToken;
                }
                SourceTokenOperator.addBefore(opt, curToken, SourceTokenOperator.createReturnSourceToken());
            }
            SourceTokenOperator.addBefore(opt, st, SourceTokenOperator.createReturnSourceToken());
            if (!(stmt instanceof TMssqlGo)) {
                if (!opt.noEmptyLinesBetweenMultiSetStmts.booleanValue() && AllStmtsFormatter.isSetStmt(preStmt) && AllStmtsFormatter.isSetStmt(stmt)) {
                    SourceTokenOperator.addBefore(opt, beforeStmtComment == null ? st : beforeStmtComment, SourceTokenOperator.createReturnSourceToken());
                } else if (isInBlock && opt.insertBlankLineInBatchSqls.booleanValue()) {
                    SourceTokenOperator.addBefore(opt, beforeStmtComment == null ? st : beforeStmtComment, SourceTokenOperator.createReturnSourceToken());
                } else if (opt.emptyLines != TEmptyLinesOption.EloRemove) {
                    if (opt.emptyLines == TEmptyLinesOption.EloMergeIntoOne) {
                        if (lineCount > 1) {
                            SourceTokenOperator.addBefore(opt, beforeStmtComment == null ? st : beforeStmtComment, SourceTokenOperator.createReturnSourceToken());
                        }
                    } else if (opt.emptyLines == TEmptyLinesOption.EloPreserve) {
                        int j;
                        int n = j = beforeStmtComment == null ? 1 : 2;
                        while (j < lineCount) {
                            SourceTokenOperator.addBefore(opt, beforeStmtComment == null ? st : beforeStmtComment, SourceTokenOperator.createReturnSourceToken());
                            ++j;
                        }
                    }
                }
            }
            SourceTokenOperator.addBefore(opt, st, SourceTokenOperator.createWhitespaceSourceToken(firstStmtIndent));
            preEndPos = et.posinlist;
            if (stmt instanceof TMssqlGo) continue;
            preStmt = stmt;
        }
    }

    private static int countLine(String text) {
        if (text == null || text.length() == 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c != '\n') continue;
            ++count;
        }
        return count;
    }

    private static boolean isSetStmt(TCustomSqlStatement stmt) {
        return stmt instanceof TMssqlSet || stmt instanceof TDb2SetStmt || stmt instanceof TMySQLSet || stmt instanceof TMssqlDeclare;
    }

    private void processTab(TStatementList stmts) {
        if (!this.getOption().useTab.booleanValue()) {
            return;
        }
        for (int i = 0; i < stmts.size(); ++i) {
            TCustomSqlStatement stmt = stmts.get(i);
            TSourceToken startToken = stmt.getStartToken();
            TSourceToken endToken = stmt.getEndToken();
            if (startToken == null || endToken == null || startToken.posinlist < 0 || startToken.posinlist >= endToken.posinlist) continue;
            TSourceToken preToken = startToken;
            for (int tn = startToken.posinlist + 1; tn <= endToken.posinlist; ++tn) {
                int curIndentLen;
                int remainder;
                TSourceToken curToken = startToken.container.get(tn);
                if (this.containNewLine(preToken, curToken) && (remainder = (curIndentLen = SourceTokenOperator.curIndentLenVT(curToken)) % this.getOption().tabSize) > 0) {
                    SourceTokenOperator.addBefore(this.getOption(), curToken, SourceTokenOperator.createWhitespaceSourceToken(this.getOption().tabSize - remainder));
                }
                preToken = curToken;
            }
        }
    }

    private boolean containNewLine(TSourceToken firstToken, TSourceToken secondToken) {
        TSourceTokenList beforeSecond;
        if (SourceTokenSearcher.isNewLineToken(firstToken)) {
            return true;
        }
        TSourceTokenList afterFirst = firstToken.getTokensAfter();
        if (afterFirst.size() > 0) {
            for (int i = 0; i < afterFirst.size(); ++i) {
                if (!SourceTokenSearcher.isNewLineToken(afterFirst.get(i))) continue;
                return true;
            }
        }
        if ((beforeSecond = secondToken.getTokensBefore()).size() > 0) {
            for (int i = 0; i < beforeSecond.size(); ++i) {
                if (!SourceTokenSearcher.isNewLineToken(beforeSecond.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    private void processLineNumber(TStatementList stmts) {
        if (stmts.size() == 0) {
            return;
        }
        final GFmtOpt opt = this.getOption();
        if (!opt.linenumberEnabled.booleanValue()) {
            return;
        }
        TSourceTokenList list = stmts.get((int)0).getStartToken().container;
        SourceTokenVisitor countVisitor = new SourceTokenVisitor(){
            private Integer lineCount = 0;

            @Override
            public TSourceToken visit(TSourceToken token) {
                if (SourceTokenSearcher.isNewLineToken(token)) {
                    Integer n;
                    Integer n2;
                    if (token.astext.equals("\n\n")) {
                        n2 = this.lineCount;
                        n = this.lineCount = Integer.valueOf(this.lineCount + 1);
                    }
                    n2 = this.lineCount;
                    n = this.lineCount = Integer.valueOf(this.lineCount + 1);
                }
                return null;
            }

            @Override
            public Object getObject() {
                return this.lineCount;
            }
        };
        this.visitAllSourceTokens(list, countVisitor);
        int count = (Integer)countVisitor.getObject();
        final int lineNumbersMaxLength = String.valueOf(count).length();
        SourceTokenVisitor numberBuildVisitor = new SourceTokenVisitor(){
            private Integer lineCount;
            {
                this.lineCount = opt.linenumberZeroBased != false ? 1 : 2;
            }

            @Override
            public TSourceToken visit(TSourceToken token) {
                Integer n;
                Comparable<StringBuilder> buffer;
                if (token.tokentype == ETokenType.ttbracketedcomment || token.tokentype == ETokenType.ttsimplecomment) {
                    String[] splits = token.astext.split("\n");
                    buffer = new StringBuilder();
                    ((StringBuilder)buffer).append(splits[0]);
                    if (splits.length > 1) {
                        for (int i = 1; i < splits.length; ++i) {
                            ((StringBuilder)buffer).append("\n");
                            ((StringBuilder)buffer).append(AllStmtsFormatter.this.buildLineNumber(this.lineCount, lineNumbersMaxLength, opt.linenumberLeftMargin, opt.linenumberRightMargin));
                            n = this.lineCount;
                            Integer n2 = this.lineCount = Integer.valueOf(this.lineCount + 1);
                            ((StringBuilder)buffer).append(splits[i]);
                        }
                    }
                    token.astext = ((StringBuilder)buffer).toString();
                }
                if (SourceTokenSearcher.isNewLineToken(token)) {
                    if (token.astext.equals("\n\n")) {
                        buffer = this.lineCount;
                        Integer n3 = this.lineCount = Integer.valueOf(this.lineCount + 1);
                        String numberOne = AllStmtsFormatter.this.buildLineNumber((Integer)buffer, lineNumbersMaxLength, opt.linenumberLeftMargin, opt.linenumberRightMargin);
                        n3 = this.lineCount;
                        n = this.lineCount = Integer.valueOf(this.lineCount + 1);
                        String numberTwo = AllStmtsFormatter.this.buildLineNumber(n3, lineNumbersMaxLength, opt.linenumberLeftMargin, opt.linenumberRightMargin);
                        token.astext = "\n" + numberOne + "\n" + numberTwo;
                    } else {
                        TSourceToken t = new TSourceToken(AllStmtsFormatter.this.buildLineNumber(this.lineCount, lineNumbersMaxLength, opt.linenumberLeftMargin, opt.linenumberRightMargin));
                        Integer n4 = this.lineCount;
                        Integer n5 = this.lineCount = Integer.valueOf(this.lineCount + 1);
                        return t;
                    }
                }
                return null;
            }

            @Override
            public Object getObject() {
                return null;
            }
        };
        this.visitAllSourceTokens(list, numberBuildVisitor);
        TSourceToken firstLineNumber = new TSourceToken(this.buildLineNumber(opt.linenumberZeroBased != false ? 0 : 1, lineNumbersMaxLength, opt.linenumberLeftMargin, opt.linenumberRightMargin));
        SourceTokenOperator.addBefore(this.getOption(), list.get(0), firstLineNumber);
    }

    private String buildLineNumber(int lineCount, int lineNumberMaxLength, int leftMargin, int rightMargin) {
        char[] c;
        int appendZeroLength;
        StringBuilder buf = new StringBuilder();
        if (leftMargin > 0) {
            char[] c2 = new char[leftMargin];
            Arrays.fill(c2, ' ');
            buf.append(c2);
        }
        if ((appendZeroLength = lineNumberMaxLength - String.valueOf(lineCount).length()) > 0) {
            c = new char[appendZeroLength];
            Arrays.fill(c, '0');
            String.valueOf(c);
            buf.append(c);
        }
        buf.append(lineCount);
        if (rightMargin > 0) {
            c = new char[rightMargin];
            Arrays.fill(c, ' ');
            buf.append(c);
        }
        return buf.toString();
    }

    private void visitAllSourceTokens(TSourceTokenList list, SourceTokenVisitor visitor) {
        for (int i = 0; i < list.size(); ++i) {
            TSourceToken token = list.get(i);
            TSourceTokenList before = token.getTokensBefore();
            for (int j = 0; j < before.size(); ++j) {
                TSourceToken curToken = before.get(j);
                TSourceToken addBeforeToken = visitor.visit(curToken);
                if (addBeforeToken == null) continue;
                curToken.getTokensAfter().add(addBeforeToken);
            }
            TSourceToken addToken = visitor.visit(token);
            TSourceTokenList after = token.getTokensAfter();
            for (int j = 0; j < after.size(); ++j) {
                TSourceToken curToken = after.get(j);
                TSourceToken addAfterToken = visitor.visit(curToken);
                if (addAfterToken == null) continue;
                curToken.getTokensAfter().add(addAfterToken);
            }
            if (addToken == null) continue;
            token.getTokensAfter().add(addToken);
        }
    }

    public static interface SourceTokenVisitor {
        public Object getObject();

        public TSourceToken visit(TSourceToken var1);
    }
}

