/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.stmtformatter.type;

import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.pp.mediator.MediatorFactory;
import gudusoft.gsqlparser.pp.mediator.type.KeywordAlignMediator;
import gudusoft.gsqlparser.pp.para.GFmtOpt;
import gudusoft.gsqlparser.pp.para.GFmtOptFactory;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import java.util.ArrayList;
import java.util.List;

public class AbstractStmtFormatter<E extends TCustomSqlStatement> {
    private List<AbstractProcessor> expressionProcessors;
    private List<AbstractProcessor> specialProcessors;
    private String sessionId;

    public GFmtOpt getOption() {
        return GFmtOptFactory.newInstance(this.sessionId);
    }

    public void format(E stmt) {
        this.beforeFormat(stmt);
        this.doFormat(stmt);
        this.afterFormat(stmt);
    }

    protected void beforeFormat(E stmt) {
        KeywordAlignMediator mediator = MediatorFactory.getMediator(KeywordAlignMediator.class, this.sessionId);
        mediator.increaseLevel();
    }

    protected void doFormat(E stmt) {
    }

    protected void afterFormat(E stmt) {
        KeywordAlignMediator mediator = MediatorFactory.getMediator(KeywordAlignMediator.class, this.sessionId);
        mediator.decreaseLevel();
    }

    protected void runProcessor(List<AbstractProcessor> processors, TParseTreeNode node) {
        int i;
        if (processors == null || processors.size() == 0) {
            return;
        }
        for (i = 0; i < processors.size(); ++i) {
            processors.get(i).beforeProcess(node);
        }
        for (i = 0; i < processors.size(); ++i) {
            processors.get(i).process(node);
        }
        for (i = processors.size() - 1; i >= 0; --i) {
            processors.get(i).afterProcess(node);
        }
    }

    public void addExpressionProcessor(AbstractProcessor p) {
        if (this.expressionProcessors == null) {
            this.expressionProcessors = new ArrayList<AbstractProcessor>();
        }
        this.expressionProcessors.add(p);
    }

    public List<AbstractProcessor> getExpressionProcessors() {
        if (this.expressionProcessors == null) {
            this.expressionProcessors = new ArrayList<AbstractProcessor>();
        }
        return this.expressionProcessors;
    }

    public void addSpecialProcessor(AbstractProcessor p) {
        if (this.specialProcessors == null) {
            this.specialProcessors = new ArrayList<AbstractProcessor>();
        }
        this.specialProcessors.add(p);
    }

    public List<AbstractProcessor> getSpecialProcessors() {
        if (this.specialProcessors == null) {
            this.specialProcessors = new ArrayList<AbstractProcessor>();
        }
        return this.specialProcessors;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }
}

