/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.stmtformatter;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TGSqlParser;
import gudusoft.gsqlparser.pp.output.OutputConfigFactory;
import gudusoft.gsqlparser.pp.para.GFmtOpt;
import gudusoft.gsqlparser.pp.para.GFmtOptFactory;
import gudusoft.gsqlparser.pp.para.styleenums.TAlignStyle;
import gudusoft.gsqlparser.pp.para.styleenums.TLinefeedsCommaOption;
import gudusoft.gsqlparser.pp.print.PrinterFactory;
import gudusoft.gsqlparser.pp.print.TextPrinter;
import gudusoft.gsqlparser.pp.stmtformatter.FormatterFactory;
import java.io.ByteArrayOutputStream;

public class SqlFormatter {
    public String format(TGSqlParser parser, GFmtOpt option) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        TextPrinter printer = PrinterFactory.createTextPrinter(o);
        FormatterFactory.createAllStmtsFormatter(option).beforeFormat(parser.sqlstatements);
        for (int i = 0; i < parser.sqlstatements.size(); ++i) {
            TCustomSqlStatement sql = parser.sqlstatements.get(i);
            FormatterFactory.processStatement(option, sql);
        }
        if (parser.sqlstatements != null && parser.sqlstatements.size() > 0) {
            FormatterFactory.createAllStmtsFormatter(option).doFormat(parser.sqlstatements);
            FormatterFactory.createAllStmtsFormatter(option).afterFormat(parser.sqlstatements);
            if (FormatterFactory.getOutputConfig() == null) {
                printer.setOutputConfig(OutputConfigFactory.getOutputConfig(option, parser.getDbVendor()));
            } else {
                printer.setOutputConfig(FormatterFactory.getOutputConfig());
            }
            printer.print(parser.sqlstatements.get((int)0).getStartToken().container);
        }
        FormatterFactory.clearAllObject(option.sessionId);
        return ((Object)o).toString();
    }

    public static void main(String[] args) {
        GFmtOpt option = GFmtOptFactory.newInstance();
        option.linenumberEnabled = false;
        option.parametersStyle = TAlignStyle.AsStacked;
        option.parametersComma = TLinefeedsCommaOption.LfbeforeCommaWithSpace;
        option.beStyleFunctionRightBEOnNewline = false;
        TGSqlParser sqlparser = new TGSqlParser(EDbVendor.dbvmssql);
        sqlparser.sqlfilename = "C:\\1.txt";
        sqlparser.parse();
        String result = new SqlFormatter().format(sqlparser, option);
        System.out.println(result);
    }
}

