/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.stmtformatter;

import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TGSqlParser;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSourceTokenList;
import gudusoft.gsqlparser.TStatementList;
import gudusoft.gsqlparser.pp.mediator.MediatorFactory;
import gudusoft.gsqlparser.pp.output.OutputConfig;
import gudusoft.gsqlparser.pp.output.OutputConfigFactory;
import gudusoft.gsqlparser.pp.para.GFmtOpt;
import gudusoft.gsqlparser.pp.para.styleenums.TCompactMode;
import gudusoft.gsqlparser.pp.print.PrinterFactory;
import gudusoft.gsqlparser.pp.print.TextPrinter;
import gudusoft.gsqlparser.pp.processor.ProcessorFactory;
import gudusoft.gsqlparser.pp.stmtformatter.builder.AbstractStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.AllStmtsFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.AlterTableStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.CommonStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.CompactModeStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.CreateTableStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.CreateViewStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.DeclareStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.DeleteStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.ExecuteStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.GoStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.IfStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.InsertStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.MergeStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.PlsqlBlockStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.PlsqlIfStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.PlsqlStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.ReturnStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.SelectStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.SetStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.builder.comm.UpdateStmtFormatterBuilder;
import gudusoft.gsqlparser.pp.stmtformatter.type.AbstractStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.AllStmtsFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.AlterTableStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.CommonStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.CompactModeStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.CreateTableStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.CreateViewStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.DeclareStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.DeleteStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.ExecuteStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.GoStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.IfStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.InsertStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.MergeStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.PlsqlBlockStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.PlsqlIfStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.PlsqlStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.ReturnStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.SelectStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.SetStmtFormatter;
import gudusoft.gsqlparser.pp.stmtformatter.type.comm.UpdateStmtFormatter;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.stmt.TAlterTableStatement;
import gudusoft.gsqlparser.stmt.TCommonBlock;
import gudusoft.gsqlparser.stmt.TCreateTableSqlStatement;
import gudusoft.gsqlparser.stmt.TCreateViewSqlStatement;
import gudusoft.gsqlparser.stmt.TDeleteSqlStatement;
import gudusoft.gsqlparser.stmt.TIfStmt;
import gudusoft.gsqlparser.stmt.TInsertSqlStatement;
import gudusoft.gsqlparser.stmt.TMergeSqlStatement;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;
import gudusoft.gsqlparser.stmt.TStoredProcedureSqlStatement;
import gudusoft.gsqlparser.stmt.TUpdateSqlStatement;
import gudusoft.gsqlparser.stmt.mssql.TMssqlBlock;
import gudusoft.gsqlparser.stmt.mssql.TMssqlDeclare;
import gudusoft.gsqlparser.stmt.mssql.TMssqlExecute;
import gudusoft.gsqlparser.stmt.mssql.TMssqlGo;
import gudusoft.gsqlparser.stmt.mssql.TMssqlIfElse;
import gudusoft.gsqlparser.stmt.mssql.TMssqlReturn;
import gudusoft.gsqlparser.stmt.mssql.TMssqlSet;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FormatterFactory {
    private static volatile Map<String, AbstractStmtFormatter> formatter = new ConcurrentHashMap<String, AbstractStmtFormatter>();
    private static Object object = new Object();
    private static OutputConfig outputConfig;

    public static SelectStmtFormatter createSelectStmtFormatter(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, SelectStmtFormatter.class, new IFormatterBuilderCreator<SelectStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<SelectStmtFormatter> create() {
                return new SelectStmtFormatterBuilder();
            }
        });
    }

    public static InsertStmtFormatter createInsertStmtFormatter(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, InsertStmtFormatter.class, new IFormatterBuilderCreator<InsertStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<InsertStmtFormatter> create() {
                return new InsertStmtFormatterBuilder();
            }
        });
    }

    public static DeleteStmtFormatter createDeleteStmtFormatter(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, DeleteStmtFormatter.class, new IFormatterBuilderCreator<DeleteStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<DeleteStmtFormatter> create() {
                return new DeleteStmtFormatterBuilder();
            }
        });
    }

    public static UpdateStmtFormatter createUpdateStmtFormatter(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, UpdateStmtFormatter.class, new IFormatterBuilderCreator<UpdateStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<UpdateStmtFormatter> create() {
                return new UpdateStmtFormatterBuilder();
            }
        });
    }

    public static CreateTableStmtFormatter createCreateTableStmtFormatter(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, CreateTableStmtFormatter.class, new IFormatterBuilderCreator<CreateTableStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<CreateTableStmtFormatter> create() {
                return new CreateTableStmtFormatterBuilder();
            }
        });
    }

    public static DeclareStmtFormatter createDeclareStmtFormatter(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, DeclareStmtFormatter.class, new IFormatterBuilderCreator<DeclareStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<DeclareStmtFormatter> create() {
                return new DeclareStmtFormatterBuilder();
            }
        });
    }

    public static ExecuteStmtFormatter createExecuteStmtFormatter(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, ExecuteStmtFormatter.class, new IFormatterBuilderCreator<ExecuteStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<ExecuteStmtFormatter> create() {
                return new ExecuteStmtFormatterBuilder();
            }
        });
    }

    public static SetStmtFormatter createSetStmtFormatter(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, SetStmtFormatter.class, new IFormatterBuilderCreator<SetStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<SetStmtFormatter> create() {
                return new SetStmtFormatterBuilder();
            }
        });
    }

    public static IfStmtFormatter createIfStmtFormatter(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, IfStmtFormatter.class, new IFormatterBuilderCreator<IfStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<IfStmtFormatter> create() {
                return new IfStmtFormatterBuilder();
            }
        });
    }

    public static PlsqlIfStmtFormatter createPlsqlIfStmtFormatter(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, PlsqlIfStmtFormatter.class, new IFormatterBuilderCreator<PlsqlIfStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<PlsqlIfStmtFormatter> create() {
                return new PlsqlIfStmtFormatterBuilder();
            }
        });
    }

    public static PlsqlStmtFormatter createPlsqlStmtFormatter(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, PlsqlStmtFormatter.class, new IFormatterBuilderCreator<PlsqlStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<PlsqlStmtFormatter> create() {
                return new PlsqlStmtFormatterBuilder();
            }
        });
    }

    public static GoStmtFormatter createGoStmtFormatter(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, GoStmtFormatter.class, new IFormatterBuilderCreator<GoStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<GoStmtFormatter> create() {
                return new GoStmtFormatterBuilder();
            }
        });
    }

    public static CompactModeStmtFormatter createCompactModeStmtFormatter(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, CompactModeStmtFormatter.class, new IFormatterBuilderCreator<CompactModeStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<CompactModeStmtFormatter> create() {
                return new CompactModeStmtFormatterBuilder();
            }
        });
    }

    public static ReturnStmtFormatter createReturnStmtFormatter(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, ReturnStmtFormatter.class, new IFormatterBuilderCreator<ReturnStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<ReturnStmtFormatter> create() {
                return new ReturnStmtFormatterBuilder();
            }
        });
    }

    public static CreateViewStmtFormatter createCreateViewStmtFormatter(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, CreateViewStmtFormatter.class, new IFormatterBuilderCreator<CreateViewStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<CreateViewStmtFormatter> create() {
                return new CreateViewStmtFormatterBuilder();
            }
        });
    }

    public static AlterTableStmtFormatter createAlterTableStatement(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, AlterTableStmtFormatter.class, new IFormatterBuilderCreator<AlterTableStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<AlterTableStmtFormatter> create() {
                return new AlterTableStmtFormatterBuilder();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <E extends AbstractStmtFormatter> E createFormatter(GFmtOpt opt, Class<E> clazz, IFormatterBuilderCreator<E> creater) {
        String id = opt.sessionId + clazz.getName();
        if (formatter.containsKey(id)) return (E)formatter.get(id);
        Class<FormatterFactory> clazz2 = FormatterFactory.class;
        synchronized (FormatterFactory.class) {
            if (formatter.containsKey(id)) return (E)formatter.get(id);
            AbstractStmtFormatterBuilder<E> builder = creater.create();
            builder.setOption(opt);
            formatter.put(id, (AbstractStmtFormatter)builder.build());
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return (E)formatter.get(id);
        }
    }

    public static void processStatement(GFmtOpt option, TCustomSqlStatement sql) {
        if (option.compactMode == TCompactMode.Cpmugly) {
            FormatterFactory.createCompactModeStmtFormatter(option).format(sql);
            return;
        }
        if (FormatterFactory.isNotNeedFormat(sql)) {
            return;
        }
        if (sql instanceof TSelectSqlStatement) {
            FormatterFactory.createSelectStmtFormatter(option).format((TSelectSqlStatement)sql);
        } else if (sql instanceof TInsertSqlStatement) {
            FormatterFactory.createInsertStmtFormatter(option).format((TInsertSqlStatement)sql);
        } else if (sql instanceof TDeleteSqlStatement) {
            FormatterFactory.createDeleteStmtFormatter(option).format((TDeleteSqlStatement)sql);
        } else if (sql instanceof TUpdateSqlStatement) {
            FormatterFactory.createUpdateStmtFormatter(option).format((TUpdateSqlStatement)sql);
        } else if (sql instanceof TCreateTableSqlStatement) {
            FormatterFactory.createCreateTableStmtFormatter(option).format((TCreateTableSqlStatement)sql);
        } else if (sql instanceof TMssqlDeclare) {
            FormatterFactory.createDeclareStmtFormatter(option).format((TMssqlDeclare)sql);
        } else if (sql instanceof TMssqlExecute) {
            FormatterFactory.createExecuteStmtFormatter(option).format((TMssqlExecute)sql);
        } else if (sql instanceof TStoredProcedureSqlStatement) {
            FormatterFactory.createPlsqlStmtFormatter(option).format((TStoredProcedureSqlStatement)sql);
        } else if (sql instanceof TMssqlSet) {
            FormatterFactory.createSetStmtFormatter(option).format((TMssqlSet)sql);
        } else if (sql instanceof TMssqlIfElse) {
            FormatterFactory.createIfStmtFormatter(option).format((TMssqlIfElse)sql);
        } else if (sql instanceof TMssqlGo) {
            FormatterFactory.createGoStmtFormatter(option).format((TMssqlGo)sql);
        } else if (sql instanceof TMssqlReturn) {
            FormatterFactory.createReturnStmtFormatter(option).format((TMssqlReturn)sql);
        } else if (sql instanceof TCreateViewSqlStatement) {
            FormatterFactory.createCreateViewStmtFormatter(option).format((TCreateViewSqlStatement)sql);
        } else if (sql instanceof TAlterTableStatement) {
            FormatterFactory.createAlterTableStatement(option).format((TAlterTableStatement)sql);
        } else if (sql instanceof TMergeSqlStatement) {
            FormatterFactory.createMergeSqlStatement(option).format((TMergeSqlStatement)sql);
        } else if (sql instanceof TIfStmt) {
            FormatterFactory.createPlsqlIfStmtFormatter(option).format((TIfStmt)sql);
        } else {
            FormatterFactory.createCommonStatement(option).format(sql);
        }
    }

    private static AbstractStmtFormatter<TCommonBlock> createPlsqlBlockStmtFormatter(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, PlsqlBlockStmtFormatter.class, new IFormatterBuilderCreator<PlsqlBlockStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<PlsqlBlockStmtFormatter> create() {
                return new PlsqlBlockStmtFormatterBuilder();
            }
        });
    }

    private static MergeStmtFormatter createMergeSqlStatement(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, MergeStmtFormatter.class, new IFormatterBuilderCreator<MergeStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<MergeStmtFormatter> create() {
                return new MergeStmtFormatterBuilder();
            }
        });
    }

    private static CommonStmtFormatter createCommonStatement(GFmtOpt opt) {
        return FormatterFactory.createFormatter(opt, CommonStmtFormatter.class, new IFormatterBuilderCreator<CommonStmtFormatter>(){

            @Override
            public AbstractStmtFormatterBuilder<CommonStmtFormatter> create() {
                return new CommonStmtFormatterBuilder();
            }
        });
    }

    public static boolean isNotNeedFormat(TCustomSqlStatement sql) {
        if (sql == null) {
            return true;
        }
        if (sql.getStartToken() != null) {
            TSourceToken t = sql.getStartToken();
            return FormatterFactory.isNotNeedFormat(t);
        }
        return false;
    }

    public static boolean isNotNeedFormat(TSourceToken t) {
        if (t == null) {
            return false;
        }
        TSourceTokenList bts = t.getTokensBefore();
        if (bts.size() > 0) {
            for (int i = 0; i < bts.size(); ++i) {
                if (!SourceTokenOperator.createNoFormatFlagToken().equals(bts.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static void processBlockStmt(GFmtOpt opt, TMssqlBlock stmt, TSourceToken ifToken) {
        TCustomSqlStatement bstmt;
        TSourceToken startToken = stmt.getStartToken();
        TSourceToken endToken = stmt.getEndToken();
        if (startToken == null || endToken == null) {
            return;
        }
        int curBeginIndent = SourceTokenOperator.curColumnNumberVT(ifToken);
        if (opt.beStyleBlockLeftBEOnNewline.booleanValue()) {
            SourceTokenOperator.addBefore(opt, startToken, SourceTokenOperator.createReturnSourceToken());
            SourceTokenOperator.addBefore(opt, startToken, SourceTokenOperator.createWhitespaceSourceToken(curBeginIndent += opt.beStyleBlockLeftBEIndentSize.intValue()));
        }
        int curEndIndent = SourceTokenOperator.curColumnNumberVT(ifToken) + (opt.beStyleBlockLeftBEOnNewline != false ? opt.beStyleBlockLeftBEIndentSize : opt.beStyleBlockRightBEIndentSize);
        SourceTokenOperator.addBefore(opt, endToken, SourceTokenOperator.createReturnSourceToken());
        SourceTokenOperator.addBefore(opt, endToken, SourceTokenOperator.createWhitespaceSourceToken(curEndIndent));
        TStatementList list = stmt.getBodyStatements();
        if (list != null && list.size() > 0) {
            int curBlockIndent = curEndIndent + opt.beStyleBlockIndentSize;
            bstmt = list.get(0);
            TSourceToken bstartToken = bstmt.getStartToken();
            if (bstartToken != null) {
                SourceTokenOperator.addBefore(opt, bstartToken, SourceTokenOperator.createReturnSourceToken());
                SourceTokenOperator.addBefore(opt, bstartToken, SourceTokenOperator.createWhitespaceSourceToken(curBlockIndent));
            }
        }
        AllStmtsFormatter.processEmptyLine(list, opt, true);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                bstmt = list.get(i);
                FormatterFactory.processStatement(opt, bstmt);
            }
        }
    }

    public static String pp(TGSqlParser parser, GFmtOpt option) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        TextPrinter printer = PrinterFactory.createTextPrinter(o);
        FormatterFactory.createAllStmtsFormatter(option).beforeFormat(parser.sqlstatements);
        for (int i = 0; i < parser.sqlstatements.size(); ++i) {
            TCustomSqlStatement sql = parser.sqlstatements.get(i);
            FormatterFactory.processStatement(option, sql);
        }
        if (parser.sqlstatements != null && parser.sqlstatements.size() > 0) {
            FormatterFactory.createAllStmtsFormatter(option).doFormat(parser.sqlstatements);
            FormatterFactory.createAllStmtsFormatter(option).afterFormat(parser.sqlstatements);
            if (outputConfig == null) {
                outputConfig = OutputConfigFactory.getOutputConfig(option, parser.getDbVendor());
            }
            printer.setOutputConfig(outputConfig);
            printer.print(parser.sqlstatements.get((int)0).getStartToken().container);
        }
        FormatterFactory.clearAllObject(option.sessionId);
        return ((Object)o).toString();
    }

    public static OutputConfig getOutputConfig() {
        return outputConfig;
    }

    public static void setOutputConfig(OutputConfig outputConfig) {
        FormatterFactory.outputConfig = outputConfig;
    }

    public static AllStmtsFormatter createAllStmtsFormatter(GFmtOpt option) {
        return AllStmtsFormatterBuilder.create(option);
    }

    public static void clearAllObject(String sessionId) {
        FormatterFactory.clear(sessionId);
        ProcessorFactory.clear(sessionId);
        MediatorFactory.clear(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear(String sessionId) {
        Object object = FormatterFactory.object;
        synchronized (object) {
            ArrayList<String> removedKeys = new ArrayList<String>();
            for (String key : formatter.keySet()) {
                if (!key.startsWith(sessionId)) continue;
                removedKeys.add(key);
            }
            for (String key : removedKeys) {
                formatter.remove(key);
            }
        }
    }

    public static interface IFormatterBuilderCreator<E extends AbstractStmtFormatter> {
        public AbstractStmtFormatterBuilder<E> create();
    }
}

