/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.select;

import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.pp.mediator.MediatorFactory;
import gudusoft.gsqlparser.pp.mediator.type.KeywordAlignMediator;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;

public class UnionProcessor
extends AbstractProcessor<TSelectSqlStatement> {
    @Override
    public void process(TSelectSqlStatement sql) {
        TSourceToken unionToken;
        if (sql.getRightStmt() != null && sql.getLeftStmt() != null && (unionToken = SourceTokenSearcher.backforwardSearch(sql.getRightStmt().getStartToken(), 10, "union")) != null) {
            TSourceToken selectToken = null;
            for (TSelectSqlStatement tmpsql = sql; tmpsql != null && selectToken == null; tmpsql = tmpsql.getLeftStmt()) {
                selectToken = tmpsql.getSelectToken();
            }
            if (selectToken == null) {
                return;
            }
            int curIndent = SourceTokenOperator.curColumnNumberVT(selectToken);
            KeywordAlignMediator mediator = MediatorFactory.getMediator(KeywordAlignMediator.class, this.getOption().sessionId);
            if (mediator.getLevelIndentLen(mediator.getCurrentIndentLevel() + 1) > curIndent) {
                curIndent = mediator.getLevelIndentLen(mediator.getCurrentIndentLevel() + 1);
            }
            mediator.addIndentLevelItem(unionToken, curIndent);
            SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), unionToken);
            SourceTokenOperator.addBefore(this.getOption(), unionToken, SourceTokenOperator.createReturnSourceToken());
            SourceTokenOperator.addBefore(this.getOption(), unionToken, SourceTokenOperator.createWhitespaceSourceToken(curIndent));
            SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), sql.getRightStmt().getStartToken());
            SourceTokenOperator.addBefore(this.getOption(), sql.getRightStmt().getStartToken(), SourceTokenOperator.createReturnSourceToken());
            SourceTokenOperator.addBefore(this.getOption(), sql.getRightStmt().getStartToken(), SourceTokenOperator.createWhitespaceSourceToken(curIndent));
        }
    }
}

