/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.select;

import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TJoin;
import gudusoft.gsqlparser.nodes.TJoinItem;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractKeyWordAlignProcessor;
import gudusoft.gsqlparser.pp.processor.type.select.JoinOnProcessor;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;
import java.util.ArrayList;
import java.util.List;

public class SelectKeyWordAlignProcessor
extends AbstractKeyWordAlignProcessor<TSelectSqlStatement> {
    @Override
    protected List<TSourceToken[]> getTSourceToken(TSelectSqlStatement node) {
        TSourceToken byToken;
        ArrayList<TSourceToken[]> tokens = new ArrayList<TSourceToken[]>();
        TSourceToken selectToken = node.getSelectToken();
        if (selectToken != null) {
            tokens.add(new TSourceToken[]{selectToken});
        }
        if (node.getIntoClause() != null) {
            TSourceToken insertToken = node.getIntoClause().getStartToken();
            tokens.add(new TSourceToken[]{insertToken});
        }
        if (node.joins.size() > 0) {
            TSourceToken fromToken = SourceTokenSearcher.backforwardSearch(node.joins.getStartToken(), 5, "from");
            if (fromToken == null && node.tables != null) {
                fromToken = SourceTokenSearcher.backforwardSearch(node.joins.getStartToken(), 5, "from");
            }
            if (fromToken != null) {
                tokens.add(new TSourceToken[]{fromToken});
            }
        }
        if (node.getGroupByClause() != null) {
            TSourceToken havingToken;
            TSourceToken groupToken = node.getGroupByClause().getGROUP();
            byToken = node.getGroupByClause().getBY();
            if (groupToken != null && byToken != null) {
                tokens.add(new TSourceToken[]{groupToken, byToken});
            }
            if ((havingToken = node.getGroupByClause().getHAVING()) != null) {
                tokens.add(new TSourceToken[]{havingToken});
            }
        }
        if (node.getOrderbyClause() != null) {
            TSourceToken orderToken = node.getOrderbyClause().getStartToken();
            byToken = SourceTokenSearcher.forwardSearch(node.getOrderbyClause().getStartToken(), 5, "by");
            tokens.add(new TSourceToken[]{orderToken, byToken});
        }
        if (node.getWhereClause() != null) {
            TSourceToken whereToken = node.getWhereClause().getStartToken();
            tokens.add(new TSourceToken[]{whereToken});
        }
        if (node.joins != null && this.getOption().alignJoinWithFromKeyword) {
            for (int i = 0; i < node.joins.size(); ++i) {
                TJoin join = node.joins.getJoin(i);
                for (int j = 0; j < join.getJoinItems().size(); ++j) {
                    TJoinItem lcitem = join.getJoinItems().getJoinItem(j);
                    if (lcitem == null) continue;
                    TSourceToken startToken = JoinOnProcessor.getBeginJoinToken(lcitem);
                    if (startToken.astext.trim().equalsIgnoreCase("join")) {
                        tokens.add(new TSourceToken[]{startToken});
                        continue;
                    }
                    TSourceToken endToken = SourceTokenSearcher.forwardSearch(startToken, 5, "join");
                    tokens.add(new TSourceToken[]{startToken, endToken});
                }
            }
        }
        return tokens;
    }
}

