/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.select;

import gudusoft.gsqlparser.EJoinType;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TJoin;
import gudusoft.gsqlparser.nodes.TJoinItem;
import gudusoft.gsqlparser.nodes.TJoinList;
import gudusoft.gsqlparser.nodes.TTableList;
import gudusoft.gsqlparser.pp.mediator.MediatorFactory;
import gudusoft.gsqlparser.pp.mediator.type.KeywordAlignMediator;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.processor.type.comm.ExpressionProcessor;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;

public class JoinOnProcessor
extends AbstractProcessor<TSelectSqlStatement> {
    @Override
    public void process(TSelectSqlStatement node) {
        boolean selectFromclauseJoinOnInNewline = this.getParameter(Boolean.class);
        boolean alignJoinWithFromKeyword = this.getParameter(Boolean.class, 1);
        TSelectSqlStatement sql = node;
        TTableList tables = sql.tables;
        TJoinList joins = sql.joins;
        if (tables.size() == 0) {
            return;
        }
        int joinAndOnIndentLen = SourceTokenOperator.curColumnNumberVT(tables.getElement(0).getStartToken());
        for (int i = 0; i < joins.size(); ++i) {
            TJoin join = joins.getJoin(i);
            for (int j = 0; j < join.getJoinItems().size(); ++j) {
                TSourceToken onToken;
                TJoinItem lcitem = join.getJoinItems().getJoinItem(j);
                if (lcitem == null) continue;
                TSourceToken joinTableToken = lcitem.getStartToken();
                SourceTokenOperator.removeAllBeforeTokenVT(this.getOption(), joinTableToken);
                TSourceToken beginJoinToken = JoinOnProcessor.getBeginJoinToken(lcitem);
                if (beginJoinToken != null) {
                    SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), beginJoinToken);
                    SourceTokenOperator.addBefore(this.getOption(), beginJoinToken, SourceTokenOperator.createReturnSourceToken());
                    if (alignJoinWithFromKeyword) {
                        KeywordAlignMediator mediator = MediatorFactory.getMediator(KeywordAlignMediator.class, this.getOption().sessionId);
                        SourceTokenOperator.addBefore(this.getOption(), beginJoinToken, SourceTokenOperator.createWhitespaceSourceToken(mediator.getCurLevelIndentLen()));
                    } else {
                        SourceTokenOperator.addBefore(this.getOption(), beginJoinToken, SourceTokenOperator.createWhitespaceSourceToken(joinAndOnIndentLen));
                    }
                }
                if (lcitem.getTable() != null && lcitem.getTable().subquery != null) {
                    ExpressionProcessor.processParenthesesNodeInSubQuery(this.getOption(), lcitem.getTable().subquery, lcitem.getTable().subquery.getStartToken(), lcitem.getTable().subquery.getEndToken());
                }
                if (lcitem.getOnCondition() == null || (onToken = SourceTokenSearcher.lastSelectedNotWhitespaceAndReturnToken(lcitem.getOnCondition().getStartToken(), "on")) == null || !selectFromclauseJoinOnInNewline) continue;
                SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), onToken);
                SourceTokenOperator.addBefore(this.getOption(), onToken, SourceTokenOperator.createReturnSourceToken());
                SourceTokenOperator.addBefore(this.getOption(), onToken, SourceTokenOperator.createWhitespaceSourceToken(joinAndOnIndentLen));
            }
            if (join.getTable() == null || join.getTable().getSubquery() == null) continue;
            ExpressionProcessor.processParenthesesNodeInSubQuery(this.getOption(), join.getTable().getSubquery(), join.getTable().getSubquery().getStartToken(), join.getTable().getSubquery().getEndToken());
        }
    }

    public static TSourceToken getBeginJoinToken(TJoinItem lcitem) {
        TSourceToken joinTableToken = lcitem.getStartToken();
        TSourceToken beginJoinToken = null;
        if (lcitem.getJoinType() == EJoinType.cross || lcitem.getJoinType() == EJoinType.crossapply) {
            beginJoinToken = SourceTokenSearcher.backforwardSearch(joinTableToken, 5, "cross");
        } else if (lcitem.getJoinType() == EJoinType.full || lcitem.getJoinType() == EJoinType.fullouter) {
            beginJoinToken = SourceTokenSearcher.backforwardSearch(joinTableToken, 10, "full");
        } else if (lcitem.getJoinType() == EJoinType.inner) {
            beginJoinToken = SourceTokenSearcher.backforwardSearch(joinTableToken, 5, "inner");
            if (beginJoinToken == null) {
                beginJoinToken = SourceTokenSearcher.backforwardSearch(joinTableToken, 5, "join");
            }
        } else if (lcitem.getJoinType() == EJoinType.left || lcitem.getJoinType() == EJoinType.leftouter) {
            beginJoinToken = SourceTokenSearcher.backforwardSearch(joinTableToken, 10, "left");
        } else if (lcitem.getJoinType() == EJoinType.natural) {
            beginJoinToken = SourceTokenSearcher.backforwardSearch(joinTableToken, 5, "natural");
        } else if (lcitem.getJoinType() == EJoinType.nested) {
            beginJoinToken = SourceTokenSearcher.backforwardSearch(joinTableToken, 5, "nested");
        } else if (lcitem.getJoinType() == EJoinType.right || lcitem.getJoinType() == EJoinType.rightouter) {
            beginJoinToken = SourceTokenSearcher.backforwardSearch(joinTableToken, 10, "right");
        } else if (lcitem.getJoinType() == EJoinType.outerapply) {
            beginJoinToken = SourceTokenSearcher.backforwardSearch(joinTableToken, 5, "outer");
        } else if (lcitem.getJoinType() == EJoinType.join) {
            beginJoinToken = SourceTokenSearcher.backforwardSearch(joinTableToken, 5, "join");
        }
        return beginJoinToken;
    }
}

