/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.select;

import gudusoft.gsqlparser.ESetOperatorType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TCTE;
import gudusoft.gsqlparser.pp.mediator.MediatorFactory;
import gudusoft.gsqlparser.pp.mediator.type.KeywordAlignMediator;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.processor.type.comm.ExpressionProcessor;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import gudusoft.gsqlparser.stmt.TInsertSqlStatement;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;

public class CTEProcessor
extends AbstractProcessor<TCustomSqlStatement> {
    @Override
    public void process(TCustomSqlStatement node) {
        if (node.getCteList() == null || node.getCteList().size() == 0) {
            return;
        }
        boolean cteNewlineBeforeAs = this.getParameter(Boolean.class);
        KeywordAlignMediator mediator = MediatorFactory.newInstance(KeywordAlignMediator.class);
        TSourceToken withToken = SourceTokenSearcher.backforwardSearch(node.getCteList().getStartToken(), 5, "with");
        SourceTokenOperator.removeWhitespaceAndReturnFromStart(this.getOption(), withToken.container, withToken.posinlist + 1);
        SourceTokenOperator.addBefore(this.getOption(), withToken, SourceTokenOperator.createWhitespaceSourceToken(mediator.getCurLevelIndentLen()));
        SourceTokenOperator.addAfter(this.getOption(), withToken, SourceTokenOperator.createWhitespaceSourceToken(1));
        for (int i = 0; i < node.getCteList().size(); ++i) {
            TCTE cte = node.getCteList().getCTE(i);
            TSourceToken asToken = SourceTokenSearcher.backforwardSearch(cte.getPreparableStmt().getStartToken(), 10, "as");
            SourceTokenOperator.removeWhitespaceAndReturnFormBeforeAndAfter(this.getOption(), asToken);
            if (cteNewlineBeforeAs) {
                SourceTokenOperator.addBefore(this.getOption(), asToken, SourceTokenOperator.createReturnSourceToken());
                SourceTokenOperator.addBefore(this.getOption(), asToken, SourceTokenOperator.createWhitespaceSourceToken(SourceTokenOperator.curColumnNumberVT(withToken) + "with".length() + 1));
            } else {
                SourceTokenOperator.addBefore(this.getOption(), asToken, SourceTokenOperator.createWhitespaceSourceToken(1));
            }
            SourceTokenOperator.addAfter(this.getOption(), asToken, SourceTokenOperator.createWhitespaceSourceToken(1));
            ExpressionProcessor.processParenthesesNodeInSubQuery(this.getOption(), cte.getPreparableStmt(), cte.getPreparableStmt().getStartToken(), cte.getPreparableStmt().getEndToken());
        }
        TSourceToken keyToken = null;
        if (node instanceof TSelectSqlStatement) {
            keyToken = this.getFirstSelectStmt((TSelectSqlStatement)node).getSelectToken();
        } else if (node instanceof TInsertSqlStatement) {
            keyToken = ((TInsertSqlStatement)node).getInsertToken();
        } else {
            return;
        }
        SourceTokenOperator.addBefore(this.getOption(), keyToken, SourceTokenOperator.createReturnSourceToken());
        SourceTokenOperator.addBefore(this.getOption(), keyToken, SourceTokenOperator.createWhitespaceSourceToken(SourceTokenOperator.curColumnNumberVT(withToken) + this.getOption().indentLen));
    }

    private TSelectSqlStatement getFirstSelectStmt(TSelectSqlStatement select) {
        if (select.getSetOperatorType() == ESetOperatorType.none) {
            return select;
        }
        return this.getFirstSelectStmt(select.getLeftStmt());
    }
}

