/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.rtn;

import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TStatementList;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.processor.type.comm.ExpressionProcessor;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;
import gudusoft.gsqlparser.stmt.mssql.TMssqlReturn;

public class ReturnStmtProcessor
extends AbstractProcessor<TMssqlReturn> {
    @Override
    public void process(TMssqlReturn node) {
        TStatementList stmts;
        TSourceToken startToken = node.getStartToken();
        if (startToken == null) {
            return;
        }
        int returnIndent = SourceTokenOperator.curColumnNumberVT(startToken);
        int curIndent = returnIndent + this.getOption().beStyleBlockIndentSize;
        if (node.getSubquery() != null) {
            TSourceToken bstartToken = node.getSubquery().getStartToken();
            if (bstartToken == null) {
                return;
            }
            SourceTokenOperator.addBefore(this.getOption(), bstartToken, SourceTokenOperator.createReturnSourceToken());
            SourceTokenOperator.addBefore(this.getOption(), bstartToken, SourceTokenOperator.createWhitespaceSourceToken(curIndent));
            ExpressionProcessor.processParenthesesNodeInSubQuery(this.getOption(), node.getSubquery(), node.getSubquery().getStartToken(), node.getSubquery().getEndToken());
        } else if (node.getStatements() != null && node.getStatements().size() > 0 && (stmts = node.getStatements()).get(0) instanceof TSelectSqlStatement) {
            TSelectSqlStatement subquery = (TSelectSqlStatement)stmts.get(0);
            TSourceToken lb = subquery.getStartToken();
            TSourceToken rb = subquery.getEndToken();
            if (lb != null && lb.astext.equals("(") && rb != null && rb.astext.equals(")")) {
                SourceTokenOperator.addBefore(this.getOption(), lb, SourceTokenOperator.createReturnSourceToken());
                SourceTokenOperator.addBefore(this.getOption(), lb, SourceTokenOperator.createWhitespaceSourceToken(returnIndent));
                SourceTokenOperator.addAfter(this.getOption(), lb, SourceTokenOperator.createReturnSourceToken());
                SourceTokenOperator.addAfter(this.getOption(), lb, SourceTokenOperator.createWhitespaceSourceToken(curIndent));
                SourceTokenOperator.addBefore(this.getOption(), rb, SourceTokenOperator.createReturnSourceToken());
                SourceTokenOperator.addBefore(this.getOption(), rb, SourceTokenOperator.createWhitespaceSourceToken(returnIndent));
            }
            ExpressionProcessor.processParenthesesNodeInSubQuery(this.getOption(), subquery, subquery.getStartToken(), subquery.getEndToken());
        }
    }
}

