/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.plsql;

import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TStatementList;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import gudusoft.gsqlparser.stmt.TElsifStmt;
import gudusoft.gsqlparser.stmt.TIfStmt;

public class PlsqlIfStmtBEProcessor
extends AbstractProcessor<TIfStmt> {
    @Override
    public void process(TIfStmt stmt) {
        TStatementList elseStmts;
        TStatementList thenStmts;
        TSourceToken ifToken = stmt.getStartToken();
        if (ifToken == null) {
            return;
        }
        TStatementList elseIfStmts = stmt.getElseifStatements();
        if (elseIfStmts != null && elseIfStmts.size() > 0) {
            for (int i = 0; i < elseIfStmts.size(); ++i) {
                TElsifStmt elseIfStmt = (TElsifStmt)elseIfStmts.get(i);
                TSourceToken elsIfToken = elseIfStmt.getStartToken();
                TSourceToken elsIfStmtStartToken = SourceTokenSearcher.firstNotWhitespaceAndReturnToken(elsIfToken.container, elsIfToken.posinlist + 1, elseIfStmt.getEndToken().posinlist);
                if (elsIfStmtStartToken == null) continue;
                this.wrapStatement(ifToken, elsIfToken, elsIfStmtStartToken, false);
                TStatementList thenStmts2 = elseIfStmt.getThenStatements();
                if (thenStmts2 == null || thenStmts2.size() <= 0) continue;
                for (int j = 0; j < thenStmts2.size(); ++j) {
                    TCustomSqlStatement thenStmt = thenStmts2.get(j);
                    TSourceToken thenStmtStartToken = thenStmt.getStartToken();
                    TSourceToken thenToken = SourceTokenSearcher.backforwardSearch(thenStmt.getStartToken(), 5, "then");
                    if (thenStmtStartToken == null) continue;
                    this.wrapStatement(ifToken, thenToken, thenStmtStartToken, true);
                }
            }
        }
        if ((thenStmts = stmt.getThenStatements()) != null && thenStmts.size() > 0) {
            for (int j = 0; j < thenStmts.size(); ++j) {
                TCustomSqlStatement thenStmt = thenStmts.get(j);
                TSourceToken thenStmtStartToken = thenStmt.getStartToken();
                TSourceToken thenToken = SourceTokenSearcher.backforwardSearch(thenStmt.getStartToken(), 5, "then");
                if (thenStmtStartToken == null) continue;
                this.wrapStatement(ifToken, thenToken, thenStmtStartToken, true);
            }
        }
        if ((elseStmts = stmt.getElseStatements()) != null && elseStmts.size() > 0) {
            for (int i = 0; i < elseStmts.size(); ++i) {
                TSourceToken elseToken;
                TCustomSqlStatement elseStmt = elseStmts.get(i);
                TSourceToken elseStmtStartToken = elseStmt.getStartToken();
                if (elseStmtStartToken == null || (elseToken = SourceTokenSearcher.backforwardSearch(elseStmt.getStartToken(), 5, "else")) == null) continue;
                this.wrapStatement(ifToken, elseToken, elseStmtStartToken);
            }
        }
        TSourceToken endToken = SourceTokenSearcher.backforwardSearch(stmt.getEndToken(), 5, "end");
        int curElseIndent = SourceTokenOperator.curColumnNumberVT(ifToken);
        SourceTokenOperator.addBefore(this.getOption(), endToken, SourceTokenOperator.createReturnSourceToken());
        SourceTokenOperator.addBefore(this.getOption(), endToken, SourceTokenOperator.createWhitespaceSourceToken(curElseIndent));
    }

    private void wrapStatement(TSourceToken ifToken, TSourceToken keywordToken, TSourceToken startToken) {
        int curElseIndent = SourceTokenOperator.curColumnNumberVT(ifToken);
        SourceTokenOperator.addBefore(this.getOption(), keywordToken, SourceTokenOperator.createReturnSourceToken());
        SourceTokenOperator.addBefore(this.getOption(), keywordToken, SourceTokenOperator.createWhitespaceSourceToken(curElseIndent));
        int curElsIfStmtIndent = curElseIndent + this.getOption().beStyleIfElseSingleStmtIndentSize;
        SourceTokenOperator.addBefore(this.getOption(), startToken, SourceTokenOperator.createReturnSourceToken());
        SourceTokenOperator.addBefore(this.getOption(), startToken, SourceTokenOperator.createWhitespaceSourceToken(curElsIfStmtIndent));
    }

    private void wrapStatement(TSourceToken ifToken, TSourceToken keywordToken, TSourceToken startToken, boolean wrapStartToken) {
        int curElseIndent = SourceTokenOperator.curColumnNumberVT(ifToken);
        if (!wrapStartToken) {
            SourceTokenOperator.addBefore(this.getOption(), keywordToken, SourceTokenOperator.createReturnSourceToken());
            SourceTokenOperator.addBefore(this.getOption(), keywordToken, SourceTokenOperator.createWhitespaceSourceToken(curElseIndent));
        }
        if (wrapStartToken) {
            int curElsIfStmtIndent = curElseIndent + this.getOption().beStyleIfElseSingleStmtIndentSize;
            SourceTokenOperator.addBefore(this.getOption(), startToken, SourceTokenOperator.createReturnSourceToken());
            SourceTokenOperator.addBefore(this.getOption(), startToken, SourceTokenOperator.createWhitespaceSourceToken(curElsIfStmtIndent));
        }
    }
}

