/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.plsql;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TStatementList;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.stmtformatter.FormatterFactory;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import gudusoft.gsqlparser.stmt.TStoredProcedureSqlStatement;
import gudusoft.gsqlparser.stmt.mssql.TMssqlBlock;

public class CreateFuncReturnsTableProcessor
extends AbstractProcessor<TStoredProcedureSqlStatement> {
    @Override
    public void process(TStoredProcedureSqlStatement node) {
        TCustomSqlStatement bstmt;
        this.processDeclare(node);
        TStatementList list = node.getBodyStatements();
        if (list == null || list.size() == 0) {
            return;
        }
        TSourceToken allStartToken = node.getStartToken();
        int curIndent = SourceTokenOperator.curColumnNumberVT(allStartToken);
        if (list.get(0) == null) {
            return;
        }
        TSourceToken startToken = list.get(0).getStartToken();
        if (startToken == null || allStartToken == null) {
            return;
        }
        TSourceToken asToken = SourceTokenSearcher.backforwardSearch(startToken, 5, "as");
        if (asToken == null) {
            return;
        }
        SourceTokenOperator.addBefore(this.getOption(), asToken, SourceTokenOperator.createReturnSourceToken());
        SourceTokenOperator.addBefore(this.getOption(), asToken, SourceTokenOperator.createWhitespaceSourceToken(curIndent));
        TSourceToken returnsToken = SourceTokenSearcher.backforwardSearch(asToken, asToken.posinlist - node.getStartToken().posinlist, "returns");
        if (returnsToken != null) {
            SourceTokenOperator.addBefore(this.getOption(), returnsToken, SourceTokenOperator.createReturnSourceToken());
            SourceTokenOperator.addBefore(this.getOption(), returnsToken, SourceTokenOperator.createWhitespaceSourceToken(curIndent));
        }
        for (int i = 0; i < list.size() && (bstmt = list.get(i)) != null && (bstmt.getGsqlparser() == null || bstmt.getGsqlparser().getDbVendor() == EDbVendor.dbvmssql); ++i) {
            if (FormatterFactory.isNotNeedFormat(bstmt)) continue;
            if (bstmt instanceof TMssqlBlock) {
                FormatterFactory.processBlockStmt(this.getOption(), (TMssqlBlock)bstmt, asToken);
                continue;
            }
            TSourceToken bstartToken = bstmt.getStartToken();
            if (bstartToken == null) continue;
            SourceTokenOperator.addBefore(this.getOption(), bstartToken, SourceTokenOperator.createReturnSourceToken());
            SourceTokenOperator.addBefore(this.getOption(), bstartToken, SourceTokenOperator.createWhitespaceSourceToken(curIndent + this.getOption().beStyleBlockIndentSize));
            FormatterFactory.processStatement(this.getOption(), bstmt);
        }
    }

    private void processDeclare(TStoredProcedureSqlStatement node) {
        TStatementList list = node.getDeclareStatements();
        if (list == null || list.size() == 0) {
            return;
        }
        TSourceToken allStartToken = node.getStartToken();
        int curIndent = SourceTokenOperator.curColumnNumberVT(allStartToken);
        if (list.get(0) == null) {
            return;
        }
        TSourceToken startToken = list.get(0).getStartToken();
        if (startToken == null || allStartToken == null) {
            return;
        }
        TSourceToken asToken = SourceTokenSearcher.backforwardSearch(startToken, 5, "is");
        if (asToken == null) {
            return;
        }
        SourceTokenOperator.addBefore(this.getOption(), asToken, SourceTokenOperator.createReturnSourceToken());
        SourceTokenOperator.addBefore(this.getOption(), asToken, SourceTokenOperator.createWhitespaceSourceToken(curIndent));
    }
}

