/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.plsql;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TExceptionHandler;
import gudusoft.gsqlparser.nodes.TExceptionHandlerList;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import gudusoft.gsqlparser.stmt.TBlockSqlStatement;
import gudusoft.gsqlparser.stmt.TCommonBlock;

public class BeginAndEndProcessor
extends AbstractProcessor<TBlockSqlStatement> {
    @Override
    public void process(TBlockSqlStatement block) {
        TCommonBlock plsqlBlock;
        TSourceToken endToken;
        if (block.getGsqlparser().getDbVendor() == EDbVendor.dbvmssql) {
            return;
        }
        TSourceToken beginToken = SourceTokenSearcher.firstSelectedToken(block.getStartToken().container, block.getStartToken().posinlist, block.getEndToken().posinlist, "begin");
        TSourceToken firstToken = SourceTokenSearcher.firstNotWhitespaceAndReturnToken(block.getStartToken().container, block.getStartToken().posinlist, block.getEndToken().posinlist);
        int curIndentlen = SourceTokenOperator.curIndentLenVT(firstToken);
        if (this.getOption().beStyleBlockLeftBEOnNewline.booleanValue() && beginToken != null) {
            SourceTokenOperator.addBefore(this.getOption(), beginToken, SourceTokenOperator.createReturnSourceToken());
            SourceTokenOperator.addBefore(this.getOption(), beginToken, SourceTokenOperator.createWhitespaceSourceToken(curIndentlen + this.getOption().beStyleBlockLeftBEIndentSize));
        }
        if ((endToken = SourceTokenSearcher.lastSelectedToken(block.getEndToken().container, block.getStartToken().posinlist, block.getEndToken().posinlist, "end")) != null) {
            SourceTokenOperator.addBefore(this.getOption(), endToken, SourceTokenOperator.createReturnSourceToken());
            int indentLen = curIndentlen;
            if (this.getOption().beStyleBlockLeftBEOnNewline.booleanValue()) {
                indentLen += this.getOption().beStyleBlockLeftBEIndentSize.intValue();
            }
            SourceTokenOperator.addBefore(this.getOption(), endToken, SourceTokenOperator.createWhitespaceSourceToken(indentLen));
        }
        if (block instanceof TCommonBlock && (plsqlBlock = (TCommonBlock)block).getExceptionClause() != null) {
            TSourceToken exceptionToken = plsqlBlock.getExceptionClause().getStartToken();
            SourceTokenOperator.addBefore(this.getOption(), exceptionToken, SourceTokenOperator.createReturnSourceToken());
            int indentLen = curIndentlen;
            if (this.getOption().beStyleBlockLeftBEOnNewline.booleanValue()) {
                indentLen += this.getOption().beStyleBlockLeftBEIndentSize.intValue();
            }
            SourceTokenOperator.addBefore(this.getOption(), exceptionToken, SourceTokenOperator.createWhitespaceSourceToken(indentLen));
            TExceptionHandlerList handlers = plsqlBlock.getExceptionClause().getHandlers();
            if (handlers != null && handlers.size() > 0) {
                this.handleExceptionHandlers(exceptionToken, handlers);
            }
        }
    }

    private void handleExceptionHandlers(TSourceToken exceptionToken, TExceptionHandlerList handlers) {
        for (int i = 0; i < handlers.size(); ++i) {
            TSourceToken startToken;
            TSourceToken thenToken;
            TExceptionHandler handler = handlers.getExceptionHandler(i);
            if (handler.getStatements() == null || handler.getStatements().size() != 1 || (thenToken = SourceTokenSearcher.backforwardSearch(startToken = handler.getStatements().get(0).getStartToken(), 5, "then")) == null) continue;
            this.wrapStatement(exceptionToken, startToken, thenToken, handler.getStartToken());
        }
    }

    private void wrapStatement(TSourceToken exceptionToken, TSourceToken startToken, TSourceToken thenToken, TSourceToken whenToken) {
        int curIndent = SourceTokenOperator.curColumnNumberVT(exceptionToken);
        SourceTokenOperator.addBefore(this.getOption(), thenToken, SourceTokenOperator.createReturnSourceToken());
        SourceTokenOperator.addBefore(this.getOption(), thenToken, SourceTokenOperator.createWhitespaceSourceToken(curIndent += this.getOption().indentLen.intValue()));
        SourceTokenOperator.addBefore(this.getOption(), whenToken, SourceTokenOperator.createReturnSourceToken());
        SourceTokenOperator.addBefore(this.getOption(), whenToken, SourceTokenOperator.createWhitespaceSourceToken(curIndent));
        SourceTokenOperator.addBefore(this.getOption(), startToken, SourceTokenOperator.createReturnSourceToken());
        SourceTokenOperator.addBefore(this.getOption(), startToken, SourceTokenOperator.createWhitespaceSourceToken(curIndent += this.getOption().indentLen.intValue()));
    }
}

