/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.merge;

import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSourceTokenList;
import gudusoft.gsqlparser.nodes.TMergeWhenClause;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import gudusoft.gsqlparser.stmt.TMergeSqlStatement;

public class MergeWhenClauseProcessor
extends AbstractProcessor<TMergeSqlStatement> {
    @Override
    public void process(TMergeSqlStatement sql) {
        if (sql.getWhenClauses() != null) {
            TPTNodeList<TMergeWhenClause> when = sql.getWhenClauses();
            for (int i = 0; i < when.size(); ++i) {
                TMergeWhenClause clause = when.getElement(i);
                this.processMergeWhenClause(sql, clause);
            }
        }
    }

    private void processMergeWhenClause(TMergeSqlStatement sql, TMergeWhenClause clause) {
        int curIndent = SourceTokenOperator.curColumnNumberVT(this.getMergeToken(sql));
        TSourceToken whenToken = SourceTokenSearcher.forwardSearch(clause.getStartToken(), 5, "when");
        SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), whenToken);
        SourceTokenOperator.addBefore(this.getOption(), whenToken, SourceTokenOperator.createReturnSourceToken());
        SourceTokenOperator.addBefore(this.getOption(), whenToken, SourceTokenOperator.createWhitespaceSourceToken(curIndent));
    }

    private TSourceToken getMergeToken(TMergeSqlStatement node) {
        TSourceTokenList tokens = node.getStartToken().container;
        for (int i = 0; i < tokens.size(); ++i) {
            TSourceToken token = tokens.get(i);
            if (!token.toString().equalsIgnoreCase("merge")) continue;
            return token;
        }
        return null;
    }
}

