/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.merge;

import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSourceTokenList;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.stmtformatter.FormatterFactory;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import gudusoft.gsqlparser.stmt.TMergeSqlStatement;

public class AppendLineAfterMergeTableNameProcessor
extends AbstractProcessor<TMergeSqlStatement> {
    @Override
    public void process(TMergeSqlStatement sql) {
        this.processMergeTable(sql);
        this.processOnCondtion(sql);
    }

    private void processOnCondtion(TMergeSqlStatement sql) {
        TSourceToken onToken = SourceTokenSearcher.forwardSearch(sql.getUsingTable().getEndToken(), 5, "on");
        SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), onToken);
        SourceTokenOperator.addBefore(this.getOption(), onToken, SourceTokenOperator.createReturnSourceToken());
        int curIndent = SourceTokenOperator.curColumnNumberVT(this.getMergeToken(sql));
        SourceTokenOperator.addBefore(this.getOption(), onToken, SourceTokenOperator.createWhitespaceSourceToken(curIndent));
        if (sql.getCondition() != null) {
            TSourceToken leftParaentheseToken = SourceTokenSearcher.forwardSearch(onToken, 3, "(");
            TSourceToken tableNameToken = sql.getTargetTable().getStartToken();
            curIndent = SourceTokenOperator.curColumnNumberVT(tableNameToken);
            int onIndent = SourceTokenOperator.curColumnNumberVT(onToken);
            if (leftParaentheseToken != null) {
                SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), leftParaentheseToken);
                SourceTokenOperator.addBefore(this.getOption(), leftParaentheseToken, SourceTokenOperator.createWhitespaceSourceToken(curIndent - onIndent - onToken.toString().length()));
            }
        }
    }

    private void processMergeTable(TMergeSqlStatement sql) {
        TSourceToken tableNameToken = sql.getTargetTable().getStartToken();
        int curIndent = SourceTokenOperator.curColumnNumberVT(tableNameToken);
        TSourceToken usingToken = SourceTokenSearcher.backforwardSearch(sql.getUsingTable().getStartToken(), 5, "using");
        if (usingToken != null) {
            SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), usingToken);
            SourceTokenOperator.addBefore(this.getOption(), usingToken, SourceTokenOperator.createReturnSourceToken());
            SourceTokenOperator.addBefore(this.getOption(), usingToken, SourceTokenOperator.createWhitespaceSourceToken(curIndent));
            if (sql.getUsingTable().getSubquery() != null) {
                FormatterFactory.processStatement(this.getOption(), sql.getUsingTable().getSubquery());
            }
        }
    }

    private TSourceToken getMergeToken(TMergeSqlStatement node) {
        TSourceTokenList tokens = node.getStartToken().container;
        for (int i = 0; i < tokens.size(); ++i) {
            TSourceToken token = tokens.get(i);
            if (!token.toString().equalsIgnoreCase("merge")) continue;
            return token;
        }
        return null;
    }
}

