/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.insert;

import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TInsertIntoValue;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractKeyWordAlignProcessor;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import gudusoft.gsqlparser.stmt.TInsertSqlStatement;
import java.util.ArrayList;
import java.util.List;

public class InsertKeyWordAlignProcessor
extends AbstractKeyWordAlignProcessor<TInsertSqlStatement> {
    @Override
    protected List<TSourceToken[]> getTSourceToken(TInsertSqlStatement node) {
        ArrayList<TSourceToken[]> tokens = new ArrayList<TSourceToken[]>();
        TSourceToken insertToken = node.getInsertToken();
        if (insertToken == null) {
            return tokens;
        }
        TSourceToken allToken = SourceTokenSearcher.forwardSearch(insertToken, 3, "all");
        TSourceToken firstToken = SourceTokenSearcher.forwardSearch(insertToken, 3, "first");
        if (allToken != null || firstToken != null) {
            if (allToken != null) {
                tokens.add(new TSourceToken[]{insertToken, allToken});
            }
            if (firstToken != null) {
                tokens.add(new TSourceToken[]{insertToken, firstToken});
            }
            if (node.getInsertIntoValues() != null) {
                for (int i = 0; i < node.getInsertIntoValues().size(); ++i) {
                    TSourceToken valueToken;
                    TInsertIntoValue insertValue = node.getInsertIntoValues().getElement(i);
                    if (insertValue.getTargetList() == null || (valueToken = SourceTokenSearcher.backforwardSearch(insertValue.getTargetList().getStartToken(), 3, "values")) == null) continue;
                    tokens.add(new TSourceToken[]{valueToken});
                }
            }
        } else {
            TSourceToken valueToken;
            TSourceToken intoToken = SourceTokenSearcher.forwardSearch(insertToken, 3, "into");
            TSourceToken overwriteToken = SourceTokenSearcher.forwardSearch(insertToken, 3, "overwrite");
            if (intoToken != null) {
                tokens.add(new TSourceToken[]{insertToken, intoToken});
            } else if (overwriteToken != null) {
                tokens.add(new TSourceToken[]{insertToken, overwriteToken});
            } else {
                tokens.add(new TSourceToken[]{insertToken});
            }
            if (node.getOutputClause() != null) {
                TSourceToken outputToken = node.getOutputClause().getStartToken();
                tokens.add(new TSourceToken[]{outputToken});
            }
            if (node.getWhereClause() != null) {
                TSourceToken whereToken = node.getWhereClause().getStartToken();
                tokens.add(new TSourceToken[]{whereToken});
            }
            if (node.getValues() != null && (valueToken = SourceTokenSearcher.backforwardSearch(node.getValues().getStartToken(), 3, "values")) != null) {
                tokens.add(new TSourceToken[]{valueToken});
            }
        }
        return tokens;
    }
}

