/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.insert;

import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TInsertIntoValue;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import gudusoft.gsqlparser.stmt.TInsertSqlStatement;

public class AppendLineAfterInsertTableNameProcessor
extends AbstractProcessor<TInsertSqlStatement> {
    @Override
    public void process(TInsertSqlStatement sql) {
        TObjectNameList columnList = sql.getColumnList();
        this.processTableColumns(sql.getTargetTable(), columnList);
        if (sql.getInsertIntoValues() != null && sql.getInsertIntoValues().size() > 0) {
            for (int i = 0; i < sql.getInsertIntoValues().size(); ++i) {
                TInsertIntoValue insertValue = sql.getInsertIntoValues().getElement(i);
                TSourceToken token = sql.getStartToken();
                int curIndetLen = SourceTokenOperator.curIndentLenVT(token);
                SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), insertValue.getStartToken());
                SourceTokenOperator.addBefore(this.getOption(), insertValue.getStartToken(), SourceTokenOperator.createReturnSourceToken());
                SourceTokenOperator.addBefore(this.getOption(), insertValue.getStartToken(), SourceTokenOperator.createWhitespaceSourceToken(curIndetLen));
                this.processTableColumns(insertValue.getTable(), insertValue.getColumnList());
            }
        }
    }

    private void processTableColumns(TTable table, TObjectNameList columnList) {
        if (columnList != null && columnList.size() > 0) {
            TSourceToken leftParaentheseToken = SourceTokenSearcher.backforwardSearch(columnList.getStartToken(), 3, "(");
            TSourceToken tableNameToken = table.getStartToken();
            int curIndent = SourceTokenOperator.curColumnNumberVT(tableNameToken);
            SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), leftParaentheseToken);
            SourceTokenOperator.addBefore(this.getOption(), leftParaentheseToken, SourceTokenOperator.createReturnSourceToken());
            SourceTokenOperator.addBefore(this.getOption(), leftParaentheseToken, SourceTokenOperator.createWhitespaceSourceToken(curIndent));
        }
    }
}

