/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.ifstmt;

import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.pp.para.GFmtOpt;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.stmtformatter.FormatterFactory;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import gudusoft.gsqlparser.stmt.mssql.TMssqlBlock;
import gudusoft.gsqlparser.stmt.mssql.TMssqlIfElse;

public class IfStmtBEProcessor
extends AbstractProcessor<TMssqlIfElse> {
    @Override
    public void process(TMssqlIfElse stmt) {
        GFmtOpt opt = this.getOption();
        if (stmt.getStmt() instanceof TMssqlBlock) {
            TMssqlBlock bstmt = (TMssqlBlock)stmt.getStmt();
            TSourceToken ifToken = stmt.getStartToken();
            FormatterFactory.processBlockStmt(opt, bstmt, ifToken);
            TCustomSqlStatement elseStmt = stmt.getElseStmt();
            if (elseStmt == null) {
                return;
            }
            TSourceToken elseStmtStartToken = elseStmt.getStartToken();
            if (elseStmtStartToken == null) {
                return;
            }
            TSourceToken elseToken = SourceTokenSearcher.backforwardSearch(elseStmt.getStartToken(), 5, "else");
            if (elseToken == null) {
                return;
            }
            int curElseIndent = SourceTokenOperator.curColumnNumberVT(ifToken);
            SourceTokenOperator.addBefore(opt, elseToken, SourceTokenOperator.createReturnSourceToken());
            SourceTokenOperator.addBefore(opt, elseToken, SourceTokenOperator.createWhitespaceSourceToken(curElseIndent));
            int curElseStmtIndent = curElseIndent + opt.beStyleIfElseSingleStmtIndentSize;
            SourceTokenOperator.addBefore(opt, elseStmtStartToken, SourceTokenOperator.createReturnSourceToken());
            SourceTokenOperator.addBefore(opt, elseStmtStartToken, SourceTokenOperator.createWhitespaceSourceToken(curElseStmtIndent));
        } else if (stmt.getStmt() != null) {
            FormatterFactory.processStatement(this.getOption(), stmt.getStmt());
        }
    }
}

