/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.createtable;

import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TColumnDefinition;
import gudusoft.gsqlparser.nodes.TColumnDefinitionList;
import gudusoft.gsqlparser.pp.para.styleenums.TAlignOption;
import gudusoft.gsqlparser.pp.para.styleenums.TAlignStyle;
import gudusoft.gsqlparser.pp.para.styleenums.TLinefeedsCommaOption;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import java.util.Arrays;

public class CreateTableItemAlignProcessor
extends AbstractProcessor<TColumnDefinitionList> {
    @Override
    public void process(TColumnDefinitionList items) {
        TColumnDefinition define;
        int i;
        TAlignOption alignOption = this.getParameter(TAlignOption.class);
        if (items == null || items.size() == 0) {
            return;
        }
        if (this.getOption().defaultAligntype != TAlignStyle.AsStacked) {
            return;
        }
        int commaOptionAdditionalWhitespace = 0;
        if (this.getOption().defaultCommaOption == TLinefeedsCommaOption.LfbeforeCommaWithSpace) {
            commaOptionAdditionalWhitespace = 2;
        }
        int maxLength = 0;
        for (i = 0; i < items.size(); ++i) {
            define = items.getColumn(i);
            int length = define.getColumnName().getStartToken().astext.length() + (i != 0 ? commaOptionAdditionalWhitespace : 0);
            if (length <= maxLength) continue;
            maxLength = length;
        }
        for (i = 0; i < items.size(); ++i) {
            define = items.getColumn(i);
            TSourceToken nameToken = define.getColumnName().getStartToken();
            int length = nameToken.astext.length() + (i != 0 ? commaOptionAdditionalWhitespace : 0);
            int appendWhitespaceLength = maxLength - length;
            if (appendWhitespaceLength <= 0) continue;
            String emptyText = this.createEmpty(appendWhitespaceLength);
            if (alignOption == TAlignOption.AloLeft) {
                nameToken.astext = nameToken.astext + emptyText;
                continue;
            }
            if (alignOption != TAlignOption.AloRight) continue;
            nameToken.astext = emptyText + nameToken.astext;
        }
    }

    private String createEmpty(int size) {
        char[] tmp = new char[size];
        Arrays.fill(tmp, 0, tmp.length, ' ');
        return String.copyValueOf(tmp);
    }
}

