/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.createtable;

import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TConstraint;
import gudusoft.gsqlparser.nodes.TConstraintList;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import gudusoft.gsqlparser.stmt.TCreateTableSqlStatement;

public class CreateTableConstraintAlignProcessor
extends AbstractProcessor<TCreateTableSqlStatement> {
    @Override
    public void process(TCreateTableSqlStatement sql) {
        TConstraintList constraints = sql.getTableConstraints();
        if (constraints == null || constraints.size() == 0) {
            return;
        }
        TSourceToken parenthesisToken = SourceTokenSearcher.forwardSearch(sql.getTargetTable().getEndToken(), 5, "(");
        int indentLen = SourceTokenOperator.curColumnNumberVT(parenthesisToken);
        TConstraint constraint = constraints.getConstraint(0);
        SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), constraint.getStartToken());
        SourceTokenOperator.addBefore(this.getOption(), constraint.getStartToken(), SourceTokenOperator.createReturnSourceToken());
        SourceTokenOperator.addBefore(this.getOption(), constraint.getStartToken(), SourceTokenOperator.createWhitespaceSourceToken(indentLen + 1));
    }
}

