/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.comm;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TStatementList;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.stmtformatter.FormatterFactory;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;

public class StmtListProcessor
extends AbstractProcessor<TStatementList> {
    @Override
    public void process(TStatementList node) {
        String alignKeyword = this.getParameter(String.class);
        int curIndent = -1;
        for (int i = 0; i < node.size(); ++i) {
            TCustomSqlStatement stmt = node.get(i);
            if (stmt == null || stmt.getParentStmt() == null || stmt.getStartToken() == null || stmt.getEndToken() == null) continue;
            if (stmt.getParentStmt().getGsqlparser().getDbVendor() == EDbVendor.dbvmssql) {
                return;
            }
            if (curIndent == -1 && alignKeyword != null) {
                TSourceToken alignToken = SourceTokenSearcher.firstSelectedToken(stmt.getParentStmt().getStartToken().container, stmt.getParentStmt().getStartToken().posinlist, stmt.getParentStmt().getEndToken().posinlist, alignKeyword);
                if (alignToken == null) {
                    alignToken = stmt.getParentStmt().getStartToken();
                }
                if (alignToken != null) {
                    curIndent = SourceTokenOperator.curColumnNumberVT(alignToken.container, alignToken.posinlist);
                }
            }
            if (alignKeyword != null && curIndent != -1) {
                SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), stmt.getStartToken());
                SourceTokenOperator.addBefore(this.getOption(), stmt.getStartToken(), SourceTokenOperator.createReturnSourceToken());
                SourceTokenOperator.addBefore(this.getOption(), stmt.getStartToken(), SourceTokenOperator.createWhitespaceSourceToken(curIndent + this.getOption().indentLen));
            }
            FormatterFactory.processStatement(this.getOption(), node.get(i));
        }
    }
}

