/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.comm;

import gudusoft.gsqlparser.EExpressionType;
import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TCaseExpression;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TExpressionList;
import gudusoft.gsqlparser.nodes.TFunctionCall;
import gudusoft.gsqlparser.nodes.TGroupingExpressionItem;
import gudusoft.gsqlparser.nodes.TInExpr;
import gudusoft.gsqlparser.nodes.TOrderByItemList;
import gudusoft.gsqlparser.nodes.TTrimArgument;
import gudusoft.gsqlparser.nodes.TTypeName;
import gudusoft.gsqlparser.nodes.TWhenClauseItem;
import gudusoft.gsqlparser.nodes.TWhenClauseItemList;
import gudusoft.gsqlparser.pp.para.GFmtOpt;
import gudusoft.gsqlparser.pp.para.styleenums.TAlignStyle;
import gudusoft.gsqlparser.pp.para.styleenums.TLinefeedsCommaOption;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.processor.type.comm.ColumnlistCommaProcessor;
import gudusoft.gsqlparser.pp.stmtformatter.FormatterFactory;
import gudusoft.gsqlparser.pp.stmtformatter.type.AbstractStmtFormatter;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import gudusoft.gsqlparser.stmt.TDeleteSqlStatement;
import gudusoft.gsqlparser.stmt.TInsertSqlStatement;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;
import gudusoft.gsqlparser.stmt.TUpdateSqlStatement;
import java.util.ArrayList;

public class ExpressionProcessor
extends AbstractProcessor<TExpression> {
    @Override
    public void process(TExpression node) {
        Boolean isAndOrUnderWhere = this.getParameter(Boolean.class);
        if (isAndOrUnderWhere == null) {
            isAndOrUnderWhere = false;
        }
        if (node != null) {
            if ((node.getExpressionType() == EExpressionType.logical_and_t || node.getExpressionType() == EExpressionType.logical_or_t) && node.getFlattedAndOrExprs().size() > 100) {
                ArrayList exprs = node.getFlattedAndOrExprs();
                TExpression lastExpr = null;
                for (int k = 0; k < exprs.size(); ++k) {
                    TExpression expr = (TExpression)exprs.get(k);
                    if (lastExpr == null) {
                        this.process(expr);
                    } else {
                        this.processOperator(lastExpr, expr, isAndOrUnderWhere, k > 1);
                        this.process(expr);
                    }
                    lastExpr = expr;
                }
            } else if (node.getLeftOperand() != null && node.getRightOperand() != null) {
                this.process(node.getLeftOperand());
                this.processOperator(node.getLeftOperand(), node.getRightOperand(), isAndOrUnderWhere);
                this.process(node.getRightOperand());
            } else if (node.getLeftOperand() != null && node.getExpressionType() != EExpressionType.in_t && node.getExpressionType() != EExpressionType.unary_minus_t && node.getExpressionType() != EExpressionType.unary_plus_t) {
                this.processParenthesesNodeInExpression(node.getLeftOperand(), node.getStartToken(), node.getEndToken());
            } else if (node.getRightOperand() != null && node.getExpressionType() != EExpressionType.in_t && node.getExpressionType() != EExpressionType.unary_minus_t && node.getExpressionType() != EExpressionType.unary_plus_t) {
                this.processParenthesesNodeInExpression(node.getRightOperand(), node.getStartToken(), node.getEndToken());
            } else if (node.getFunctionCall() != null) {
                this.processFunctionCall(node.getFunctionCall());
            } else {
                this.processSingleNode(node);
            }
        }
    }

    private void processFunctionCall(TFunctionCall functionCall) {
        TSourceToken startBE = SourceTokenSearcher.forwardSearch(functionCall.getStartToken(), 5, "(");
        TSourceToken endBE = functionCall.getEndToken();
        if (startBE != null && endBE != null) {
            TExpressionList list;
            TOrderByItemList orderByList;
            SourceTokenOperator.removeWhitespaceAndReturnFromStart(this.getOption(), startBE.container, startBE.posinlist + 1);
            if (this.getOption().wsPaddingParenthesesInFunctionCall.booleanValue()) {
                SourceTokenOperator.addAfter(this.getOption(), startBE, SourceTokenOperator.createWhitespaceSourceToken(1));
            }
            SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), endBE);
            if (this.getOption().wsPaddingParenthesesInFunctionCall.booleanValue()) {
                SourceTokenOperator.addBefore(this.getOption(), endBE, SourceTokenOperator.createWhitespaceSourceToken(1));
            }
            if (functionCall.getAgainstExpr() != null) {
                this.process(functionCall.getAgainstExpr());
            }
            if (functionCall.getBetweenExpr() != null) {
                this.process(functionCall.getBetweenExpr());
            }
            if (functionCall.getExpr1() != null) {
                this.process(functionCall.getExpr1());
            }
            if (functionCall.getExpr2() != null) {
                this.process(functionCall.getExpr2());
            }
            if (functionCall.getExpr3() != null) {
                this.process(functionCall.getExpr3());
            }
            if (functionCall.getParameter() != null) {
                this.process(functionCall.getParameter());
            }
            if (functionCall.getInExpr() != null) {
                TInExpr inExpr = functionCall.getInExpr();
                if (inExpr.getExprList() != null) {
                    this.processFunctionCallParameters(inExpr.getExprList());
                }
                if (inExpr.getFunc_expr() != null) {
                    this.process(inExpr.getFunc_expr());
                }
                if (inExpr.getGroupingExpressionItemList() != null) {
                    for (int k = 0; k < inExpr.getGroupingExpressionItemList().size(); ++k) {
                        TGroupingExpressionItem item = inExpr.getGroupingExpressionItemList().getGroupingExpressionItem(k);
                        if (item.getExpr() != null) {
                            this.process(item.getExpr());
                        }
                        if (item.getExprList() == null) continue;
                        this.processFunctionCallParameters(item.getExprList());
                    }
                }
            }
            if (functionCall.getRangeSize() != null) {
                this.process(functionCall.getRangeSize());
            }
            if (functionCall.getXMLElementNameExpr() != null) {
                this.process(functionCall.getXMLElementNameExpr());
            }
            if (functionCall.getXMLType_Instance() != null) {
                this.process(functionCall.getXMLType_Instance());
            }
            if (functionCall.getXPath_String() != null) {
                this.process(functionCall.getXPath_String());
            }
            if (functionCall.getNamespace_String() != null) {
                this.process(functionCall.getNamespace_String());
            }
            if (functionCall.getArgs() != null) {
                this.processFunctionCallParameters(functionCall.getArgs());
            }
            if (functionCall.getTrimArgument() != null) {
                TTrimArgument args = functionCall.getTrimArgument();
                TExpression expr = args.getStringExpression();
                if (expr != null) {
                    this.process(expr);
                }
                if ((expr = args.getTrimCharacter()) != null) {
                    this.process(expr);
                }
            }
            if (functionCall.getOrderByList() != null) {
                orderByList = functionCall.getOrderByList();
                this.processOrderByList(orderByList);
            }
            if (functionCall.getAnalyticFunction() != null) {
                list = functionCall.getAnalyticFunction().getPartitionBy_ExprList();
                if (list != null) {
                    this.processFunctionCallParameters(list);
                }
                if (functionCall.getAnalyticFunction().getOrderBy() != null) {
                    TOrderByItemList orderByList2 = functionCall.getAnalyticFunction().getOrderBy().getItems();
                    this.processOrderByList(orderByList2);
                }
            } else if (functionCall.getWindowDef() != null) {
                if (functionCall.getWindowDef().getPartitionClause() != null && (list = functionCall.getWindowDef().getPartitionClause().getExpressionList()) != null) {
                    this.processFunctionCallParameters(list);
                }
                if (functionCall.getWindowDef().getOrderBy() != null) {
                    orderByList = functionCall.getWindowDef().getOrderBy().getItems();
                    this.processOrderByList(orderByList);
                }
            }
        }
    }

    private void processOrderByList(TOrderByItemList orderByList) {
        for (int k = 0; k < orderByList.size(); ++k) {
            TExpression expr = orderByList.getOrderByItem(k).getSortKey();
            if (expr == null) continue;
            this.process(expr);
        }
    }

    private void processFunctionCallParameters(TExpressionList columns) {
        if (columns == null || columns.size() == 0) {
            return;
        }
        TAlignStyle functionCallParametersStyle = this.getOption().functionCallParametersStyle;
        TLinefeedsCommaOption functionCallParametersComma = this.getOption().functionCallParametersComma;
        ColumnlistCommaProcessor.processColumns(this.getOption(), functionCallParametersComma, functionCallParametersStyle, columns);
        for (int i = 0; i < columns.size(); ++i) {
            this.process(columns.getExpression(i));
        }
    }

    private void processSingleNode(TExpression node) {
        if (node.getExpressionType() == EExpressionType.in_t) {
            if (node.getSubQuery() != null) {
                ExpressionProcessor.processParenthesesNodeInSubQuery(this.getOption(), node.getSubQuery(), node.getStartToken(), node.getEndToken());
            }
        } else if (node.getCaseExpression() != null) {
            this.processCase(node.getCaseExpression());
        } else if (node.getSubQuery() != null) {
            ExpressionProcessor.processParenthesesNodeInSubQuery(this.getOption(), node.getSubQuery(), node.getStartToken(), node.getEndToken());
        } else if (node.getFunctionCall() != null) {
            this.processParenthesesNodeInFunctionCall(this.getOption(), node.getFunctionCall());
        } else if (node.getExpressionType() == EExpressionType.unary_minus_t || node.getExpressionType() == EExpressionType.unary_plus_t) {
            this.processUnaryOperation(node);
        }
    }

    private void processUnaryOperation(TExpression node) {
        SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), node.getStartToken());
    }

    private void processParenthesesNodeInFunctionCall(GFmtOpt option, TFunctionCall fc) {
        TSourceToken leftParenthesis = SourceTokenSearcher.forwardSearch(fc.getFunctionName().getStartToken(), 5, "(");
        TSourceToken rightParenthesis = fc.getEndToken();
        SourceTokenOperator.removeWhitespaceAndReturnFormBeforeAndAfter(this.getOption(), leftParenthesis);
        SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), rightParenthesis);
        if (option.wsPaddingParenthesesInFunctionCall.booleanValue() && rightParenthesis.posinlist - leftParenthesis.posinlist > 1) {
            SourceTokenOperator.addAfter(this.getOption(), leftParenthesis, SourceTokenOperator.createWhitespaceSourceToken(1));
            SourceTokenOperator.addBefore(this.getOption(), rightParenthesis, SourceTokenOperator.createWhitespaceSourceToken(1));
        }
    }

    public static void processParenthesesNodeInSubQuery(GFmtOpt option, TCustomSqlStatement sql, TSourceToken leftParenthesis, TSourceToken rightParenthsis) {
        AbstractStmtFormatter formatter = null;
        if (sql instanceof TSelectSqlStatement) {
            formatter = FormatterFactory.createSelectStmtFormatter(option);
        } else if (sql instanceof TUpdateSqlStatement) {
            formatter = FormatterFactory.createUpdateStmtFormatter(option);
        } else if (sql instanceof TInsertSqlStatement) {
            formatter = FormatterFactory.createInsertStmtFormatter(option);
        } else if (sql instanceof TDeleteSqlStatement) {
            formatter = FormatterFactory.createDeleteStmtFormatter(option);
        }
        if (formatter == null) {
            return;
        }
        if (!"(".equals(leftParenthesis.astext) || !")".equals(rightParenthsis.astext)) {
            formatter.format(sql);
            return;
        }
        SourceTokenOperator.removeWhitespaceAndReturnFromStart(option, leftParenthesis.container, leftParenthesis.posinlist + 1);
        if (option.wsPaddingParenthesesOfSubQuery.booleanValue()) {
            SourceTokenOperator.addAfter(option, leftParenthesis, SourceTokenOperator.createWhitespaceSourceToken(1));
        }
        formatter.format(sql);
        SourceTokenOperator.removeWhitespaceAndReturnFromEnd(option, rightParenthsis.container, rightParenthsis.posinlist);
        if (option.wsPaddingParenthesesOfSubQuery.booleanValue()) {
            SourceTokenOperator.addBefore(option, rightParenthsis, SourceTokenOperator.createWhitespaceSourceToken(1));
        }
    }

    private void processParenthesesNodeInExpression(TExpression node, TSourceToken leftParenthesis, TSourceToken rightParenthsis) {
        if (node.getParentExpr() != null && node.getParentExpr().getExpressionType() == EExpressionType.parenthesis_t) {
            SourceTokenOperator.removeWhitespaceAndReturnFromStart(this.getOption(), leftParenthesis.container, leftParenthesis.posinlist + 1);
            if (this.getOption().wsPaddingParenthesesInExpression.booleanValue()) {
                SourceTokenOperator.addAfter(this.getOption(), leftParenthesis, SourceTokenOperator.createWhitespaceSourceToken(1));
            }
            this.process(node);
            SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), rightParenthsis.container, rightParenthsis.posinlist);
            if (this.getOption().wsPaddingParenthesesInExpression.booleanValue()) {
                SourceTokenOperator.addBefore(this.getOption(), rightParenthsis, SourceTokenOperator.createWhitespaceSourceToken(1));
            }
        } else {
            this.process(node);
        }
    }

    private void processCase(TCaseExpression caseExpr) {
        TSourceToken caseToken = caseExpr.getStartToken();
        int indentLen = SourceTokenOperator.curColumnNumberVT(caseToken);
        TWhenClauseItemList whenExprs = caseExpr.getWhenClauseItemList();
        if (whenExprs != null && whenExprs.size() > 0) {
            for (int i = 0; i < whenExprs.size(); ++i) {
                TWhenClauseItem whenExpr = whenExprs.getWhenClauseItem(i);
                TSourceToken whenToken = whenExpr.getStartToken();
                SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), whenToken);
                SourceTokenOperator.addBefore(this.getOption(), whenToken, SourceTokenOperator.createReturnSourceToken());
                SourceTokenOperator.addBefore(this.getOption(), whenToken, SourceTokenOperator.createWhitespaceSourceToken(indentLen + this.getOption().indentCaseFromSwitch));
                TSourceToken thenToken = SourceTokenSearcher.lastNotWhitespaceAndReturnToken(whenExpr.getReturn_expr().getStartToken().container, whenExpr.getReturn_expr().getStartToken().posinlist - 1);
                if (thenToken.astext.equalsIgnoreCase("then")) {
                    SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), thenToken);
                    if (this.getOption().caseWhenThenInSameLine.booleanValue()) {
                        SourceTokenOperator.addBefore(this.getOption(), thenToken, SourceTokenOperator.createWhitespaceSourceToken(1));
                    } else {
                        SourceTokenOperator.addBefore(this.getOption(), thenToken, SourceTokenOperator.createReturnSourceToken());
                        SourceTokenOperator.addBefore(this.getOption(), thenToken, SourceTokenOperator.createWhitespaceSourceToken(indentLen + this.getOption().indentCaseFromSwitch + this.getOption().indentCaseThen));
                    }
                }
                this.process(whenExpr.getComparison_expr());
                this.process(whenExpr.getReturn_expr());
            }
        }
        if (caseExpr.getElse_expr() != null) {
            TSourceToken elseToken = SourceTokenSearcher.lastNotWhitespaceAndReturnToken(caseExpr.getElse_expr().getStartToken().container, caseExpr.getElse_expr().getStartToken().posinlist - 1);
            if (elseToken.astext.equalsIgnoreCase("else")) {
                SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), elseToken);
                SourceTokenOperator.addBefore(this.getOption(), elseToken, SourceTokenOperator.createReturnSourceToken());
                SourceTokenOperator.addBefore(this.getOption(), elseToken, SourceTokenOperator.createWhitespaceSourceToken(indentLen + this.getOption().indentCaseFromSwitch));
            }
            this.process(caseExpr.getElse_expr());
        }
        TSourceToken endToken = caseExpr.getEndToken();
        SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), endToken);
        SourceTokenOperator.addBefore(this.getOption(), endToken, SourceTokenOperator.createReturnSourceToken());
        SourceTokenOperator.addBefore(this.getOption(), endToken, SourceTokenOperator.createWhitespaceSourceToken(indentLen));
    }

    private void processOperator(TExpression left, TExpression right, Boolean isAndOrUnderWhere) {
        this.processOperator(left, right, isAndOrUnderWhere, false);
    }

    private void processOperator(TExpression left, TExpression right, Boolean isAndOrUnderWhere, boolean isFlattedAndOr) {
        int curIndent = SourceTokenOperator.curColumnNumberVT(left.getStartToken());
        if (isFlattedAndOr) {
            curIndent = SourceTokenOperator.curColumnNumberVT(SourceTokenSearcher.lastNotWhitespaceAndReturnToken(left.getStartToken().container, left.getStartToken().posinlist - 1));
        }
        TSourceToken operatorToken = SourceTokenSearcher.firstNotWhitespaceAndReturnToken(left.getEndToken().container, left.getEndToken().posinlist + 1, right.getStartToken().posinlist);
        if (ETokenType.ttconcatenationop.equals((Object)operatorToken.tokentype)) {
            SourceTokenOperator.addBefore(this.getOption(), operatorToken, SourceTokenOperator.createReturnSourceToken());
            SourceTokenOperator.addBefore(this.getOption(), operatorToken, SourceTokenOperator.createWhitespaceSourceToken(curIndent + this.getOption().indentLen));
        } else if ("and".equalsIgnoreCase(operatorToken.astext) || "or".equalsIgnoreCase(operatorToken.astext)) {
            if (left.getParentExpr() != null && left.getParentExpr().getExpressionType() == EExpressionType.between_t) {
                return;
            }
            SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), operatorToken);
            SourceTokenOperator.addBefore(this.getOption(), operatorToken, SourceTokenOperator.createReturnSourceToken());
            if (isAndOrUnderWhere.booleanValue()) {
                curIndent -= operatorToken.astext.length() + 1;
            }
            SourceTokenOperator.addBefore(this.getOption(), operatorToken, SourceTokenOperator.createWhitespaceSourceToken(curIndent));
            SourceTokenOperator.removeWhitespaceAndReturnFromStart(this.getOption(), operatorToken.container, operatorToken.posinlist + 1);
            SourceTokenOperator.addAfter(this.getOption(), operatorToken, SourceTokenOperator.createWhitespaceSourceToken(1));
        } else if (operatorToken.astext.trim().equals("+") || operatorToken.astext.trim().equals("-") || operatorToken.astext.trim().equals("*") || operatorToken.astext.trim().equals("/") || operatorToken.astext.trim().equals(">") || operatorToken.astext.trim().equals(">=") || operatorToken.astext.trim().equals("<") || operatorToken.astext.trim().equals("<=") || operatorToken.astext.trim().equals("==") || operatorToken.astext.trim().equals("!=") || operatorToken.astext.trim().equals("<>") || operatorToken.astext.trim().equals("=") || operatorToken.astext.trim().equals("^=")) {
            SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), operatorToken.container, operatorToken.posinlist);
            SourceTokenOperator.removeWhitespaceAndReturnFromStart(this.getOption(), operatorToken.container, operatorToken.posinlist + 1);
            if (this.getOption().wsPaddingOperatorArithmetic.booleanValue()) {
                SourceTokenOperator.addBefore(this.getOption(), operatorToken, SourceTokenOperator.createWhitespaceSourceToken(1));
                SourceTokenOperator.addAfter(this.getOption(), operatorToken, SourceTokenOperator.createWhitespaceSourceToken(1));
            }
        }
    }

    public static void processTypeName(GFmtOpt option, TTypeName type) {
        TSourceToken endBE;
        TSourceToken startBE = SourceTokenSearcher.forwardSearch(type.getStartToken(), 5, "(");
        if (startBE != null && (endBE = SourceTokenSearcher.forwardSearch(startBE, 15, ")")) != null) {
            SourceTokenOperator.removeWhitespaceAndReturnFromStart(option, startBE.container, startBE.posinlist + 1);
            if (option.wsPaddingParenthesesOfTypename.booleanValue()) {
                SourceTokenOperator.addAfter(option, startBE, SourceTokenOperator.createWhitespaceSourceToken(1));
            }
            SourceTokenOperator.removeWhitespaceAndReturnFromEnd(option, endBE);
            if (option.wsPaddingParenthesesOfTypename.booleanValue()) {
                SourceTokenOperator.addBefore(option, endBE, SourceTokenOperator.createWhitespaceSourceToken(1));
            }
        }
    }
}

