/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.comm;

import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSourceTokenList;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.pp.mediator.MediatorFactory;
import gudusoft.gsqlparser.pp.mediator.type.SourceTokenTextTempMediator;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.stmtformatter.FormatterFactory;

public class CombineWhitespaceAndClearReturnProcessor
extends AbstractProcessor<TParseTreeNode> {
    @Override
    public void beforeProcess(TParseTreeNode node) {
        if (node.getStartToken() == null || node.getEndToken() == null) {
            return;
        }
        TSourceTokenList container = node.getStartToken().container;
        for (int i = node.getStartToken().posinlist; i < node.getEndToken().posinlist + 1 && i < container.size(); ++i) {
            TSourceToken token = container.get(i);
            if (FormatterFactory.isNotNeedFormat(token)) continue;
            if (token.tokentype == ETokenType.ttwhitespace) {
                token.astext = " ";
                continue;
            }
            if (token.tokentype != ETokenType.ttreturn || token.posinlist <= 0) continue;
            SourceTokenTextTempMediator mediator = MediatorFactory.getMediator(SourceTokenTextTempMediator.class, this.getOption().sessionId);
            mediator.set(token.posinlist, token.astext);
            if (token.container.get((int)(token.posinlist - 1)).tokentype == ETokenType.ttwhitespace) {
                token.astext = "";
            } else if (token.posinlist < token.container.size() - 1) {
                TSourceToken nextToken = token.container.get(token.posinlist + 1);
                token.astext = nextToken.tokentype == ETokenType.ttwhitespace ? "" : " ";
            } else {
                token.astext = " ";
            }
            token.tokentype = ETokenType.ttwhitespace;
        }
    }
}

