/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.comm;

import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSourceTokenList;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeNodeList;
import gudusoft.gsqlparser.pp.para.GFmtOpt;
import gudusoft.gsqlparser.pp.para.styleenums.TAlignStyle;
import gudusoft.gsqlparser.pp.para.styleenums.TLinefeedsCommaOption;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.processor.type.comm.ExpressionProcessor;
import gudusoft.gsqlparser.pp.utils.SourceTokenConstant;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;

public class ColumnlistCommaProcessor
extends AbstractProcessor<TParseTreeNodeList> {
    public static Object[] getNextNotEmptyNode(TParseTreeNodeList list, int startPos) {
        int curPos = startPos;
        TParseTreeNode cur = null;
        while (curPos < list.size()) {
            cur = list.getElement(curPos);
            if (cur.getStartToken() != null) {
                return new Object[]{cur, curPos};
            }
            ++curPos;
        }
        return new Object[]{null, -1};
    }

    public static void processColumns(GFmtOpt opt, TLinefeedsCommaOption p, TAlignStyle alignStype, TParseTreeNodeList columns) {
        if (columns == null || columns.size() == 0) {
            return;
        }
        Object[] firstNodeObj = ColumnlistCommaProcessor.getNextNotEmptyNode(columns, 0);
        TParseTreeNode firstNode = (TParseTreeNode)firstNodeObj[0];
        int firstNodePos = (Integer)firstNodeObj[1];
        TSourceToken firstColumnStartToken = null;
        if (firstNode != null && firstNode.getStartToken() != null) {
            firstColumnStartToken = firstNode.getStartToken();
        }
        int indentLen = SourceTokenOperator.curColumnNumberVT(firstColumnStartToken);
        TParseTreeNode pre = null;
        int curPos = firstNodePos;
        TParseTreeNode cur = firstNode;
        while (true) {
            TSourceToken token;
            pre = cur;
            Object[] curNodeObj = ColumnlistCommaProcessor.getNextNotEmptyNode(columns, curPos + 1);
            cur = (TParseTreeNode)curNodeObj[0];
            curPos = (Integer)curNodeObj[1];
            if (cur == null) break;
            if (pre.getStartToken() == null || pre.getEndToken() == null || cur.getStartToken() == null || cur.getEndToken() == null) continue;
            TSourceTokenList containter = pre.getStartToken().container;
            if (alignStype == TAlignStyle.AsWrapped) {
                if (p != TLinefeedsCommaOption.LfbeforeCommaWithSpace) continue;
                SourceTokenOperator.addBefore(opt, cur.getStartToken(), SourceTokenConstant.WHITESPACE);
                continue;
            }
            if (p == TLinefeedsCommaOption.LfAfterComma) {
                token = SourceTokenSearcher.lastNotWhitespaceAndReturnToken(containter, pre.getEndToken().posinlist, cur.getStartToken().posinlist);
                if (token == null) break;
                if (token.tokentype == ETokenType.ttcomma) {
                    SourceTokenOperator.removeWhitespaceAndReturnFromEnd(opt, containter, token.posinlist);
                    SourceTokenOperator.removeWhitespaceAndReturnFromStart(opt, containter, token.posinlist + 1);
                }
                SourceTokenOperator.addBefore(opt, cur.getStartToken(), SourceTokenOperator.createReturnSourceToken());
                SourceTokenOperator.addBefore(opt, cur.getStartToken(), SourceTokenOperator.createWhitespaceSourceToken(indentLen));
                continue;
            }
            if (p != TLinefeedsCommaOption.LfbeforeCommaWithSpace && p != TLinefeedsCommaOption.LfBeforeComma) continue;
            token = SourceTokenSearcher.lastNotWhitespaceAndReturnToken(containter, pre.getEndToken().posinlist, cur.getStartToken().posinlist);
            if (token == null) break;
            if (token.tokentype == ETokenType.ttcomma) {
                SourceTokenOperator.removeWhitespaceAndReturnFromEnd(opt, containter, token.posinlist);
                SourceTokenOperator.removeWhitespaceAndReturnFromStart(opt, containter, token.posinlist + 1);
                SourceTokenOperator.addBefore(opt, token, SourceTokenOperator.createReturnSourceToken());
                SourceTokenOperator.addBefore(opt, token, SourceTokenOperator.createWhitespaceSourceToken(indentLen));
                if (p != TLinefeedsCommaOption.LfbeforeCommaWithSpace) continue;
                SourceTokenOperator.addAfter(opt, token, SourceTokenConstant.WHITESPACE);
                continue;
            }
            if (token.astext == null || !token.astext.equalsIgnoreCase("distinct")) continue;
            SourceTokenOperator.removeWhitespaceAndReturnFromStart(opt, containter, token.posinlist + 1);
            SourceTokenOperator.addAfter(opt, token, SourceTokenOperator.createReturnSourceToken());
        }
    }

    @Override
    public void process(TParseTreeNodeList columns) {
        TLinefeedsCommaOption p = this.getParameter(TLinefeedsCommaOption.class, 0);
        TAlignStyle alignStype = this.getParameter(TAlignStyle.class, 1);
        ColumnlistCommaProcessor.processColumns(this.getOption(), p, alignStype, columns);
    }

    private static void procressSubquery(TParseTreeNodeList columns, GFmtOpt opt) {
        if (columns == null) {
            return;
        }
        for (int i = 0; i < columns.size(); ++i) {
            TExpression express;
            TParseTreeNode node = columns.getElement(i);
            if (!(node instanceof TExpression) || (express = (TExpression)node).getSubQuery() == null) continue;
            ExpressionProcessor.processParenthesesNodeInSubQuery(opt, express.getSubQuery(), express.getSubQuery().getStartToken(), express.getSubQuery().getEndToken());
        }
    }
}

