/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.comm;

import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSourceTokenList;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.pp.para.styleenums.TCaseOption;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;

public class CapitalisationProcessor
extends AbstractProcessor<TParseTreeNode> {
    @Override
    public void beforeProcess(TParseTreeNode node) {
        if (node.getStartToken() == null || node.getEndToken() == null) {
            return;
        }
        TSourceTokenList container = node.getStartToken().container;
        for (int i = node.getStartToken().posinlist; i < node.getEndToken().posinlist + 1 && i < container.size(); ++i) {
            TSourceToken token = container.get(i);
            if (token.tokentype == ETokenType.ttkeyword) {
                if (token.getDbObjType() == 30) {
                    this.processToken(token, this.getOption().caseDatatype);
                    continue;
                }
                if (token.getDbObjType() == 13) {
                    this.processToken(token, this.getOption().caseFuncname);
                    continue;
                }
                this.processToken(token, this.getOption().caseKeywords);
                continue;
            }
            if (token.tokentype == ETokenType.ttidentifier) {
                if (token.getDbObjType() == 30) {
                    this.processToken(token, this.getOption().caseDatatype);
                    continue;
                }
                if (token.getDbObjType() == 13) {
                    this.processToken(token, this.getOption().caseFuncname);
                    continue;
                }
                this.processToken(token, this.getOption().caseIdentifier);
                continue;
            }
            if (token.tokentype != ETokenType.ttdqstring) continue;
            this.processToken(token, this.getOption().caseQuotedIdentifier);
        }
    }

    private void processToken(TSourceToken token, TCaseOption type) {
        if (token == null || token.astext == null) {
            return;
        }
        if (type == TCaseOption.CoUppercase) {
            token.astext = token.astext.toUpperCase();
        } else if (type == TCaseOption.CoLowercase) {
            token.astext = token.astext.toLowerCase();
        } else if (type == TCaseOption.CoInitCap) {
            StringBuffer sb = new StringBuffer();
            char[] words = token.astext.toCharArray();
            int prevc = 32;
            for (int n : words) {
                if (n != 32 && prevc == 32) {
                    sb.append(Character.toUpperCase((char)n));
                } else {
                    sb.append(Character.toLowerCase((char)n));
                }
                prevc = n;
            }
            token.astext = sb.toString();
        }
    }
}

