/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.comm;

import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.pp.mediator.MediatorFactory;
import gudusoft.gsqlparser.pp.mediator.type.KeywordAlignMediator;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.utils.SourceTokenConstant;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;

public class AppendNewLineAfterReverseKeyWordProcessor
extends AbstractProcessor<TParseTreeNode> {
    @Override
    public void process(TParseTreeNode node) {
        if (node == null) {
            return;
        }
        boolean isItemNewLine = this.getParameter(Boolean.class);
        String keyword = this.getParameter(String.class, 1);
        TSourceToken itemToken = node.getStartToken();
        TSourceToken keywordToken = SourceTokenSearcher.backforwardSearch(itemToken, 10, keyword);
        if (keywordToken != null) {
            int curIndent = SourceTokenOperator.curColumnNumberVT(keywordToken);
            KeywordAlignMediator mediator = MediatorFactory.getMediator(KeywordAlignMediator.class, this.getOption().sessionId);
            mediator.addIndentLevelItem(keywordToken, curIndent);
            SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), itemToken);
            if (isItemNewLine) {
                SourceTokenOperator.addBefore(this.getOption(), itemToken, SourceTokenOperator.createReturnSourceToken());
                SourceTokenOperator.addBefore(this.getOption(), itemToken, SourceTokenOperator.createWhitespaceSourceToken(curIndent + this.getOption().indentLen));
            } else {
                SourceTokenOperator.addBefore(this.getOption(), itemToken, SourceTokenConstant.WHITESPACE);
            }
        }
    }
}

