/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.comm;

import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TParameterDeclaration;
import gudusoft.gsqlparser.nodes.TParameterDeclarationList;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeNodeList;
import gudusoft.gsqlparser.nodes.TResultColumn;
import gudusoft.gsqlparser.nodes.TResultColumnList;
import gudusoft.gsqlparser.pp.para.styleenums.TAlignStyle;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import java.util.HashMap;

public class AlignAliasProcessor
extends AbstractProcessor<TParseTreeNode> {
    @Override
    public void afterProcess(TParseTreeNode node) {
        int length;
        int endPos;
        int startPos;
        TParseTreeNode c;
        int i;
        if (!(node instanceof TResultColumnList) && !(node instanceof TParameterDeclarationList)) {
            return;
        }
        boolean isAlignAliasInSelectList = this.getParameter(Boolean.class);
        TAlignStyle alignStyle = this.getParameter(TAlignStyle.class, 1);
        if (!isAlignAliasInSelectList || alignStyle == TAlignStyle.AsWrapped) {
            return;
        }
        TParseTreeNodeList list = (TParseTreeNodeList)node;
        int maxLength = -1;
        HashMap<String, Integer> cachedLength = new HashMap<String, Integer>();
        for (i = 0; i < list.size(); ++i) {
            c = list.getElement(i);
            startPos = c.getStartToken().posinlist;
            endPos = -1;
            if (c instanceof TResultColumn ? (endPos = this.getEndPos((TResultColumn)c)) == -1 : c instanceof TParameterDeclaration && (endPos = this.getEndPos((TParameterDeclaration)c)) == -1) continue;
            length = SourceTokenOperator.curColumnNumberVT(c.getStartToken().container, endPos);
            cachedLength.put(startPos + "_" + endPos, length);
            if (length < maxLength) continue;
            maxLength = length;
        }
        for (i = 0; i < list.size(); ++i) {
            c = list.getElement(i);
            startPos = c.getStartToken().posinlist;
            endPos = -1;
            if (!(c instanceof TResultColumn) ? c instanceof TParameterDeclaration && (endPos = this.getEndPos((TParameterDeclaration)c)) == -1 : (endPos = this.getEndPos((TResultColumn)c)) == -1) continue;
            length = (Integer)cachedLength.get(startPos + "_" + endPos);
            int fillLength = maxLength - length;
            if (fillLength == 0) continue;
            TSourceToken t = SourceTokenOperator.createWhitespaceSourceToken(fillLength);
            SourceTokenOperator.addBefore(this.getOption(), c.getStartToken().container.get(endPos), t);
        }
    }

    private int getEndPos(TResultColumn c) {
        int endPos = -1;
        if (c.getAliasClause() == null) {
            return -1;
        }
        endPos = SourceTokenSearcher.lastIndexOf(c.getStartToken().container, c.getStartToken().posinlist, c.getAliasClause().getStartToken().posinlist, "as");
        if (endPos == -1) {
            endPos = c.getAliasClause().getStartToken().posinlist;
        }
        return endPos;
    }

    private int getEndPos(TParameterDeclaration c) {
        int endPos = -1;
        endPos = SourceTokenSearcher.lastIndexOf(c.getStartToken().container, c.getStartToken().posinlist, c.getEndToken().posinlist, "as");
        if (endPos == -1) {
            endPos = c.getEndToken().posinlist;
        }
        return endPos;
    }
}

