/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.comm;

import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.pp.para.styleenums.TAlignOption;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractKeyWordAlignProcessor<E extends TCustomSqlStatement>
extends AbstractProcessor<E> {
    protected abstract List<TSourceToken[]> getTSourceToken(E var1);

    @Override
    public void beforeProcess(E node) {
        List<TSourceToken[]> tokens = this.getTSourceToken(node);
        int maxSize = 0;
        for (TSourceToken[] token : tokens) {
            if (this.textSize(token) <= maxSize) continue;
            maxSize = this.textSize(token);
        }
        for (TSourceToken[] token : tokens) {
            this.alignText(token, maxSize);
        }
    }

    private int textSize(TSourceToken[] tokenStartAndEnd) {
        if (tokenStartAndEnd.length == 1) {
            return this.textSize(tokenStartAndEnd[0]);
        }
        TSourceToken start = tokenStartAndEnd[0];
        TSourceToken end = tokenStartAndEnd[1];
        int len = 0;
        for (int i = start.posinlist; i <= end.posinlist; ++i) {
            TSourceToken token = start.container.get(i);
            if (token.astext == null) continue;
            len += token.astext.length();
        }
        return len;
    }

    private int textSize(TSourceToken token) {
        if (token != null && token.astext != null) {
            return token.astext.length();
        }
        return 0;
    }

    private String text(TSourceToken token) {
        if (token != null && token.astext != null) {
            return token.astext;
        }
        return "";
    }

    private void alignText(TSourceToken[] tokenStartAndEnd, int maxSize) {
        if (tokenStartAndEnd.length == 1) {
            this.alignText(tokenStartAndEnd[0], maxSize);
        } else {
            int curSize = this.textSize(tokenStartAndEnd);
            String emp = this.createEmpty(maxSize - curSize);
            if (this.getOption().selectKeywordsAlignOption == TAlignOption.AloLeft) {
                tokenStartAndEnd[1].astext = tokenStartAndEnd[1].astext + emp;
            } else {
                tokenStartAndEnd[0].astext = emp + tokenStartAndEnd[0];
            }
        }
    }

    private void alignText(TSourceToken token, int maxSize) {
        int curSize = this.textSize(token);
        String emp = this.createEmpty(maxSize - curSize);
        token.astext = this.getOption().selectKeywordsAlignOption == TAlignOption.AloLeft ? this.text(token) + emp : emp + this.text(token);
    }

    private String createEmpty(int size) {
        char[] tmp = new char[size];
        Arrays.fill(tmp, 0, tmp.length, ' ');
        return String.copyValueOf(tmp);
    }
}

