/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.print;

import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSourceTokenList;
import gudusoft.gsqlparser.pp.output.OutputConfig;
import gudusoft.gsqlparser.pp.print.IPrinter;
import java.io.IOException;
import java.io.OutputStream;

public class TextPrinter
implements IPrinter {
    private OutputStream out = System.out;
    private OutputConfig outputConfig = null;

    @Override
    public void print(TSourceTokenList tl) {
        for (int i = 0; i < tl.size(); ++i) {
            TSourceToken t = tl.get(i);
            if (t.getTokensBefore() != null && t.getTokensBefore().size() > 0) {
                this.print(t.getTokensBefore());
            }
            if (t.getReplaceToken() != null) {
                this.print(t.getReplaceToken());
            } else {
                this.print(t);
            }
            if (t.getTokensAfter() == null || t.getTokensAfter().size() <= 0) continue;
            this.print(t.getTokensAfter());
        }
    }

    @Override
    public void print(TSourceToken t) {
        try {
            if (this.outputConfig != null) {
                this.out.write(this.outputConfig.renderHighlightingElement(t).toString().getBytes());
            } else {
                this.out.write(t.toString().getBytes());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public OutputStream getOut() {
        return this.out;
    }

    @Override
    public void setOut(OutputStream out) {
        this.out = out;
    }

    @Override
    public void setOutputConfig(OutputConfig outputConfig) {
        this.outputConfig = outputConfig;
    }
}

