/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.print;

import gudusoft.gsqlparser.pp.logger.PPLogger;
import gudusoft.gsqlparser.pp.print.IPrinter;
import gudusoft.gsqlparser.pp.print.TextPrinter;
import java.io.OutputStream;

public class PrinterFactory {
    public static TextPrinter createTextPrinter() {
        return PrinterFactory.createPrinter(TextPrinter.class);
    }

    public static TextPrinter createTextPrinter(OutputStream out) {
        return PrinterFactory.createPrinter(TextPrinter.class, out);
    }

    public static <E extends IPrinter> E createPrinter(Class<E> type, OutputStream out) {
        E printer = PrinterFactory.createPrinter(type);
        printer.setOut(out);
        return printer;
    }

    public static <E extends IPrinter> E createPrinter(Class<E> type) {
        try {
            return (E)((IPrinter)type.newInstance());
        }
        catch (InstantiationException e) {
            PPLogger.error(e);
            return null;
        }
        catch (IllegalAccessException e) {
            PPLogger.error(e);
            return null;
        }
    }
}

