/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.output.html;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.pp.output.HighlightingElement;
import gudusoft.gsqlparser.pp.output.html.HtmlOutputConfig;
import gudusoft.gsqlparser.pp.para.GFmtOpt;
import gudusoft.gsqlparser.pp.para.styleenums.TCompactMode;
import java.util.Arrays;
import java.util.regex.Pattern;

public class HtmlRenderUtil {
    private static final String RETURN_CODE = "\r\n";
    private HtmlOutputConfig config;
    private GFmtOpt option;
    private EDbVendor dbVendor;

    public HtmlRenderUtil(HtmlOutputConfig config, GFmtOpt option, EDbVendor dbVendor) {
        this.config = config;
        this.option = option;
        this.dbVendor = dbVendor;
    }

    public String renderToken(TSourceToken token) {
        boolean isLineBreak = false;
        String tokenString = token.astext;
        ETokenType type = token.tokentype;
        tokenString = tokenString.replaceAll(" ", "&nbsp;");
        tokenString = tokenString.replaceAll("\t", this.option.tabHtmlString);
        if (ETokenType.ttwhitespace.equals((Object)type)) {
            tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkSpan).render(tokenString);
        } else if (ETokenType.ttreturn.equals((Object)type)) {
            tokenString = tokenString.contains(RETURN_CODE) ? tokenString.replaceAll(RETURN_CODE, "\r\n</br>") : tokenString.replaceAll("\n", "\r\n</br>");
            tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkSpan).render(tokenString);
            isLineBreak = true;
        } else if (ETokenType.ttsimplecomment.equals((Object)type)) {
            tokenString = tokenString.replaceAll(Pattern.quote("--"), "&#45;&#45;");
            if (TCompactMode.Cpmugly.equals((Object)this.option.compactMode)) {
                tokenString = "/* " + tokenString + "*/";
            }
            tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkComment_dh).render(tokenString);
        } else if (ETokenType.ttbracketedcomment.equals((Object)type)) {
            tokenString = tokenString.contains(RETURN_CODE) ? tokenString.replaceAll(RETURN_CODE, "\r\n</br>") : tokenString.replaceAll("\n", "\r\n</br>");
            tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkComment_dh).render(tokenString);
        } else if (ETokenType.ttidentifier.equals((Object)type) || ETokenType.ttdqstring.equals((Object)type) || ETokenType.ttdbstring.equals((Object)type) || ETokenType.ttbrstring.equals((Object)type)) {
            if (ETokenType.ttdqstring.equals((Object)type) || ETokenType.ttdbstring.equals((Object)type)) {
                tokenString = tokenString.replaceAll("\"", "&quot;");
            }
            int dbObjType = token.getDbObjType();
            switch (dbObjType) {
                case 13: {
                    if (this.isVendorBuiltInFunction(tokenString, this.dbVendor)) {
                        tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkBuiltInFunction).render(tokenString);
                        break;
                    }
                    tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkFunction).render(tokenString);
                    break;
                }
                case 30: {
                    tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkDatatype).render(tokenString);
                    break;
                }
                default: {
                    if (EDbVendor.dbvmssql.equals((Object)this.dbVendor) && this.isMSSQLSystemVar(tokenString)) {
                        tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkMssqlsystemvar).render(tokenString);
                        break;
                    }
                    tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkIdentifer).render(tokenString);
                    break;
                }
            }
        } else if (ETokenType.ttnumber.equals((Object)type)) {
            tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkNumber).render(tokenString);
        } else if (ETokenType.ttsqstring.equals((Object)type)) {
            tokenString = tokenString.replaceAll("&nbsp;", " ");
            tokenString = tokenString.replaceAll("&", "&#38;");
            tokenString = tokenString.replaceAll(" ", "&nbsp;");
            tokenString = tokenString.replaceAll("\"", "&quot;");
            tokenString = (tokenString = tokenString.replaceAll("<", "&#60;")).contains(RETURN_CODE) ? tokenString.replaceAll(RETURN_CODE, "\r\n</br>") : tokenString.replaceAll("\n", "\r\n</br>");
            tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkSQString).render(tokenString);
        } else if (ETokenType.ttkeyword.equals((Object)type)) {
            int dbObjType = token.getDbObjType();
            switch (dbObjType) {
                case 13: {
                    if (this.isVendorBuiltInFunction(tokenString, this.dbVendor)) {
                        tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkBuiltInFunction).render(tokenString);
                        break;
                    }
                    tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkFunction).render(tokenString);
                    break;
                }
                case 30: {
                    tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkDatatype).render(tokenString);
                    break;
                }
                default: {
                    if (EDbVendor.dbvmssql.equals((Object)this.dbVendor) && this.isMSSQLSystemVar(tokenString)) {
                        tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkMssqlsystemvar).render(tokenString);
                        break;
                    }
                    tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkStandardkeyword).render(tokenString);
                    break;
                }
            }
        } else if (ETokenType.ttsqlvar.equals((Object)type)) {
            tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfksqlvar).render(tokenString);
        } else if (ETokenType.ttbindvar.equals((Object)type)) {
            tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkbindvar).render(tokenString);
        } else if (ETokenType.ttmulticharoperator.equals((Object)type)) {
            tokenString = tokenString.replaceAll("<", "&lt;");
            tokenString = tokenString.replaceAll(">", "&gt;");
            tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkSymbol).render(tokenString);
        } else if (ETokenType.ttsinglecharoperator.equals((Object)type)) {
            tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkSymbol).render(tokenString);
        } else if (ETokenType.ttcomma.equals((Object)type) || ETokenType.ttperiod.equals((Object)type) || ETokenType.ttsemicolon.equals((Object)type) || ETokenType.ttdolorsign.equals((Object)type) || ETokenType.ttcolon.equals((Object)type) || ETokenType.ttplussign.equals((Object)type) || ETokenType.ttminussign.equals((Object)type) || ETokenType.ttasterisk.equals((Object)type) || ETokenType.ttslash.equals((Object)type) || ETokenType.ttstmt_delimiter.equals((Object)type) || ETokenType.ttequals.equals((Object)type) || ETokenType.ttatsign.equals((Object)type) || ETokenType.ttsemicolon2.equals((Object)type) || ETokenType.ttsemicolon3.equals((Object)type) || ETokenType.ttquestionmark.equals((Object)type)) {
            tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkSymbol).render(tokenString);
        } else if (ETokenType.ttlessthan.equals((Object)type)) {
            tokenString = "&lt;";
            tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkSymbol).render(tokenString);
        } else if (ETokenType.ttgreaterthan.equals((Object)type)) {
            tokenString = "&gt;";
            tokenString = this.config.getHighlightingElementRender(HighlightingElement.sfkSymbol).render(tokenString);
        } else {
            tokenString = ETokenType.ttleftparenthesis.equals((Object)type) ? this.config.getHighlightingElementRender(HighlightingElement.sfkopenbracket).render(tokenString) : (ETokenType.ttrightparenthesis.equals((Object)type) ? this.config.getHighlightingElementRender(HighlightingElement.sfkclosebracket).render(tokenString) : (ETokenType.ttsqlpluscmd.equals((Object)type) ? this.config.getHighlightingElementRender(HighlightingElement.sfkOraclesqlplus).render(tokenString) : this.config.getHighlightingElementRender(HighlightingElement.sfkDefault).render(tokenString)));
        }
        if (TCompactMode.Cpmugly.equals((Object)this.option.compactMode) && isLineBreak) {
            tokenString = tokenString + RETURN_CODE;
        }
        return tokenString;
    }

    private boolean isMSSQLSystemVar(String tokenString) {
        return false;
    }

    private boolean isVendorBuiltInFunction(String funcName, EDbVendor dbVendor) {
        if (EDbVendor.dbvoracle.equals((Object)dbVendor)) {
            return this.isOracleBuiltInFunction(funcName);
        }
        if (EDbVendor.dbvmssql.equals((Object)dbVendor)) {
            return this.isMssqlBuiltInFunction(funcName);
        }
        if (EDbVendor.dbvmysql.equals((Object)dbVendor)) {
            return this.isMysqlBuiltInFunction(funcName);
        }
        return false;
    }

    private boolean isMysqlBuiltInFunction(String funcName) {
        String[] sysFuncNames = new String[]{"@@CONNECTIONS", "@@CPU_BUSY", "@@CURSOR_ROWS", "@@DATEFIRST", "@@DBTS", "@@ERROR", "@@FETCH_STATUS", "@@IDENTITY", "@@IDLE", "@@IO_BUSY", "@@LANGID", "@@LANGUAGE", "@@LOCK_TIMEOUT", "@@MAX_CONNECTIONS", "@@MAX_PRECISION", "@@NESTLEVEL", "@@OPTIONS", "@@PACKET_ERRORS", "@@PACK_RECEIVED", "@@PACK_SENT", "@@PROCID", "@@REMSERVER", "@@ROWCOUNT", "@@SERVERNAME", "@@SERVICENAME", "@@SPID", "@@TEXTSIZE", "@@TIMETICKS", "@@TOTAL_ERRORS", "@@TOTAL_READ", "@@TOTAL_WRITE", "@@TRANCOUNT", "@@VERSION", "ABS", "ACOS", "APP_NAME", "ASCII", "ASIN", "ATAN", "ATN2", "AVG", "BINARY_CHECKSUM", "CASE", "CAST", "CEILING", "CHAR", "CHARINDEX", "CHECKSUM", "CHECKSUM_AGG", "COALESCE", "COLLATIONPROPERTY", "COLUMNPROPERTY", "COL_LENGTH", "COL_NAME", "CONTAINSTABLE", "CONVERT", "COS", "COT", "COUNT", "COUNT_BIG", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR_STATUS", "DATABASEPROPERTY", "DATABASEPROPERTYEX", "DATALENGTH", "DATEADD", "DATEDIFF", "DATENAME", "DATEPART", "DAY", "DB_ID", "DB_NAME", "DEGREES", "DIFFERENCE", "EXP", "FILEGROUPPROPERTY", "FILEGROUP_ID", "FILEGROUP_NAME", "FILEPROPERTY", "FILE_ID", "FILE_NAME", "FLOOR", "FN_HELPCOLLATIONS", "FN_LISTEXTENDEDPROPERTY", "FN_SERVERSHAREDDRIVES", "FN_TRACE_GETEVENTINFO", "FN_TRACE_GETFILTERINFO", "FN_TRACE_GETINFO", "FN_TRACE_GETTABLE", "FN_VIRTUALFILESTATS", "FN_VIRTUALFILESTATS", "FORMATMESSAGE", "FREETEXTTABLE", "FULLTEXTCATALOGPROPERTY", "FULLTEXTSERVICEPROPERTY", "GETANSINULL", "GETDATE", "GETUTCDATE", "GROUPING", "HAS_DBACCESS", "HOST_ID", "HOST_NAME", "IDENTITY", "IDENT_CURRENT", "IDENT_INCR", "IDENT_SEED", "INDEXKEY_PROPERTY", "INDEXPROPERTY", "INDEX_COL", "ISDATE", "ISNULL", "ISNUMERIC", "IS_MEMBER", "IS_SRVROLEMEMBER", "LEFT", "LEN", "LOG", "LOG10", "LOWER", "LTRIM", "MAX", "MIN", "MONTH", "NCHAR", "NEWID", "NULLIF", "OBJECTPROPERTY", "OBJECT_ID", "OBJECT_NAME", "OPENDATASOURCE", "OPENQUERY", "OPENROWSET", "OPENXML", "PARSENAME", "PATINDEX", "PATINDEX", "PERMISSIONS", "PI", "POWER", "QUOTENAME", "RADIANS", "RAND", "REPLACE", "REPLICATE", "REVERSE", "RIGHT", "ROUND", "ROWCOUNT_BIG", "RTRIM", "SCOPE_IDENTITY", "SERVERPROPERTY", "SESSIONPROPERTY", "SESSION_USER", "SIGN", "SIN", "SOUNDEX", "SPACE", "SQL_VARIANT_PROPERTY", "SQRT", "SQUARE", "STATS_DATE", "STDEV", "STDEVP", "STR", "STUFF", "SUBSTRING", "SUM", "SUSER_SID", "SUSER_SNAME", "SYSTEM_USER", "TAN", "TEXTPTR", "TEXTVALID", "TYPEPROPERTY", "UNICODE", "UPPER", "USER", "USER_ID", "USER_NAME", "VAR", "VARP", "YEAR"};
        return Arrays.asList(sysFuncNames).contains(funcName.toUpperCase());
    }

    private boolean isMssqlBuiltInFunction(String funcName) {
        return false;
    }

    private boolean isOracleBuiltInFunction(String funcName) {
        return false;
    }
}

