/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.output.html;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.pp.output.HighlightingElement;
import gudusoft.gsqlparser.pp.output.HighlightingElementRender;
import gudusoft.gsqlparser.pp.output.OutputConfig;
import gudusoft.gsqlparser.pp.output.html.HtmlHighlightingElementRender;
import gudusoft.gsqlparser.pp.output.html.HtmlRenderUtil;
import gudusoft.gsqlparser.pp.para.GFmtOpt;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;

public class HtmlOutputConfig
implements OutputConfig {
    private String globalFontName = "Courier New";
    private int globalFontSize = 10;
    private Map<HighlightingElement, HighlightingElementRender> highlightingElementMap = new HashMap<HighlightingElement, HighlightingElementRender>();
    private HtmlRenderUtil render;
    private boolean init = false;

    private void init() {
        this.init = true;
        Font plainFont = new Font(this.globalFontName, 0, this.globalFontSize);
        Font boldFont = new Font(this.globalFontName, 1, this.globalFontSize);
        Font italicFont = new Font(this.globalFontName, 2, this.globalFontSize);
        Color color_800000 = new Color(128, 0, 0);
        Color color_0000FF = new Color(0, 0, 255);
        Color color_000000 = new Color(0, 0, 0);
        Color color_C0C0C0 = new Color(192, 192, 192);
        Color color_FF0080 = new Color(255, 0, 128);
        Color color_16711935 = new Color(0xFF00FF);
        Color color_16711808 = new Color(0xFF0080);
        Color color_FF0000 = new Color(255, 0, 0);
        Color color_008000 = new Color(0, 128, 0);
        this.addHighlightingElementRender(HighlightingElement.sfkSpan, new HtmlHighlightingElementRender(HighlightingElement.sfkSpan, Color.WHITE, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkDefault, new HtmlHighlightingElementRender(HighlightingElement.sfkDefault, Color.BLACK, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkIdentifer, new HtmlHighlightingElementRender(HighlightingElement.sfkIdentifer, color_800000, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkStandardkeyword, new HtmlHighlightingElementRender(HighlightingElement.sfkStandardkeyword, color_0000FF, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkNumber, new HtmlHighlightingElementRender(HighlightingElement.sfkNumber, color_000000, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkDelimitedIdentifier, new HtmlHighlightingElementRender(HighlightingElement.sfkDelimitedIdentifier, color_800000, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkSymbol, new HtmlHighlightingElementRender(HighlightingElement.sfkSymbol, color_C0C0C0, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkFunction, new HtmlHighlightingElementRender(HighlightingElement.sfkFunction, color_FF0080, boldFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkBuiltInFunction, new HtmlHighlightingElementRender(HighlightingElement.sfkBuiltInFunction, color_16711935, italicFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkDatatype, new HtmlHighlightingElementRender(HighlightingElement.sfkDatatype, Color.BLACK, italicFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkParameter, new HtmlHighlightingElementRender(HighlightingElement.sfkParameter, color_800000, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkbindvar, new HtmlHighlightingElementRender(HighlightingElement.sfkbindvar, color_800000, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkVendordbkeyword, new HtmlHighlightingElementRender(HighlightingElement.sfkVendordbkeyword, color_0000FF, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkSQString, new HtmlHighlightingElementRender(HighlightingElement.sfkSQString, color_FF0000, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkDQString, new HtmlHighlightingElementRender(HighlightingElement.sfkDQString, color_FF0000, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkComment_dh, new HtmlHighlightingElementRender(HighlightingElement.sfkComment_dh, color_008000, italicFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkComment_ss, new HtmlHighlightingElementRender(HighlightingElement.sfkComment_ss, color_008000, italicFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkComment_sign, new HtmlHighlightingElementRender(HighlightingElement.sfkComment_sign, color_008000, italicFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkMssqlsystemvar, new HtmlHighlightingElementRender(HighlightingElement.sfkMssqlsystemvar, color_16711935, italicFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfksqlvar, new HtmlHighlightingElementRender(HighlightingElement.sfksqlvar, color_16711808, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkMssqlst1, new HtmlHighlightingElementRender(HighlightingElement.sfkMssqlst1, color_16711808, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkMssqlst2, new HtmlHighlightingElementRender(HighlightingElement.sfkMssqlst2, color_16711808, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkMssqlst3, new HtmlHighlightingElementRender(HighlightingElement.sfkMssqlst3, color_16711808, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkOracleplsqlkeyword, new HtmlHighlightingElementRender(HighlightingElement.sfkOracleplsqlkeyword, color_800000, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkOraclepackage, new HtmlHighlightingElementRender(HighlightingElement.sfkOraclepackage, color_800000, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkOraclecommand, new HtmlHighlightingElementRender(HighlightingElement.sfkOraclecommand, color_800000, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkOracleplsqlmethod, new HtmlHighlightingElementRender(HighlightingElement.sfkOracleplsqlmethod, color_800000, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkOraclerem, new HtmlHighlightingElementRender(HighlightingElement.sfkOraclerem, color_800000, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkOraclesqlplus, new HtmlHighlightingElementRender(HighlightingElement.sfkOraclesqlplus, color_800000, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkSybasesystemobj, new HtmlHighlightingElementRender(HighlightingElement.sfkSybasesystemobj, color_800000, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkSybasest, new HtmlHighlightingElementRender(HighlightingElement.sfkSybasest, color_800000, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkSybaseglobalvar, new HtmlHighlightingElementRender(HighlightingElement.sfkSybaseglobalvar, color_800000, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkopenbracket, new HtmlHighlightingElementRender(HighlightingElement.sfkopenbracket, color_800000, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkclosebracket, new HtmlHighlightingElementRender(HighlightingElement.sfkclosebracket, color_800000, plainFont), false);
        this.addHighlightingElementRender(HighlightingElement.sfkUserCustomized, new HtmlHighlightingElementRender(HighlightingElement.sfkUserCustomized, color_800000, plainFont), false);
    }

    public HtmlOutputConfig(GFmtOpt option, EDbVendor dbVendor) {
        this.render = new HtmlRenderUtil(this, option, dbVendor);
    }

    @Override
    public void addHighlightingElementRender(HighlightingElement element, HighlightingElementRender setting) {
        this.addHighlightingElementRender(element, setting, true);
    }

    private void addHighlightingElementRender(HighlightingElement element, HighlightingElementRender setting, boolean override) {
        if (override) {
            this.highlightingElementMap.put(element, setting);
        } else if (!this.highlightingElementMap.containsKey((Object)element)) {
            this.highlightingElementMap.put(element, setting);
        }
    }

    @Override
    public boolean containsHighlightingElementRender(HighlightingElement element) {
        return this.highlightingElementMap.containsKey((Object)element);
    }

    public String getGlobalFontName() {
        return this.globalFontName;
    }

    public int getGlobalFontSize() {
        return this.globalFontSize;
    }

    @Override
    public HighlightingElementRender getHighlightingElementRender(HighlightingElement element) {
        return this.highlightingElementMap.get((Object)element);
    }

    @Override
    public void removeHighlightingElementRender(HighlightingElement element) {
        this.highlightingElementMap.remove((Object)element);
    }

    public void setGlobalFontName(String globalFontName) {
        this.globalFontName = globalFontName;
    }

    public void setGlobalFontSize(int globalFontSize) {
        this.globalFontSize = globalFontSize;
    }

    @Override
    public String renderHighlightingElement(TSourceToken token) {
        if (!this.init) {
            this.init();
        }
        return this.render.renderToken(token);
    }
}

