/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.output.html;

import gudusoft.gsqlparser.pp.output.HighlightingElement;
import gudusoft.gsqlparser.pp.output.HighlightingElementRender;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;

public class HtmlHighlightingElementRender
implements HighlightingElementRender {
    private Color backgroundColor;
    private HighlightingElement element;
    private String fontName;
    private int fontSize;
    private int fontStyle;
    private Color foregroundColor;
    private boolean strikeOut;
    private boolean underLine;

    public HtmlHighlightingElementRender(HighlightingElement element) {
        this.element = element;
    }

    public HtmlHighlightingElementRender(HighlightingElement element, Font font) {
        this.element = element;
        this.fontSize = font.getSize();
        this.fontStyle = font.getStyle();
        this.fontName = font.getName();
        this.underLine = TextAttribute.UNDERLINE_ON.equals(font.getAttributes().get(TextAttribute.UNDERLINE));
        this.strikeOut = TextAttribute.STRIKETHROUGH_ON.equals(font.getAttributes().get(TextAttribute.STRIKETHROUGH));
        this.foregroundColor = (Color)font.getAttributes().get(TextAttribute.FOREGROUND);
        this.backgroundColor = (Color)font.getAttributes().get(TextAttribute.BACKGROUND);
    }

    public HtmlHighlightingElementRender(HighlightingElement element, Color color, Font font, boolean underLine, boolean strikeOut) {
        this.element = element;
        this.fontSize = font.getSize();
        this.fontStyle = font.getStyle();
        this.fontName = font.getName();
        this.underLine = underLine;
        this.strikeOut = strikeOut;
        this.foregroundColor = color;
    }

    public HtmlHighlightingElementRender(HighlightingElement element, Color color, Font font) {
        this.element = element;
        this.fontSize = font.getSize();
        this.fontStyle = font.getStyle();
        this.fontName = font.getName();
        this.foregroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public HighlightingElement getElement() {
        return this.element;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public boolean isStrikeOut() {
        return this.strikeOut;
    }

    public boolean isUnderLine() {
        return this.underLine;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public void setStrikeOut(boolean strikeOut) {
        this.strikeOut = strikeOut;
    }

    public void setUnderLine(boolean underLine) {
        this.underLine = underLine;
    }

    @Override
    public String render(String tokenText) {
        StringBuffer buffer = new StringBuffer();
        if (this.fontName != null) {
            buffer.append("font-family:").append(this.fontName).append(";");
        }
        if (this.fontSize != 0) {
            buffer.append("font-size:").append(this.fontSize).append("pt;");
        }
        if (this.fontStyle == 2) {
            buffer.append("font-sytle:italic;");
        }
        if (this.fontStyle == 1) {
            buffer.append("font-weight:bold;");
        }
        if (this.isUnderLine()) {
            buffer.append("text-decoration: underline;");
        }
        if (this.isStrikeOut()) {
            buffer.append("text-decoration: line-through;");
        }
        if (this.foregroundColor != null) {
            buffer.append("color: " + HtmlHighlightingElementRender.color2String(this.foregroundColor) + ";");
        }
        if (this.backgroundColor != null) {
            buffer.append("background-color: " + HtmlHighlightingElementRender.color2String(this.backgroundColor) + ";");
        }
        return "<span style=\"" + buffer.toString() + "\">" + tokenText + "</span>";
    }

    public static String color2String(Color color) {
        String R = Integer.toHexString(color.getRed());
        R = R.length() < 2 ? '0' + R : R;
        String B = Integer.toHexString(color.getBlue());
        B = B.length() < 2 ? '0' + B : B;
        String G = Integer.toHexString(color.getGreen());
        G = G.length() < 2 ? '0' + G : G;
        return '#' + R + G + B;
    }
}

