/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.mediator.type;

import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.pp.mediator.type.AbstractMediator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeywordAlignMediator
extends AbstractMediator {
    private int curLevel = 0;
    private Map<Integer, List<IndentLevelItem>> indentLevels = new HashMap<Integer, List<IndentLevelItem>>();

    public void addIndentLevelItem(TSourceToken token, int curIndentLen) {
        if (!this.indentLevels.containsKey(this.curLevel)) {
            this.indentLevels.put(this.curLevel, new ArrayList());
        }
        List<IndentLevelItem> indentLevel = this.indentLevels.get(this.curLevel);
        indentLevel.add(new IndentLevelItem(this.curLevel, curIndentLen, token));
    }

    public int getCurLevelIndentLen() {
        if (this.indentLevels.containsKey(this.curLevel)) {
            List<IndentLevelItem> indentLevel = this.indentLevels.get(this.curLevel);
            int maxlen = 0;
            for (IndentLevelItem item : indentLevel) {
                if (item.getIndentLen() <= maxlen) continue;
                maxlen = item.getIndentLen();
            }
            return maxlen;
        }
        return 0;
    }

    public int getLevelIndentLen(int level) {
        if (this.indentLevels.containsKey(level)) {
            List<IndentLevelItem> indentLevel = this.indentLevels.get(level);
            int maxlen = 0;
            for (IndentLevelItem item : indentLevel) {
                if (item.getIndentLen() <= maxlen) continue;
                maxlen = item.getIndentLen();
            }
            return maxlen;
        }
        return 0;
    }

    public int getCurrentIndentLevel() {
        return this.curLevel;
    }

    public void increaseLevel() {
        ++this.curLevel;
    }

    public void decreaseLevel() {
        if (this.indentLevels.get(this.curLevel) != null) {
            this.indentLevels.get(this.curLevel).clear();
        }
        --this.curLevel;
    }

    public static class IndentLevelItem {
        private int level;
        private int indentLen;
        private TSourceToken token;

        public IndentLevelItem() {
        }

        public IndentLevelItem(int level, int indentLen, TSourceToken token) {
            this.level = level;
            this.indentLen = indentLen;
            this.token = token;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public int getIndentLen() {
            return this.indentLen;
        }

        public void setIndentLen(int indentLen) {
            this.indentLen = indentLen;
        }

        public TSourceToken getToken() {
            return this.token;
        }

        public void setToken(TSourceToken token) {
            this.token = token;
        }
    }
}

