/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.logger;

import gudusoft.gsqlparser.pp.logger.PPLogger;

public class PPLoggerRecord {
    private String className;
    private String methodName;
    private String fileName;
    private Throwable e;
    private int logLevel;
    private int stackLevel;
    private int lineNum;
    private String msg;

    public PPLoggerRecord(int logLevel, String msg, Throwable e) {
        this(logLevel, 0, msg, e);
    }

    public PPLoggerRecord(int logLevel, int stackLevel, String msg, Throwable e) {
        this.logLevel = logLevel;
        this.stackLevel = stackLevel;
        this.msg = msg;
        this.e = e;
        this.inferCaller();
    }

    private void inferCaller() {
        StackTraceElement frame;
        String cname;
        int ix;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (ix = 0; ix < stack.length && !(cname = (frame = stack[ix]).getClassName()).equals(PPLogger.class.getName()); ++ix) {
        }
        ix += this.stackLevel;
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals(PPLogger.class.getName())) {
                this.className = cname;
                this.methodName = frame.getMethodName();
                this.lineNum = frame.getLineNumber();
                this.fileName = frame.getFileName();
                return;
            }
            ++ix;
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getStackLevel() {
        return this.stackLevel;
    }

    public String getMsg() {
        return this.msg;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public Throwable getE() {
        return this.e;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public String getFileName() {
        return this.fileName;
    }
}

