/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.logger;

import gudusoft.gsqlparser.pp.logger.PPLoggerRecord;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PPLogger {
    public static final int OFF = 0;
    public static final int INFO = 300;
    public static final int ERROR = 100;
    public static int currLogLevel = 0;
    private static PPLogger logger = new PPLogger();

    public static void error(Throwable e) {
        logger.doLog(new PPLoggerRecord(100, null, e));
    }

    public static void info(Throwable e) {
        PPLogger.info(null, e);
    }

    public static void info(String msg) {
        PPLogger.info(msg, null);
    }

    public static void info(String msg, Throwable e) {
        PPLogger.info(0, msg, null);
    }

    public static void info(int stackLevel, String msg, Throwable e) {
        logger.doLog(new PPLoggerRecord(300, stackLevel, msg, e));
    }

    private void doLog(PPLoggerRecord record) {
        if (currLogLevel == 0) {
            return;
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        if (currLogLevel >= record.getLogLevel()) {
            StringBuilder buf = new StringBuilder();
            buf.append(fmt.format(new Date()));
            switch (record.getLogLevel()) {
                case 100: {
                    buf.append(" ERROR: ");
                    break;
                }
                case 300: {
                    buf.append(" INFO: ");
                }
            }
            buf.append(record.getClassName()).append(".").append(record.getMethodName()).append("(").append(record.getFileName()).append(":").append(record.getLineNum()).append(")");
            if (record.getMsg() != null) {
                buf.append("\n").append(record.getMsg());
            }
            System.err.println(buf);
            if (record.getE() != null) {
                record.getE().printStackTrace();
            }
            System.err.print("\n");
        }
    }
}

