/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes.teradata;

import gudusoft.gsqlparser.EDbObjectType;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ETableSource;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.nodes.TConstant;
import gudusoft.gsqlparser.nodes.TConstantList;
import gudusoft.gsqlparser.nodes.TFromTable;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TTable;

public class TTDUnpivot
extends TParseTreeNode {
    private TFromTable onTableRef;
    private TConstantList valueColumnsInString;
    private TConstantList unpivotColumnsInString;
    private TConstantList columnListInString;
    private TConstantList columnAliasListInString;
    private TTable unPivotTable;
    private TObjectNameList valueColumns = new TObjectNameList();
    private TObjectNameList unpivotColumns = new TObjectNameList();
    private TObjectNameList columnList = new TObjectNameList();

    public TObjectNameList getColumnList() {
        return this.columnList;
    }

    public TObjectNameList getUnpivotColumns() {
        return this.unpivotColumns;
    }

    public TTable getUnPivotTable() {
        return this.unPivotTable;
    }

    public TConstantList getColumnAliasListInString() {
        return this.columnAliasListInString;
    }

    public TConstantList getColumnListInString() {
        return this.columnListInString;
    }

    public TConstantList getUnpivotColumnsInString() {
        return this.unpivotColumnsInString;
    }

    public TConstantList getValueColumnsInString() {
        return this.valueColumnsInString;
    }

    @Override
    public void doParse(TCustomSqlStatement psql, ESqlClause plocation) {
        TObjectName nc;
        TConstant c;
        int i;
        TTable refTable = this.unPivotTable = psql.analyzeFromTable(this.onTableRef, true);
        if (this.unPivotTable.getTableType() == ETableSource.subquery) {
            refTable = this.unPivotTable.getSubquery().getTables().getTable(0);
        }
        for (i = 0; i < this.valueColumnsInString.size(); ++i) {
            c = this.valueColumnsInString.getConstant(i);
            nc = new TObjectName(c.getValueToken(), EDbObjectType.column);
            this.valueColumns.addObjectName(nc);
            refTable.getLinkedColumns().addObjectName(nc);
            nc.setSourceTable(refTable);
        }
        for (i = 0; i < this.unpivotColumnsInString.size(); ++i) {
            c = this.unpivotColumnsInString.getConstant(i);
            nc = new TObjectName(c.getValueToken(), EDbObjectType.column);
            this.unpivotColumns.addObjectName(nc);
            refTable.getLinkedColumns().addObjectName(nc);
            nc.setSourceTable(refTable);
        }
        for (i = 0; i < this.columnListInString.size(); ++i) {
            c = this.columnListInString.getConstant(i);
            nc = new TObjectName(c.getValueToken(), EDbObjectType.column);
            this.columnList.addObjectName(nc);
            refTable.getLinkedColumns().addObjectName(nc);
            nc.setSourceTable(refTable);
        }
    }

    @Override
    public void init(Object arg1, Object arg2, Object arg3, Object arg4) {
        this.onTableRef = (TFromTable)arg1;
        this.valueColumnsInString = (TConstantList)arg2;
        this.unpivotColumnsInString = (TConstantList)arg3;
        this.columnListInString = (TConstantList)arg4;
    }

    @Override
    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        this.init(arg1, arg2, arg3, arg4);
        this.columnAliasListInString = (TConstantList)arg5;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }
}

