/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes.dax;

import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.dax.TDaxFunction;
import gudusoft.gsqlparser.nodes.dax.TDaxVar;

public class TDaxReturn
extends TDaxFunction {
    private TPTNodeList<TDaxVar> variables;
    private TExpression returnExpr;

    @Override
    public void init(Object arg1, Object arg2, Object arg3, Object arg4) {
        this.init(arg1, arg2, arg3);
        this.variables = (TPTNodeList)arg4;
    }

    @Override
    public void init(Object arg1, Object arg2, Object arg3) {
        this.init(arg1, arg2);
        this.returnExpr = (TExpression)arg3;
    }

    @Override
    public void doParse(TCustomSqlStatement psql, ESqlClause plocation) {
        int i;
        psql.getDaxFunctionStack().push(this);
        if (this.variables != null) {
            for (i = 0; i < this.variables.size(); ++i) {
                if (this.variables.getElement(i).getVariableName() == null) continue;
                psql.getVariableStack().push(this.variables.getElement(i).getVariableName());
            }
        }
        this.returnExpr.doParse(psql, plocation);
        this.setReturnTable(this.getDefaultTable());
        if (this.variables != null) {
            for (i = 0; i < this.variables.size(); ++i) {
                this.variables.getElement(i).doParse(psql, plocation);
            }
        }
        if (this.variables != null) {
            for (i = 0; i < this.variables.size(); ++i) {
                if (this.variables.getElement(i).getVariableName() == null) continue;
                psql.getVariableStack().pop();
            }
        }
        psql.getDaxFunctionStack().pop();
        if (this.getReturnTable() != null && psql.getDaxFunctionStack().size() > 0) {
            TDaxFunction function = psql.getDaxFunctionStack().peek();
            function.setDefaultTable(this.getReturnTable());
        }
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    public void setVariables(TPTNodeList<TDaxVar> variables) {
        this.variables = variables;
    }

    public void setReturnExpr(TExpression returnExpr) {
        this.returnExpr = returnExpr;
    }

    public TPTNodeList<TDaxVar> getVariables() {
        return this.variables;
    }

    public TExpression getReturnExpr() {
        return this.returnExpr;
    }
}

