/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes.dax;

import gudusoft.gsqlparser.EDbObjectType;
import gudusoft.gsqlparser.EExpressionType;
import gudusoft.gsqlparser.EFunctionType;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TExpressionList;
import gudusoft.gsqlparser.nodes.TFunctionCall;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.nodes.dax.TDaxNameExpression;
import gudusoft.gsqlparser.nodes.dax.TDaxOrderByExpr;
import gudusoft.gsqlparser.stmt.dax.TDaxStmt;

public class TDaxFunction
extends TFunctionCall {
    private TTable returnTable;
    private TObjectName columnName;
    private TPTNodeList<TDaxOrderByExpr> orderByExprList;
    private TPTNodeList<TDaxNameExpression> nameValues;
    private TExpression expr;
    private TObjectNameList columnNameList;
    private TExpression tableExpr;
    private TObjectName tableName;
    private TTable defaultTable = null;

    public TTable getReturnTable() {
        return this.returnTable;
    }

    public TObjectName getColumnName() {
        return this.columnName;
    }

    public TPTNodeList<TDaxOrderByExpr> getOrderByExprList() {
        return this.orderByExprList;
    }

    public TPTNodeList<TDaxNameExpression> getNameValues() {
        return this.nameValues;
    }

    public void setNameValues(TPTNodeList<TDaxNameExpression> nameValues) {
        this.nameValues = nameValues;
    }

    @Override
    public void init(Object arg1, Object arg2) {
        super.init(arg1, arg2);
        if (this.getFunctionType() == EFunctionType.builtin_t) {
            if (this.getFunctionName().toString().equalsIgnoreCase("distinct")) {
                this.setFunctionType(EFunctionType.distinct_t);
            } else if (this.getFunctionName().toString().equalsIgnoreCase("crossjoin")) {
                this.setFunctionType(EFunctionType.crossjoin_t);
            }
        }
    }

    @Override
    public void init(Object arg1, Object arg2, Object arg3) {
        this.init(arg1, arg2);
        switch (this.getFunctionType()) {
            case all_t: {
                if (arg3 instanceof TExpression) {
                    this.tableExpr = (TExpression)arg3;
                    break;
                }
                if (!(arg3 instanceof TObjectNameList)) break;
                this.columnNameList = (TObjectNameList)arg3;
                break;
            }
            case allnoblankrow_t: 
            case allselected_t: {
                if (arg3 instanceof TExpression) {
                    this.tableExpr = (TExpression)arg3;
                    break;
                }
                if (!(arg3 instanceof TObjectName)) break;
                this.columnName = (TObjectName)arg3;
                break;
            }
            case crossfilter_t: {
                this.columnNameList = (TObjectNameList)arg3;
                break;
            }
            case relatedtable_t: {
                this.tableName = (TObjectName)arg3;
                break;
            }
            case values_t: {
                TObjectName objectName = (TObjectName)arg3;
                if (objectName.getDbObjectType() == EDbObjectType.table) {
                    this.tableName = objectName;
                    break;
                }
                this.columnName = objectName;
                break;
            }
            case rollupaddissubtotal_t: {
                this.setArgs((TExpressionList)arg3);
                break;
            }
            case rollupgroup_t: {
                this.columnNameList = (TObjectNameList)arg3;
                break;
            }
            case row_t: {
                this.nameValues = (TPTNodeList)arg3;
                break;
            }
        }
    }

    @Override
    public void init(Object arg1, Object arg2, Object arg3, Object arg4) {
        this.init(arg1, arg2);
        switch (this.getFunctionType()) {
            case minx_t: 
            case maxx_t: 
            case sumx_t: 
            case filter_t: 
            case stdevx_s_t: 
            case stdevx_p_t: 
            case varx_p_t: 
            case varx_s_t: 
            case concatenatex_t: {
                this.tableExpr = (TExpression)arg3;
                this.expr = (TExpression)arg4;
                break;
            }
            case allexcept_t: {
                this.tableExpr = (TExpression)arg3;
                this.columnNameList = (TObjectNameList)arg4;
                break;
            }
            case addcolumns_t: 
            case selectcolumns_t: {
                this.tableExpr = (TExpression)arg3;
                this.nameValues = (TPTNodeList)arg4;
                break;
            }
        }
    }

    @Override
    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        this.init(arg1, arg2);
        switch (this.getFunctionType()) {
            case sample_t: 
            case topn_t: {
                this.expr = (TExpression)arg3;
                this.tableExpr = (TExpression)arg4;
                this.orderByExprList = (TPTNodeList)arg5;
            }
        }
    }

    public TObjectName getTableName() {
        return this.tableName;
    }

    public TExpression getExpr() {
        return this.expr;
    }

    public void setColumnNameList(TObjectNameList columnNameList) {
        this.columnNameList = columnNameList;
    }

    public void setReturnTable(TTable returnTable) {
        this.returnTable = returnTable;
    }

    public TObjectNameList getColumnNameList() {
        return this.columnNameList;
    }

    public TExpression getTableExpr() {
        return this.tableExpr;
    }

    public void setTableName(TObjectName tableName) {
        this.tableName = tableName;
    }

    public void setDefaultTable(TTable defaultTable) {
        this.defaultTable = defaultTable;
    }

    public TTable getDefaultTable() {
        return this.defaultTable;
    }

    public void setTableExpr(TExpression tableExpr) {
        this.tableExpr = tableExpr;
    }

    TTable parseTableExpr(TExpression pTableExpr, TCustomSqlStatement psql, ESqlClause plocation, boolean addToDefault) {
        if (pTableExpr.getExpressionType() == EExpressionType.simple_object_name_t) {
            TTable lcTable = new TTable(pTableExpr.getObjectOperand());
            psql.addToTables(lcTable);
            if (addToDefault) {
                this.setDefaultTable(lcTable);
            }
            return lcTable;
        }
        pTableExpr.getFunctionCall().doParse(psql, plocation);
        if (((TDaxFunction)pTableExpr.getFunctionCall()).getReturnTable() != null) {
            return ((TDaxFunction)pTableExpr.getFunctionCall()).getReturnTable();
        }
        return ((TDaxFunction)pTableExpr.getFunctionCall()).getDefaultTable();
    }

    TTable parseTableName(TObjectName pTableName, TCustomSqlStatement psql, ESqlClause plocation) {
        TTable lcTable = new TTable(pTableName);
        psql.addToTables(lcTable);
        if (this.getDefaultTable() == null) {
            this.setDefaultTable(lcTable);
        }
        return lcTable;
    }

    void parseExpr(TExpression pExpr, TCustomSqlStatement psql, ESqlClause plocation, boolean pReturnTable) {
        switch (pExpr.getExpressionType()) {
            case simple_object_name_t: {
                if (psql.searchDaxVariableInStack(pExpr.getObjectOperand())) break;
                if (pExpr.getObjectOperand().getDbObjectType() == EDbObjectType.table) {
                    this.tableName = pExpr.getObjectOperand();
                    if (pReturnTable) {
                        this.returnTable = this.parseTableName(this.tableName, psql, plocation);
                        break;
                    }
                    this.parseTableName(this.tableName, psql, plocation);
                    break;
                }
                psql.linkColumnToTable(pExpr.getObjectOperand(), plocation);
                break;
            }
            default: {
                pExpr.doParse(psql, plocation);
            }
        }
    }

    void parseColumnExpr(TExpression pExpr, TCustomSqlStatement psql, ESqlClause plocation) {
        switch (pExpr.getExpressionType()) {
            case simple_object_name_t: {
                if (pExpr.getObjectOperand().getDbObjectType() != EDbObjectType.column) break;
                psql.linkColumnToTable(pExpr.getObjectOperand(), plocation);
                break;
            }
            case function_t: {
                pExpr.getFunctionCall().doParse(psql, plocation);
                break;
            }
            default: {
                pExpr.doParse(psql, plocation);
            }
        }
    }

    void parseArgs(TExpressionList pArgs, TCustomSqlStatement psql, ESqlClause plocation, boolean pReturnTable) {
        if (pArgs == null) {
            return;
        }
        for (int i = 0; i < pArgs.size(); ++i) {
            TExpression expr = pArgs.getExpression(i);
            this.parseExpr(expr, psql, plocation, pReturnTable);
        }
    }

    @Override
    public void doParse(TCustomSqlStatement psql, ESqlClause plocation) {
        Object lcTable = null;
        psql.getDaxFunctionStack().push(this);
        switch (this.getFunctionType()) {
            case builtin_t: {
                this.parseArgs(this.getArgs(), psql, plocation, false);
                break;
            }
            case calculatetable_t: {
                this.parseArgs(this.getArgs(), psql, plocation, true);
                this.returnTable = this.getDefaultTable();
                break;
            }
            case minx_t: 
            case maxx_t: 
            case sumx_t: 
            case stdevx_s_t: 
            case stdevx_p_t: 
            case varx_p_t: 
            case varx_s_t: 
            case concatenatex_t: {
                this.parseTableExpr(this.tableExpr, psql, plocation, true);
                this.expr.doParse(psql, plocation);
                break;
            }
            case all_t: {
                int i;
                if (this.getTableExpr() != null) {
                    this.returnTable = this.parseTableExpr(this.tableExpr, psql, plocation, true);
                    break;
                }
                for (i = 0; i < this.getColumnNameList().size(); ++i) {
                    psql.linkColumnToTable(this.getColumnNameList().getObjectName(i), plocation);
                }
                break;
            }
            case allexcept_t: {
                int i;
                this.parseTableExpr(this.tableExpr, psql, plocation, true);
                for (i = 0; i < this.getColumnNameList().size(); ++i) {
                    psql.linkColumnToTable(this.getColumnNameList().getObjectName(i), plocation);
                }
                break;
            }
            case allnoblankrow_t: 
            case allselected_t: {
                if (this.getTableExpr() != null) {
                    this.parseTableExpr(this.tableExpr, psql, plocation, true);
                }
                if (this.getColumnName() == null) break;
                psql.linkColumnToTable(this.getColumnName(), plocation);
                break;
            }
            case crossfilter_t: {
                int i;
                for (i = 0; i < this.getColumnNameList().size(); ++i) {
                    psql.linkColumnToTable(this.getColumnNameList().getObjectName(i), plocation);
                }
                break;
            }
            case relatedtable_t: {
                this.returnTable = this.parseTableName(this.tableName, psql, plocation);
                break;
            }
            case values_t: {
                if (this.columnName != null) {
                    psql.linkColumnToTable(this.columnName, plocation);
                    if (this.getDefaultTable() == null) break;
                    this.returnTable = this.getDefaultTable();
                    break;
                }
                if (this.tableName == null) break;
                this.returnTable = this.parseTableName(this.tableName, psql, plocation);
                break;
            }
            case filter_t: {
                this.returnTable = this.parseTableExpr(this.tableExpr, psql, plocation, true);
                this.expr.doParse(psql, plocation);
                break;
            }
            case rollupaddissubtotal_t: {
                this.parseArgs(this.getArgs(), psql, plocation, false);
                break;
            }
            case rollupgroup_t: {
                int i;
                for (i = 0; i < this.getColumnNameList().size(); ++i) {
                    psql.linkColumnToTable(this.getColumnNameList().getObjectName(i), plocation);
                }
                break;
            }
            case addcolumns_t: 
            case selectcolumns_t: {
                int i;
                this.returnTable = this.parseTableExpr(this.tableExpr, psql, plocation, true);
                for (i = 0; i < this.getNameValues().size(); ++i) {
                    this.getReturnTable().getLinkedColumns().addObjectName(this.getNameValues().getElement(i).getColumnName());
                    this.getNameValues().getElement(i).getValueExpr().doParse(psql, plocation);
                }
                break;
            }
            case row_t: {
                int i;
                for (i = 0; i < this.getNameValues().size(); ++i) {
                    psql.linkColumnToTable(this.getNameValues().getElement(i).getColumnName(), plocation);
                    this.getNameValues().getElement(i).getValueExpr().doParse(psql, plocation);
                }
                break;
            }
            case sample_t: 
            case topn_t: {
                int i;
                this.returnTable = this.parseTableExpr(this.tableExpr, psql, plocation, true);
                this.expr.doParse(psql, plocation);
                for (i = 0; i < this.getOrderByExprList().size(); ++i) {
                    this.getOrderByExprList().getElement(i).getOrderByExpr().doParse(psql, plocation);
                }
                break;
            }
            case calculate_t: {
                int i;
                if (this.getArgs().size() > 1) {
                    for (i = 1; i < this.getArgs().size(); ++i) {
                        this.getArgs().getExpression(i).doParse(psql, plocation);
                    }
                }
                this.getArgs().getExpression(0).doParse(psql, plocation);
                break;
            }
            case distinct_t: {
                this.getArgs().getExpression(0).doParse(psql, plocation);
                if (this.getDefaultTable() == null) break;
                this.setReturnTable(this.getReturnTable());
                break;
            }
            case crossjoin_t: {
                this.parseArgs(this.getArgs(), psql, plocation, false);
                this.returnTable = new TTable(new TObjectName(new TSourceToken("crossjoin"), EDbObjectType.table));
                psql.addToTables(this.returnTable);
                break;
            }
            default: {
                if (this.getArgs() == null) break;
                this.parseArgs(this.getArgs(), psql, plocation, false);
            }
        }
        psql.getDaxFunctionStack().pop();
        if (this.returnTable != null) {
            if (psql.getDaxFunctionStack().size() > 0) {
                TDaxFunction function = psql.getDaxFunctionStack().peek();
                function.setDefaultTable(this.returnTable);
            } else {
                ((TDaxStmt)psql).setDefaultTable(this.returnTable);
            }
        }
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }
}

