/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.nodes;

import gudusoft.gsqlparser.EDataType;
import gudusoft.gsqlparser.EExpressionType;
import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TBaseType;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSourceTokenList;
import gudusoft.gsqlparser.nodes.TColumnDefinitionList;
import gudusoft.gsqlparser.nodes.TConstant;
import gudusoft.gsqlparser.nodes.TDatatypeAttribute;
import gudusoft.gsqlparser.nodes.TDummy;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TExpressionList;
import gudusoft.gsqlparser.nodes.TIndices;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TPrecisionScale;
import java.util.HashMap;
import java.util.Map;

public class TTypeName
extends TParseTreeNode {
    private TConstant fractionalSecondsPrecision;
    private boolean byteUnit = false;
    private boolean charUnit = false;
    private boolean varying = false;
    private static Map<String, EDataType> dataTypeMap = new HashMap<String, EDataType>();
    private String charsetName = null;
    private String collationName = null;
    private TColumnDefinitionList columnDefList;
    private TTypeName typeOfList;
    private TTypeName primitiveTypeOfMap;
    private TTypeName typeOfMap;
    private TPTNodeList<TTypeName> colTypeList;
    private String dataTypeName = null;
    private TObjectName dataTypeObjectName = null;
    private EDataType dataType = EDataType.unknown_t;
    private TConstant start;
    private TConstant Max;
    private TConstant Reserve;
    private TConstant length;
    private TConstant precision;
    private TConstant scale;
    private TConstant secondsPrecision;
    private TPTNodeList<TIndices> arrays;
    private TPTNodeList<TDatatypeAttribute> datatypeAttributeList;
    private int type = 2;
    public static final int lfdUnknown = 2;
    public static final int lfdGeneric = 3;
    public static final int lfdFloat = 4;
    public static final int lfdDoublePrecision = 8;
    public static final int lfdDecimal = 9;
    public static final int lfdDec = 10;
    public static final int lfdNumeric = 11;
    public static final int lfdnumber = 12;
    public static final int lfdNum = 13;
    public static final int lfdInteger = 14;
    public static final int lfdBit = 22;
    public static final int lfdBoolean = 23;
    public static final int lfdVarbinary = 33;
    public static final int lfdBinary = 34;
    public static final int lfdInt = 40;
    public static final int lfdSmallint = 41;
    public static final int lfdReal = 42;
    public static final int lfdTinyInt = 43;
    public static final int lfdBigInt = 45;
    public static final int lfdCharacter = 46;
    public static final int lfdChar = 47;
    public static final int lfdVarchar = 48;
    public static final int lfdVarchar2 = 49;
    public static final int lfdLongvarchar = 56;
    public static final int lfdLongvarbinary = 57;
    public static final int lfdYear = 59;
    public static final int lfdNationalChar = 61;
    public static final int lfdNchar = 62;
    public static final int lfdDate = 63;
    public static final int lfdTimestamp = 64;
    public static final int lfdTimeStampWithTZ = 65;
    public static final int lfdTimeStampWithLTZ = 66;
    public static final int lfdTime = 68;
    public static final int lfdDatetime = 69;
    public static final int lfdIntervalYTM = 71;
    public static final int lfdIntervalDTS = 72;
    public static final int lfdLong = 73;
    public static final int lfdRaw = 74;
    public static final int lfdLongRaw = 75;
    public static final int lfdBlob = 76;
    public static final int lfdClob = 77;
    public static final int lfdNClob = 78;
    public static final int lfdBfile = 79;
    public static final int lfdTinyblob = 81;
    public static final int lfdMediumblob = 82;
    public static final int lfdLongblob = 83;
    public static final int lfdTinytext = 84;
    public static final int lfdText = 85;
    public static final int lfdntext = 86;
    public static final int lfdMediumtext = 88;
    public static final int lfdLongtext = 89;
    public static final int lfdURowid = 90;
    public static final int lfdEnum = 91;
    public static final int lfdBinaryLargeObject = 102;
    public static final int lfdGraphic = 103;
    public static final int lfdVarGraphic = 104;
    public static final int lfdLongVarGraphic = 105;
    public static final int lfdDatalink = 106;
    public static final int lfdBinaryInteger = 107;
    public static final int lfdPlsInteger = 108;
    public static final int lfdByteint = 120;
    public static final int lfdTimeWithTZ = 121;
    public static final int lfdIntervalYear = 130;
    public static final int lfdIntervalYearToMonth = 131;
    public static final int lfdIntervalMonth = 132;
    public static final int lfdIntervalDay = 133;
    public static final int lfdIntervalDayToHour = 134;
    public static final int lfdIntervalDayToMinute = 135;
    public static final int lfdIntervalDayToSecond = 136;
    public static final int lfdIntervalHour = 137;
    public static final int lfdIntervalHourToMinute = 138;
    public static final int lfdIntervalHourToSecond = 139;
    public static final int lfdIntervalMinute = 140;
    public static final int lfdIntervalMinuteToSecond = 141;
    public static final int lfdIntervalSecond = 142;
    public static final int lfdByte = 143;
    public static final int lfdVarByte = 144;
    public static final int lfdCharacterVarying = 145;
    public static final int lfdCharVarying = 146;
    public static final int lfdPeriod = 147;
    public static final int lfdCharacterLargeObject = 148;
    public static final int lfdGeoMetry = 150;
    public static final int lfdGeoGraphy = 151;
    public static final int lfdNationalCharVarying = 162;
    public static final int lfdNcharVarying = 163;
    public static final int lfdSet = 164;
    public static final int lfdCharLargeObject = 171;
    public static final int lfdDBClob = 172;
    public static final int lfdInterval = 181;
    public static final int lfdTypeAtribute = 107;
    public static final int lfdRowTypeAtribute = 108;

    public TTypeName() {
    }

    public TTypeName(EDataType dataType) {
        this.dataType = dataType;
    }

    public TTypeName(EDataType dataType, TConstant length) {
        this(dataType);
        switch (this.dataType) {
            case time_t: 
            case timetz_t: 
            case timentz_t: 
            case timestamp_with_time_zone_t: 
            case timestamp_with_local_time_zone_t: {
                this.fractionalSecondsPrecision = length;
                break;
            }
            case interval_year_to_month_t: 
            case interval_day_to_second_t: {
                this.precision = length;
                break;
            }
            default: {
                this.length = length;
            }
        }
    }

    public TTypeName(EDataType dataType, TConstant precision, TConstant scale) {
        this(dataType);
        this.precision = precision;
        switch (this.dataType) {
            case interval_year_to_month_t: 
            case interval_day_to_second_t: {
                this.secondsPrecision = scale;
                break;
            }
            default: {
                this.scale = scale;
            }
        }
    }

    public void setFractionalSecondsPrecision(TConstant fractionalSecondsPrecision) {
        this.fractionalSecondsPrecision = fractionalSecondsPrecision;
    }

    public TConstant getFractionalSecondsPrecision() {
        return this.fractionalSecondsPrecision;
    }

    public boolean isCharUnit() {
        return this.charUnit;
    }

    public boolean isByteUnit() {
        return this.byteUnit;
    }

    public boolean isVarying() {
        return this.varying;
    }

    public static EDataType searchTypeByName(String typenameStr) {
        if (dataTypeMap.size() == 0) {
            dataTypeMap.put("bfile", EDataType.bfile_t);
            dataTypeMap.put("bigint", EDataType.bigint_t);
            dataTypeMap.put("bigserial", EDataType.bigserial_t);
            dataTypeMap.put("binary", EDataType.binary_t);
            dataTypeMap.put("bit", EDataType.bit_t);
            dataTypeMap.put("blob", EDataType.blob_t);
            dataTypeMap.put("boolean", EDataType.boolean_t);
            dataTypeMap.put("byte", EDataType.byte_t);
            dataTypeMap.put("bytea", EDataType.bytea_t);
            dataTypeMap.put("byteint", EDataType.byteint_t);
            dataTypeMap.put("char", EDataType.char_t);
            dataTypeMap.put("character", EDataType.char_t);
            dataTypeMap.put("clob", EDataType.clob_t);
            dataTypeMap.put("date", EDataType.date_t);
            dataTypeMap.put("datetime", EDataType.datetime_t);
            dataTypeMap.put("dec", EDataType.dec_t);
            dataTypeMap.put("decimal", EDataType.dec_t);
            dataTypeMap.put("double", EDataType.double_precision_t);
            dataTypeMap.put("double_precision", EDataType.double_precision_t);
            dataTypeMap.put("float", EDataType.float_t);
            dataTypeMap.put("geometry", EDataType.geometry_t);
            dataTypeMap.put("geography", EDataType.geography_t);
            dataTypeMap.put("int", EDataType.int_t);
            dataTypeMap.put("integer", EDataType.int_t);
            dataTypeMap.put("interval", EDataType.interval_t);
            dataTypeMap.put("long", EDataType.long_t);
            dataTypeMap.put("long_raw", EDataType.long_raw_t);
            dataTypeMap.put("money", EDataType.money_t);
            dataTypeMap.put("nchar", EDataType.nchar_t);
            dataTypeMap.put("nclob", EDataType.nclob_t);
            dataTypeMap.put("number", EDataType.number_t);
            dataTypeMap.put("numeric", EDataType.numeric_t);
            dataTypeMap.put("nvarchar", EDataType.nvarchar_t);
            dataTypeMap.put("period", EDataType.period_t);
            dataTypeMap.put("real", EDataType.real_t);
            dataTypeMap.put("refcursor", EDataType.refcursor_t);
            dataTypeMap.put("rowid", EDataType.rowid_t);
            dataTypeMap.put("serial", EDataType.serial_t);
            dataTypeMap.put("signtype", EDataType.signtype_t);
            dataTypeMap.put("simple_integer", EDataType.simple_integer_t);
            dataTypeMap.put("smallint", EDataType.smallint_t);
            dataTypeMap.put("string", EDataType.string_t);
            dataTypeMap.put("text", EDataType.text_t);
            dataTypeMap.put("time", EDataType.time_t);
            dataTypeMap.put("timestamp", EDataType.timestamp_t);
            dataTypeMap.put("tinyint", EDataType.tinyint_t);
            dataTypeMap.put("varbinary", EDataType.varbinary_t);
            dataTypeMap.put("varbyte", EDataType.varbyte_t);
            dataTypeMap.put("varchar", EDataType.varchar_t);
        }
        return dataTypeMap.get(typenameStr.toLowerCase());
    }

    public void setCharsetAndCollation(TDummy dummy) {
        if (dummy == null) {
            return;
        }
        if (dummy.node1 != null) {
            this.charsetName = dummy.node1.toString();
        }
        if (dummy.st1 != null) {
            this.collationName = dummy.node2.toString();
        }
    }

    public void setCharsetNameByToken(TSourceToken st) {
        if (st == null) {
            return;
        }
        this.charsetName = st.toString();
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public void setCollationName(String collationName) {
        this.collationName = collationName;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public String getCollationName() {
        return this.collationName;
    }

    public void setColTypeList(TPTNodeList<TTypeName> colTypeList) {
        this.colTypeList = colTypeList;
    }

    public TPTNodeList<TTypeName> getColTypeList() {
        return this.colTypeList;
    }

    public void setColumnDefList(TColumnDefinitionList columnDefList) {
        this.columnDefList = columnDefList;
    }

    public TColumnDefinitionList getColumnDefList() {
        return this.columnDefList;
    }

    public void setTypeOfMap(TTypeName typeOfMap) {
        this.typeOfMap = typeOfMap;
    }

    public void setPrimitiveTypeOfMap(TTypeName primitiveTypeOfMap) {
        this.primitiveTypeOfMap = primitiveTypeOfMap;
    }

    public TTypeName getTypeOfMap() {
        return this.typeOfMap;
    }

    public TTypeName getPrimitiveTypeOfMap() {
        return this.primitiveTypeOfMap;
    }

    public void setTypeOfList(TTypeName typeOfList) {
        this.typeOfList = typeOfList;
    }

    public TTypeName getTypeOfList() {
        return this.typeOfList;
    }

    public void setDataTypeByObjectName(TObjectName objectName) {
        if (objectName == null) {
            return;
        }
        this.dataTypeObjectName = objectName;
        String tokenText = TBaseType.getTextWithoutQuoted(objectName.toString());
        EDataType t = TTypeName.searchTypeByName(tokenText);
        if (t != null) {
            this.dataType = t;
        } else if (this.dataType == EDataType.generic_t) {
            this.dataTypeName = objectName.toString();
        }
    }

    public void setDataTypeByToken(TSourceToken st) {
        if (st == null) {
            return;
        }
        String tokenText = st.getTextWithoutQuoted();
        EDataType t = TTypeName.searchTypeByName(tokenText);
        if (t != null) {
            this.dataType = t;
        } else if (this.dataType == EDataType.generic_t) {
            this.dataTypeName = st.toString();
        }
    }

    public TObjectName getDataTypeObjectName() {
        return this.dataTypeObjectName;
    }

    public String getDataTypeName() {
        switch (this.dataType) {
            case double_precision_t: {
                return "double precision";
            }
            case unsigned_int_t: {
                return "unsigned int";
            }
            case long_raw_t: {
                return "long raw";
            }
            case binary_float_t: {
                return "binary float";
            }
            case binary_double_t: {
                return "binary double";
            }
            case timestamp_with_time_zone_t: 
            case timestamp_with_local_time_zone_t: {
                return "timestamp";
            }
            case interval_year_to_month_t: {
                return "interval year";
            }
            case interval_day_to_second_t: {
                return "interval day";
            }
            case generic_t: {
                if (this.dataTypeName != null) {
                    return this.dataTypeName;
                }
                if (this.getStartToken() != null) {
                    return this.getStartToken().toString();
                }
                return "";
            }
        }
        if (this.dataTypeName != null) {
            return this.dataTypeName;
        }
        String ret = this.getDataType().toString();
        if (ret.endsWith("_t")) {
            ret = ret.substring(0, ret.length() - 2);
        }
        return ret;
    }

    public void setDataType(EDataType dataType) {
        this.dataType = dataType;
    }

    public EDataType getDataType() {
        return this.dataType;
    }

    public void setStart(TConstant start) {
        this.start = start;
    }

    public TConstant getStart() {
        return this.start;
    }

    public void setMax(TConstant max) {
        this.Max = max;
    }

    public void setReserve(TConstant reserve) {
        this.Reserve = reserve;
    }

    public TConstant getMax() {
        return this.Max;
    }

    public TConstant getReserve() {
        return this.Reserve;
    }

    public void setLength(TConstant length) {
        this.length = length;
    }

    public TConstant getLength() {
        return this.length;
    }

    public TConstant getSecondsPrecision() {
        return this.secondsPrecision;
    }

    public void setPrecision(TConstant precision) {
        this.precision = precision;
    }

    public TConstant getScale() {
        return this.scale;
    }

    public TConstant getPrecision() {
        return this.precision;
    }

    public void setScale(TConstant scale) {
        this.scale = scale;
    }

    public void setPrecisionScale(TPrecisionScale precisionScale) {
        if (precisionScale != null) {
            this.precision = precisionScale.getPrecision();
            this.scale = precisionScale.getScale();
        }
    }

    public TPTNodeList<TIndices> getArrays() {
        return this.arrays;
    }

    public void setArrays(TPTNodeList<TIndices> arrays) {
        this.arrays = arrays;
    }

    public void setDatatypeAttributeList(TPTNodeList<TDatatypeAttribute> datatypeAttributeList) {
        this.datatypeAttributeList = datatypeAttributeList;
    }

    public TPTNodeList<TDatatypeAttribute> getDatatypeAttributeList() {
        if (this.datatypeAttributeList == null) {
            this.datatypeAttributeList = new TPTNodeList();
        }
        return this.datatypeAttributeList;
    }

    @Override
    public void init(Object arg1, Object arg2, Object arg3) {
        this.init(arg1, arg2);
        if (arg3 != null) {
            switch (this.dataType) {
                case interval_year_to_month_t: {
                    break;
                }
                case interval_day_to_second_t: 
                case interval_second_t: 
                case interval_minute_to_second_t: 
                case interval_hour_to_second_t: {
                    this.secondsPrecision = (TConstant)arg3;
                    break;
                }
            }
        }
    }

    public void setTypeModifiers(TExpressionList exprList) {
        if (exprList == null) {
            return;
        }
        if (exprList.size() == 1) {
            TExpression e = exprList.getExpression(0);
            if (e.getExpressionType() == EExpressionType.simple_constant_t) {
                this.precision = e.getConstantOperand();
            }
        } else if (exprList.size() == 2) {
            TExpression e1;
            TExpression e = exprList.getExpression(0);
            if (e.getExpressionType() == EExpressionType.simple_constant_t) {
                this.precision = e.getConstantOperand();
            }
            if ((e1 = exprList.getExpression(1)).getExpressionType() == EExpressionType.simple_constant_t) {
                this.scale = e1.getConstantOperand();
            }
        }
    }

    @Override
    public void init(Object arg1, Object arg2) {
        this.init(arg1);
        if (arg2 != null) {
            if (arg2 instanceof TPrecisionScale) {
                this.precision = ((TPrecisionScale)arg2).getPrecision();
                this.scale = ((TPrecisionScale)arg2).getScale();
                if (this.dataType == EDataType.period_t) {
                    this.secondsPrecision = ((TPrecisionScale)arg2).getPrecision();
                }
            } else if (arg2 instanceof TDummy) {
                this.precision = (TConstant)((TDummy)arg2).node1;
            } else if (arg2 instanceof TConstant) {
                this.length = (TConstant)arg2;
            }
            switch (this.dataType) {
                case interval_year_to_month_t: 
                case interval_day_to_second_t: 
                case interval_second_t: 
                case interval_minute_to_second_t: 
                case interval_hour_to_second_t: 
                case interval_hour_to_minute_t: 
                case interval_hour_t: 
                case interval_day_to_minute_t: 
                case interval_day_to_hour_t: 
                case interval_month_t: 
                case interval_year_t: {
                    this.precision = (TConstant)arg2;
                    this.length = null;
                    break;
                }
                case binary_t: 
                case varbinary_t: 
                case bytea_t: 
                case raw_t: 
                case char_t: 
                case nchar_t: 
                case varchar_t: 
                case nvarchar_t: 
                case ntext_t: 
                case long_varbinary_t: 
                case long_varchar_t: {
                    if (arg2 instanceof TConstant) {
                        this.length = (TConstant)arg2;
                    }
                    if (!(arg2 instanceof TDummy)) break;
                    this.length = (TConstant)((TDummy)arg2).node1;
                    break;
                }
                case time_t: 
                case timetz_t: 
                case timentz_t: 
                case timestamp_with_time_zone_t: 
                case timestamp_with_local_time_zone_t: {
                    if (arg2 instanceof TConstant) {
                        this.fractionalSecondsPrecision = (TConstant)arg2;
                    }
                    if (!(arg2 instanceof TDummy)) break;
                    this.fractionalSecondsPrecision = (TConstant)((TDummy)arg2).node1;
                    break;
                }
            }
        }
    }

    @Override
    public void init(Object arg1) {
        this.dataType = (EDataType)((Object)arg1);
    }

    public void setByteUnit(boolean byteUnit) {
        this.byteUnit = byteUnit;
    }

    public void setCharUnit(boolean charUnit) {
        this.charUnit = charUnit;
    }

    public void setVarying(boolean varying) {
        this.varying = varying;
    }

    public void setSecondsPrecision(TConstant secondsPrecision) {
        this.secondsPrecision = secondsPrecision;
    }

    public void setCharUnit(TSourceToken st) {
        if (st == null) {
            return;
        }
        if (st.tokencode == 379) {
            this.charUnit = true;
        } else {
            this.byteUnit = true;
        }
    }

    public void setVarying(TSourceToken st) {
        if (st != null) {
            this.varying = true;
            switch (this.dataType) {
                case char_t: {
                    this.dataType = EDataType.varchar_t;
                    break;
                }
                case nchar_t: {
                    this.dataType = EDataType.nvarchar_t;
                    break;
                }
                case bit_t: {
                    this.dataType = EDataType.varbit_t;
                    break;
                }
            }
        }
    }

    public void setDataTypeInTokens() {
        if (this.getStartToken() == null) {
            return;
        }
        if (this.getEndToken() == null) {
            return;
        }
        TSourceTokenList stlist = this.getStartToken().container;
        TSourceToken st = null;
        int level = 0;
        for (int i = this.getStartToken().posinlist; i <= this.getEndToken().posinlist; ++i) {
            st = stlist.get(i);
            if (st.tokentype == ETokenType.ttleftparenthesis) {
                ++level;
                continue;
            }
            if (st.tokentype == ETokenType.ttrightparenthesis) {
                --level;
                continue;
            }
            if (level != 0) continue;
            st.setDbObjType(30);
        }
        if (this.type == 3 || this.dataType == EDataType.generic_t) {
            this.setDataTypeByToken(this.getStartToken());
        }
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }
}

